/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.spi.OperationService;
import java.util.Hashtable;

@ManagedDescription(value="HazelcastInstance.OperationService")
public class OperationServiceMBean
extends HazelcastMBean<OperationService> {
    private static final int INITIAL_CAPACITY = 3;

    public OperationServiceMBean(HazelcastInstance hazelcastInstance, OperationService operationService, ManagementService service) {
        super(operationService, service);
        Hashtable<String, String> properties = new Hashtable<String, String>(3);
        properties.put("type", ManagementService.quote("HazelcastInstance.OperationService"));
        properties.put("name", ManagementService.quote("operationService" + hazelcastInstance.getName()));
        properties.put("instance", ManagementService.quote(hazelcastInstance.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="responseQueueSize")
    @ManagedDescription(value="The size of the response queue")
    public int getResponseQueueSize() {
        return ((OperationService)this.managedObject).getResponseQueueSize();
    }

    @ManagedAnnotation(value="operationExecutorQueueSize")
    @ManagedDescription(value="The size of the operation executor queue")
    int getOperationExecutorQueueSize() {
        return ((OperationService)this.managedObject).getOperationExecutorQueueSize();
    }

    @ManagedAnnotation(value="runningOperationsCount")
    @ManagedDescription(value="the running operations count")
    public int getRunningOperationsCount() {
        return ((OperationService)this.managedObject).getRunningOperationsCount();
    }

    @ManagedAnnotation(value="remoteOperationCount")
    @ManagedDescription(value="The number of remote operations")
    public int getRemoteOperationsCount() {
        return ((OperationService)this.managedObject).getRemoteOperationsCount();
    }

    @ManagedAnnotation(value="executedOperationCount")
    @ManagedDescription(value="The number of executed operations")
    public long getExecutedOperationCount() {
        return ((OperationService)this.managedObject).getExecutedOperationCount();
    }

    @ManagedAnnotation(value="executedRemoteOperationCount")
    @ManagedDescription(value="The number of executed remote operations")
    public long getExecutedRemoteOperationCount() {
        return ((OperationService)this.managedObject).getExecutedRemoteOperationCount();
    }

    @ManagedAnnotation(value="operationThreadCount")
    @ManagedDescription(value="Number of threads executing operations")
    public long getOperationThreadCount() {
        return ((OperationService)this.managedObject).getPartitionOperationThreadCount();
    }
}

