/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitors;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.monitors.HealthMonitorLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.GarbageCollectorStats;
import com.hazelcast.memory.MemoryStats;
import com.hazelcast.memory.MemoryStatsSupport;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.OperatingSystemMXBeanSupport;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class HealthMonitor
extends Thread {
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final double THRESHOLD = 70.0;
    private final ILogger logger;
    private final Node node;
    private final Runtime runtime;
    private final HealthMonitorLevel logLevel;
    private final int delaySeconds;
    private final ClusterServiceImpl clusterService;
    private final ExecutionService executionService;
    private final EventService eventService;
    private final InternalOperationService operationService;
    private final LockService lockService;
    private final ProxyService proxyService;
    private final ConnectionManager connectionManager;
    private final ClientEngineImpl clientEngine;
    private final ThreadMXBean threadMxBean;

    public HealthMonitor(HazelcastInstanceImpl hazelcastInstance, HealthMonitorLevel logLevel, int delaySeconds) {
        super(hazelcastInstance.node.getHazelcastThreadGroup().getInternalThreadGroup(), hazelcastInstance.node.getHazelcastThreadGroup().getThreadNamePrefix("HealthMonitor"));
        this.setDaemon(true);
        this.node = hazelcastInstance.node;
        this.logger = this.node.getLogger(HealthMonitor.class);
        this.runtime = Runtime.getRuntime();
        this.logLevel = logLevel;
        this.delaySeconds = delaySeconds;
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        this.clusterService = this.node.getClusterService();
        this.executionService = this.node.nodeEngine.getExecutionService();
        this.eventService = this.node.nodeEngine.getEventService();
        this.lockService = (LockService)this.node.nodeEngine.getSharedService("hz:impl:lockService");
        this.operationService = this.node.nodeEngine.getOperationService();
        this.proxyService = this.node.nodeEngine.getProxyService();
        this.clientEngine = this.node.clientEngine;
        this.connectionManager = this.node.connectionManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.logLevel == HealthMonitorLevel.OFF) {
            return;
        }
        try {
            while (this.node.isActive()) {
                switch (this.logLevel) {
                    case NOISY: {
                        HealthMetrics metrics = new HealthMetrics();
                        this.logger.log(Level.INFO, metrics.toString());
                        break;
                    }
                    case SILENT: {
                        HealthMetrics metrics = new HealthMetrics();
                        if (!metrics.exceedsThreshold()) break;
                        this.logger.log(Level.INFO, metrics.toString());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unrecognized logLevel:" + (Object)((Object)this.logLevel));
                    }
                }
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(this.delaySeconds));
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
    }

    public static String percentageString(double p) {
        return String.format("%.2f", p) + "%";
    }

    public static String numberToUnit(long number) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)number > step)) continue;
            return String.format("%3.1f%s", (double)number / step, UNITS[i]);
        }
        return Long.toString(number);
    }

    private class HealthMetrics {
        private final long memoryFree;
        private final long memoryTotal;
        private final long memoryUsed;
        private final long memoryMax;
        private final double memoryUsedOfTotalPercentage;
        private final double memoryUsedOfMaxPercentage;
        private final double processCpuLoad;
        private final double systemLoadAverage;
        private final double systemCpuLoad;
        private final int threadCount;
        private final int peakThreadCount;
        private final long clusterTimeDiff;
        private final int asyncExecutorQueueSize;
        private final int clientExecutorQueueSize;
        private final int queryExecutorQueueSize;
        private final int scheduledExecutorQueueSize;
        private final int systemExecutorQueueSize;
        private final int eventQueueSize;
        private final int pendingInvocationsCount;
        private final double pendingInvocationsPercentage;
        private final int lockCount;
        private final int operationServiceOperationExecutorQueueSize;
        private final int operationServiceOperationPriorityExecutorQueueSize;
        private final int operationServiceOperationResponseQueueSize;
        private final int runningOperationsCount;
        private final int remoteOperationsCount;
        private final int proxyCount;
        private final int clientEndpointCount;
        private final int activeConnectionCount;
        private final int currentClientConnectionCount;
        private final int connectionCount;
        private final int ioExecutorQueueSize;

        public HealthMetrics() {
            this.memoryFree = HealthMonitor.this.runtime.freeMemory();
            this.memoryTotal = HealthMonitor.this.runtime.totalMemory();
            this.memoryUsed = this.memoryTotal - this.memoryFree;
            this.memoryMax = HealthMonitor.this.runtime.maxMemory();
            this.memoryUsedOfTotalPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryTotal;
            this.memoryUsedOfMaxPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryMax;
            this.processCpuLoad = OperatingSystemMXBeanSupport.readLongAttribute("ProcessCpuLoad", -1L);
            this.systemLoadAverage = OperatingSystemMXBeanSupport.getSystemLoadAverage();
            this.systemCpuLoad = OperatingSystemMXBeanSupport.readLongAttribute("SystemCpuLoad", -1L);
            this.threadCount = HealthMonitor.this.threadMxBean.getThreadCount();
            this.peakThreadCount = HealthMonitor.this.threadMxBean.getPeakThreadCount();
            this.clusterTimeDiff = HealthMonitor.this.clusterService.getClusterClock().getClusterTimeDiff();
            this.asyncExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:async").getQueueSize();
            this.clientExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:client").getQueueSize();
            this.queryExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:query").getQueueSize();
            this.scheduledExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:scheduled").getQueueSize();
            this.systemExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:system").getQueueSize();
            this.ioExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:io").getQueueSize();
            this.eventQueueSize = HealthMonitor.this.eventService.getEventQueueSize();
            this.lockCount = HealthMonitor.this.lockService.getAllLocks().size();
            this.operationServiceOperationExecutorQueueSize = HealthMonitor.this.operationService.getOperationExecutorQueueSize();
            this.operationServiceOperationPriorityExecutorQueueSize = HealthMonitor.this.operationService.getPriorityOperationExecutorQueueSize();
            this.operationServiceOperationResponseQueueSize = HealthMonitor.this.operationService.getResponseQueueSize();
            this.runningOperationsCount = HealthMonitor.this.operationService.getRunningOperationsCount();
            this.remoteOperationsCount = HealthMonitor.this.operationService.getRemoteOperationsCount();
            this.pendingInvocationsCount = HealthMonitor.this.operationService.getPendingInvocationCount();
            this.pendingInvocationsPercentage = HealthMonitor.this.operationService.getInvocationUsagePercentage();
            this.proxyCount = HealthMonitor.this.proxyService.getProxyCount();
            this.clientEndpointCount = HealthMonitor.this.clientEngine.getClientEndpointCount();
            this.activeConnectionCount = HealthMonitor.this.connectionManager.getActiveConnectionCount();
            this.currentClientConnectionCount = HealthMonitor.this.connectionManager.getCurrentClientConnections();
            this.connectionCount = HealthMonitor.this.connectionManager.getConnectionCount();
        }

        public boolean exceedsThreshold() {
            if (this.memoryUsedOfMaxPercentage > 70.0) {
                return true;
            }
            if (this.processCpuLoad > 70.0) {
                return true;
            }
            if (this.systemCpuLoad > 70.0) {
                return true;
            }
            return this.pendingInvocationsPercentage > 70.0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("processors=").append(HealthMonitor.this.runtime.availableProcessors()).append(", ");
            sb.append("physical.memory.total=").append(HealthMonitor.numberToUnit(MemoryStatsSupport.totalPhysicalMemory())).append(", ");
            sb.append("physical.memory.free=").append(HealthMonitor.numberToUnit(MemoryStatsSupport.freePhysicalMemory())).append(", ");
            sb.append("swap.space.total=").append(HealthMonitor.numberToUnit(MemoryStatsSupport.totalSwapSpace())).append(", ");
            sb.append("swap.space.free=").append(HealthMonitor.numberToUnit(MemoryStatsSupport.freeSwapSpace())).append(", ");
            sb.append("heap.memory.used=").append(HealthMonitor.numberToUnit(this.memoryUsed)).append(", ");
            sb.append("heap.memory.free=").append(HealthMonitor.numberToUnit(this.memoryFree)).append(", ");
            sb.append("heap.memory.total=").append(HealthMonitor.numberToUnit(this.memoryTotal)).append(", ");
            sb.append("heap.memory.max=").append(HealthMonitor.numberToUnit(this.memoryMax)).append(", ");
            sb.append("heap.memory.used/total=").append(HealthMonitor.percentageString(this.memoryUsedOfTotalPercentage)).append(", ");
            sb.append("heap.memory.used/max=").append(HealthMonitor.percentageString(this.memoryUsedOfMaxPercentage)).append(", ");
            MemoryStats memoryStats = HealthMonitor.this.node.getNodeExtension().getMemoryStats();
            if (memoryStats.getMaxNativeMemory() > 0L) {
                sb.append("native.memory.used=").append(HealthMonitor.numberToUnit(memoryStats.getUsedNativeMemory())).append(", ");
                sb.append("native.memory.free=").append(HealthMonitor.numberToUnit(memoryStats.getFreeNativeMemory())).append(", ");
                sb.append("native.memory.total=").append(HealthMonitor.numberToUnit(memoryStats.getCommittedNativeMemory())).append(", ");
                sb.append("native.memory.max=").append(HealthMonitor.numberToUnit(memoryStats.getMaxNativeMemory())).append(", ");
            }
            GarbageCollectorStats gcStats = memoryStats.getGCStats();
            sb.append("minor.gc.count=").append(gcStats.getMinorCollectionCount()).append(", ");
            sb.append("minor.gc.time=").append(gcStats.getMinorCollectionTime()).append("ms, ");
            sb.append("major.gc.count=").append(gcStats.getMajorCollectionCount()).append(", ");
            sb.append("major.gc.time=").append(gcStats.getMajorCollectionTime()).append("ms, ");
            if (gcStats.getUnknownCollectionCount() > 0L) {
                sb.append("unknown.gc.count=").append(gcStats.getUnknownCollectionCount()).append(", ");
                sb.append("unknown.gc.time=").append(gcStats.getUnknownCollectionTime()).append("ms, ");
            }
            sb.append("load.process=").append(String.format("%.2f", this.processCpuLoad)).append("%, ");
            sb.append("load.system=").append(String.format("%.2f", this.systemCpuLoad)).append("%, ");
            sb.append("load.systemAverage=").append(this.systemLoadAverage >= 0.0 ? String.format("%.2f, ", this.systemLoadAverage) : "n/a, ");
            sb.append("thread.count=").append(this.threadCount).append(", ");
            sb.append("thread.peakCount=").append(this.peakThreadCount).append(", ");
            sb.append("cluster.timeDiff=").append(this.clusterTimeDiff).append(", ");
            sb.append("event.q.size=").append(this.eventQueueSize).append(", ");
            sb.append("executor.q.async.size=").append(this.asyncExecutorQueueSize).append(", ");
            sb.append("executor.q.client.size=").append(this.clientExecutorQueueSize).append(", ");
            sb.append("executor.q.query.size=").append(this.queryExecutorQueueSize).append(", ");
            sb.append("executor.q.scheduled.size=").append(this.scheduledExecutorQueueSize).append(", ");
            sb.append("executor.q.io.size=").append(this.ioExecutorQueueSize).append(", ");
            sb.append("executor.q.system.size=").append(this.systemExecutorQueueSize).append(", ");
            sb.append("executor.q.operation.size=").append(this.operationServiceOperationExecutorQueueSize).append(", ");
            sb.append("executor.q.priorityOperation.size=").append(this.operationServiceOperationPriorityExecutorQueueSize).append(", ");
            sb.append("executor.q.response.size=").append(this.operationServiceOperationResponseQueueSize).append(", ");
            sb.append("lock.count=").append(this.lockCount).append(", ");
            sb.append("operations.remote.size=").append(this.remoteOperationsCount).append(", ");
            sb.append("operations.running.size=").append(this.runningOperationsCount).append(", ");
            sb.append("operations.pending.invocations.count=").append(this.pendingInvocationsCount).append(", ");
            sb.append("operations.pending.invocations.percentage=").append(String.format("%.2f", this.pendingInvocationsPercentage)).append("%, ");
            sb.append("proxy.count=").append(this.proxyCount).append(", ");
            sb.append("clientEndpoint.count=").append(this.clientEndpointCount).append(", ");
            sb.append("connection.active.count=").append(this.activeConnectionCount).append(", ");
            sb.append("client.connection.count=").append(this.currentClientConnectionCount).append(", ");
            sb.append("connection.count=").append(this.connectionCount);
            return sb.toString();
        }
    }
}

