/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.GenerateMessageTaskFactory;
import com.hazelcast.client.protocol.generator.MessageFactoryModel;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.hazelcast.annotation.GenerateMessageTaskFactory"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CodeGeneratorMessageTaskFactory
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Template messageFactoryTemplate;
    private Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
    private Elements elementUtils;

    @Override
    public void init(ProcessingEnvironment env) {
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.elementUtils = env.getElementUtils();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/"));
        try {
            this.messageFactoryTemplate = cfg.getTemplate("messagefactory-template-java.ftl");
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        Set<? extends Element> elementsAnnotatedWith = env.getElementsAnnotatedWith(GenerateMessageTaskFactory.class);
        if (elementsAnnotatedWith == null || elementsAnnotatedWith.size() == 0) {
            return false;
        }
        boolean isEnterprise = false;
        for (Element element : elementsAnnotatedWith) {
            isEnterprise = element.toString().contains("enterprise");
            this.map.put(element.toString(), this.addAllFromPackage((PackageElement)element));
        }
        String className = isEnterprise ? "EnterpriseMessageTaskFactoryImpl" : "MessageTaskFactoryImpl";
        MessageFactoryModel messageFactoryModel = new MessageFactoryModel(className, this.map);
        String content = this.generateFromTemplate(this.messageFactoryTemplate, messageFactoryModel);
        this.saveClass("com.hazelcast.client.impl.protocol", className, content);
        return true;
    }

    private Map<String, String> addAllFromPackage(PackageElement packageElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element element : packageElement.getEnclosedElements()) {
            String fullNameKey;
            DeclaredType superclass;
            List<? extends TypeMirror> typeArguments;
            TypeElement typeElement;
            Set<Modifier> modifiers;
            if (!element.getKind().equals((Object)ElementKind.CLASS) || (modifiers = (typeElement = (TypeElement)element).getModifiers()).contains((Object)Modifier.ABSTRACT) || modifiers.contains((Object)Modifier.PROTECTED) || typeElement.getKind().isInterface() || (typeArguments = (superclass = (DeclaredType)typeElement.getSuperclass()).getTypeArguments()).size() <= 0) continue;
            TypeMirror typeMirror = typeArguments.get(0);
            String key = typeMirror.toString();
            if (key.contains("Codec")) {
                fullNameKey = key.startsWith("com.") ? key : "com.hazelcast.client.impl.protocol.codec." + key;
                map.put(fullNameKey, typeElement.toString());
                continue;
            }
            if (!key.endsWith("Parameters")) continue;
            fullNameKey = key.startsWith("com.") ? key : "com.hazelcast.client.impl.protocol.parameters." + key;
            map.put(fullNameKey, typeElement.toString());
        }
        return map;
    }

    private void saveClass(String packageName, String className, String content) {
        try {
            String fullClassName = packageName + "." + className;
            JavaFileObject file = this.filer.createSourceFile(fullClassName, this.elementUtils.getTypeElement("com.hazelcast.client.impl.ClientEngineImpl"));
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    private String generateFromTemplate(Template template, Object model) {
        String content = null;
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("model", model);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            content = writer.toString();
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return content;
    }
}

