/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nearcache;

import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.impl.NearCacheRecord;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientHeapNearCache<K>
implements ClientNearCache<K, Object> {
    final int maxSize;
    final long maxIdleMillis;
    final long timeToLiveMillis;
    final boolean invalidateOnChange;
    final EvictionPolicy evictionPolicy;
    final InMemoryFormat inMemoryFormat;
    final String mapName;
    final ClientContext context;
    final AtomicBoolean canCleanUp;
    final AtomicBoolean canEvict;
    final ConcurrentMap<K, NearCacheRecord> cache;
    final NearCacheStatsImpl stats;
    private final Comparator<NearCacheRecord> selectedComparator;
    private volatile long lastCleanup;
    private volatile String id;

    public ClientHeapNearCache(String mapName, ClientContext context, NearCacheConfig nearCacheConfig) {
        this.mapName = mapName;
        this.context = context;
        this.maxSize = nearCacheConfig.getMaxSize();
        this.maxIdleMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getMaxIdleSeconds());
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (this.inMemoryFormat != InMemoryFormat.BINARY && this.inMemoryFormat != InMemoryFormat.OBJECT) {
            throw new IllegalArgumentException("Illegal in-memory-format: " + (Object)((Object)this.inMemoryFormat));
        }
        this.timeToLiveMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getTimeToLiveSeconds());
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.selectedComparator = NearCacheRecord.getComparator(this.evictionPolicy);
        this.cache = new ConcurrentHashMap<K, NearCacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
        this.stats = new NearCacheStatsImpl();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void put(K key, Object object) {
        Object value;
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        if (object == null) {
            value = NULL_OBJECT;
        } else {
            SerializationService serializationService = this.context.getSerializationService();
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                value = serializationService.toData(object);
            } else if (this.inMemoryFormat == InMemoryFormat.OBJECT) {
                value = serializationService.toObject(object);
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.cache.put(key, new NearCacheRecord(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                final ClientExecutionService executionService = this.context.getExecutionService();
                executionService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(ClientHeapNearCache.this.selectedComparator);
                            records.addAll(ClientHeapNearCache.this.cache.values());
                            int evictSize = (int)((double)ClientHeapNearCache.this.cache.size() * 0.2);
                            int i = 0;
                            for (NearCacheRecord record : records) {
                                ClientHeapNearCache.this.cache.remove(record.getKey());
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canEvict.set(true);
                        }
                        if (ClientHeapNearCache.this.cache.size() >= ClientHeapNearCache.this.maxSize && ClientHeapNearCache.this.canEvict.compareAndSet(true, false)) {
                            try {
                                executionService.execute(this);
                            }
                            catch (RejectedExecutionException e) {
                                ClientHeapNearCache.this.canEvict.set(true);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ClientHeapNearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : ClientHeapNearCache.this.cache.entrySet()) {
                                if (!((NearCacheRecord)entry.getValue()).isExpired(ClientHeapNearCache.this.maxIdleMillis, ClientHeapNearCache.this.timeToLiveMillis)) continue;
                                ClientHeapNearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    @Override
    public Object get(K key) {
        this.fireTtlCleanup();
        NearCacheRecord record = (NearCacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.isExpired(this.maxIdleMillis, this.timeToLiveMillis)) {
                this.cache.remove(key);
                this.stats.incrementMisses();
                return null;
            }
            if (record.getValue().equals(NULL_OBJECT)) {
                this.stats.incrementMisses();
                return NULL_OBJECT;
            }
            this.stats.incrementHits();
            return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toObject(record.getValue()) : record.getValue();
        }
        this.stats.incrementMisses();
        return null;
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void invalidate(K key) {
        this.cache.remove(key);
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemory = 0L;
        for (NearCacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemory += record.getCost();
        }
        this.stats.setOwnedEntryCount(ownedEntryCount);
        this.stats.setOwnedEntryMemoryCost(ownedEntryMemory);
        return this.stats;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void destroy() {
        this.cache.clear();
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }
}

