/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheRecordStore;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.cache.impl.operation.CacheReplicationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionReplicationEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CacheService
extends AbstractCacheService {
    protected boolean invalidationMessageBatchEnabled;
    protected int invalidationMessageBatchSize;
    protected final ConcurrentMap<String, Queue<CacheSingleInvalidationMessage>> invalidationMessageMap = new ConcurrentHashMap<String, Queue<CacheSingleInvalidationMessage>>();
    protected ScheduledFuture cacheBatchInvalidationMessageSenderScheduler;
    protected final AtomicBoolean cacheBatchInvalidationMessageSenderInProgress = new AtomicBoolean(false);

    @Override
    protected ICacheRecordStore createNewRecordStore(String name, int partitionId) {
        return new CacheRecordStore(name, partitionId, this.nodeEngine, this);
    }

    @Override
    protected void postInit(NodeEngine nodeEngine, Properties properties) {
        super.postInit(nodeEngine, properties);
        this.invalidationMessageBatchEnabled = nodeEngine.getGroupProperties().CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getBoolean();
        if (this.invalidationMessageBatchEnabled) {
            this.invalidationMessageBatchSize = nodeEngine.getGroupProperties().CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getInteger();
            int invalidationMessageBatchFreq = nodeEngine.getGroupProperties().CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS.getInteger();
            this.cacheBatchInvalidationMessageSenderScheduler = nodeEngine.getExecutionService().scheduleAtFixedRate("hz:impl:cacheService:cacheBatchInvalidationMessageSender", new CacheBatchInvalidationMessageSender(), invalidationMessageBatchFreq, invalidationMessageBatchFreq, TimeUnit.SECONDS);
        }
    }

    @Override
    public void reset() {
        CachePartitionSegment[] partitionSegments;
        for (String objectName : this.configs.keySet()) {
            this.destroyCache(objectName, true, null);
        }
        for (CachePartitionSegment partitionSegment : partitionSegments = this.segments) {
            if (partitionSegment == null) continue;
            partitionSegment.clear();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            if (this.cacheBatchInvalidationMessageSenderScheduler != null) {
                this.cacheBatchInvalidationMessageSenderScheduler.cancel(true);
            }
            this.reset();
        }
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        CachePartitionSegment segment = this.segments[event.getPartitionId()];
        CacheReplicationOperation op = new CacheReplicationOperation(segment, event.getReplicaIndex());
        return op.isEmpty() ? null : op;
    }

    public String addInvalidationListener(String name, CacheEventListener listener) {
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:impl:cacheService", name, listener);
        return registration.getId();
    }

    @Override
    public void sendInvalidationEvent(String name, Data key, String sourceUuid) {
        if (key == null) {
            this.sendSingleInvalidationEvent(name, null, sourceUuid);
        } else if (this.invalidationMessageBatchEnabled) {
            this.sendBatchInvalidationEvent(name, key, sourceUuid);
        } else {
            this.sendSingleInvalidationEvent(name, key, sourceUuid);
        }
    }

    protected void sendSingleInvalidationEvent(String name, Data key, String sourceUuid) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (!registrations.isEmpty()) {
            eventService.publishEvent("hz:impl:cacheService", registrations, (Object)new CacheSingleInvalidationMessage(name, key, sourceUuid), name.hashCode());
        }
    }

    protected void sendBatchInvalidationEvent(String name, Data key, String sourceUuid) {
        ConcurrentLinkedQueue<CacheSingleInvalidationMessage> newInvalidationMessageQueue;
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (registrations.isEmpty()) {
            return;
        }
        ConcurrentLinkedQueue<CacheSingleInvalidationMessage> invalidationMessageQueue = (ConcurrentLinkedQueue<CacheSingleInvalidationMessage>)this.invalidationMessageMap.get(name);
        if (invalidationMessageQueue == null && (invalidationMessageQueue = (Queue)this.invalidationMessageMap.putIfAbsent(name, newInvalidationMessageQueue = new ConcurrentLinkedQueue<CacheSingleInvalidationMessage>())) == null) {
            invalidationMessageQueue = newInvalidationMessageQueue;
        }
        CacheSingleInvalidationMessage invalidationMessage = new CacheSingleInvalidationMessage(name, key, sourceUuid);
        invalidationMessageQueue.offer(invalidationMessage);
        if (invalidationMessageQueue.size() >= this.invalidationMessageBatchSize) {
            this.flushInvalidationMessages(name, invalidationMessageQueue);
        }
    }

    protected void flushInvalidationMessages(String cacheName, Queue<CacheSingleInvalidationMessage> invalidationMessageQueue) {
        CacheSingleInvalidationMessage invalidationMessage;
        CacheBatchInvalidationMessage batchInvalidationMessage = new CacheBatchInvalidationMessage(cacheName, invalidationMessageQueue.size());
        while ((invalidationMessage = invalidationMessageQueue.poll()) != null) {
            batchInvalidationMessage.addInvalidationMessage(invalidationMessage);
        }
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", cacheName);
        if (!registrations.isEmpty()) {
            eventService.publishEvent("hz:impl:cacheService", registrations, (Object)batchInvalidationMessage, cacheName.hashCode());
        }
    }

    protected class CacheBatchInvalidationMessageSender
    implements Runnable {
        protected CacheBatchInvalidationMessageSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CacheService.this.cacheBatchInvalidationMessageSenderInProgress.compareAndSet(false, true)) {
                try {
                    for (Map.Entry entry : CacheService.this.invalidationMessageMap.entrySet()) {
                        if (Thread.currentThread().isInterrupted()) {
                            break;
                        }
                        String cacheName = (String)entry.getKey();
                        Queue invalidationMessageQueue = (Queue)entry.getValue();
                        if (invalidationMessageQueue.size() <= 0) continue;
                        CacheService.this.flushInvalidationMessages(cacheName, invalidationMessageQueue);
                    }
                }
                finally {
                    CacheService.this.cacheBatchInvalidationMessageSenderInProgress.set(false);
                }
            }
        }
    }
}

