/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.TransactionLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecoveredTransaction
implements DataSerializable {
    private List<TransactionLog> txLogs;
    private SerializableXID xid;
    private String callerUuid;
    private String txnId;
    private long timeoutMillis;
    private long startTime;

    public List<TransactionLog> getTxLogs() {
        return this.txLogs;
    }

    public void setTxLogs(List<TransactionLog> txLogs) {
        this.txLogs = txLogs;
    }

    public SerializableXID getXid() {
        return this.xid;
    }

    public void setXid(SerializableXID xid) {
        this.xid = xid;
    }

    public String getCallerUuid() {
        return this.callerUuid;
    }

    public void setCallerUuid(String callerUuid) {
        this.callerUuid = callerUuid;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.xid);
        out.writeUTF(this.callerUuid);
        out.writeUTF(this.txnId);
        out.writeLong(this.timeoutMillis);
        out.writeLong(this.startTime);
        out.writeInt(this.txLogs.size());
        for (TransactionLog txLog : this.txLogs) {
            out.writeObject(txLog);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.xid = (SerializableXID)in.readObject();
        this.callerUuid = in.readUTF();
        this.txnId = in.readUTF();
        this.timeoutMillis = in.readLong();
        this.startTime = in.readLong();
        int size = in.readInt();
        this.txLogs = new ArrayList<TransactionLog>(size);
        for (int i = 0; i < size; ++i) {
            TransactionLog log = (TransactionLog)in.readObject();
            this.txLogs.add(log);
        }
    }
}

