/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.UrgentSystemOperation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

@SuppressWarnings(value={"EI_EXPOSE_REP"})
public class ReplicaSyncResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation {
    private List<Operation> tasks;
    private long[] replicaVersions;

    public ReplicaSyncResponse() {
    }

    public ReplicaSyncResponse(List<Operation> data, long[] replicaVersions) {
        this.tasks = data;
        this.replicaVersions = replicaVersions;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        InternalPartitionImpl partition = partitionService.getPartitionImpl(partitionId);
        Address thisAddress = nodeEngine.getThisAddress();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        try {
            if (replicaIndex == currentReplicaIndex) {
                this.executeTasks();
            } else {
                this.logNodeNotOwnsBackup(partitionId, replicaIndex, currentReplicaIndex);
            }
            if (this.tasks != null) {
                this.tasks.clear();
            }
        }
        finally {
            this.postProcessReplicaSync(partitionService, currentReplicaIndex);
        }
    }

    private void postProcessReplicaSync(InternalPartitionServiceImpl partitionService, int currentReplicaIndex) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (replicaIndex == currentReplicaIndex) {
            partitionService.finalizeReplicaSync(partitionId, replicaIndex, this.replicaVersions);
        } else {
            partitionService.clearReplicaSync(partitionId, replicaIndex);
            if (currentReplicaIndex < 0) {
                partitionService.clearPartitionReplicaVersions(partitionId);
            } else if (currentReplicaIndex > 0) {
                partitionService.triggerPartitionReplicaSync(partitionId, currentReplicaIndex, 0L);
            }
        }
    }

    private void logNodeNotOwnsBackup(int partitionId, int replicaIndex, int currentReplicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("This node is not backup replica of partition: " + partitionId + ", replica: " + replicaIndex + " anymore. Current replica index: " + currentReplicaIndex);
        }
    }

    private void executeTasks() {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (this.tasks != null && this.tasks.size() > 0) {
            NodeEngine nodeEngine = this.getNodeEngine();
            this.logApplyReplicaSync(partitionId, replicaIndex);
            for (Operation op : this.tasks) {
                try {
                    ErrorLoggingResponseHandler responseHandler = new ErrorLoggingResponseHandler(nodeEngine.getLogger(op.getClass()));
                    op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex).setResponseHandler(responseHandler);
                    op.beforeRun();
                    op.run();
                    op.afterRun();
                }
                catch (Throwable e) {
                    this.logException(op, e);
                }
            }
        } else {
            this.logEmptyTaskList(partitionId, replicaIndex);
        }
    }

    private void logEmptyTaskList(int partitionId, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("No data available for replica sync, partition: " + partitionId + ", replica: " + replicaIndex);
        }
    }

    private void logException(Operation op, Throwable e) {
        Level level;
        ILogger logger = this.getLogger();
        NodeEngine nodeEngine = this.getNodeEngine();
        Level level2 = level = nodeEngine.isActive() ? Level.WARNING : Level.FINEST;
        if (logger.isLoggable(level)) {
            logger.log(level, "While executing " + op, e);
        }
    }

    private void logApplyReplicaSync(int partitionId, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Applying replica sync for partition: " + partitionId + ", replica: " + replicaIndex);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLongArray(this.replicaVersions);
        int size = this.tasks != null ? this.tasks.size() : 0;
        out.writeInt(size);
        if (size > 0) {
            for (Operation task : this.tasks) {
                out.writeObject(task);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.replicaVersions = in.readLongArray();
        int size = in.readInt();
        if (size > 0) {
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation op = (Operation)in.readObject();
                this.tasks.add(op);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncResponse");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append('}');
        return sb.toString();
    }

    private static final class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

