/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.MigrationEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

final class PromoteFromBackupOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final Address deadAddress;

    public PromoteFromBackupOperation(Address deadAddress) {
        this.deadAddress = deadAddress;
    }

    @Override
    public void beforeRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.logPromotingPartition();
        try {
            this.setMissingReplicaVersions();
            PartitionMigrationEvent event = this.createPartitionMigrationEvent();
            this.sendToAllMigrationAwareServices(event);
        }
        finally {
            this.clearPartitionMigratingFlag();
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.COMPLETED);
    }

    private void setMissingReplicaVersions() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        long[] versions = service.getPartitionReplicaVersions(this.getPartitionId());
        long version = 0L;
        int ix = -1;
        for (int i = 0; i < versions.length; ++i) {
            if (versions[i] <= 0L) continue;
            version = versions[i];
            ix = i;
            break;
        }
        ILogger logger = this.getLogger();
        boolean loggable = ix > 0 && logger.isFinestEnabled();
        String log = null;
        if (loggable) {
            log = "Setting missing replica versions for partition: " + this.getPartitionId() + " Changed from " + Arrays.toString(versions);
        }
        for (int i = 0; i < ix; ++i) {
            versions[i] = version;
        }
        if (loggable) {
            log = log + " to " + Arrays.toString(versions);
            logger.finest(log);
        }
    }

    private void sendMigrationEvent(MigrationEvent.MigrationStatus status) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        MemberImpl localMember = nodeEngine.getLocalMember();
        MemberImpl deadMember = new MemberImpl(this.deadAddress, false);
        MigrationEvent event = new MigrationEvent(partitionId, deadMember, localMember, status);
        EventService eventService = nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:core:partitionService", "hz:core:partitionService");
        eventService.publishEvent("hz:core:partitionService", registrations, (Object)event, partitionId);
    }

    private void clearPartitionMigratingFlag() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = service.getPartition(this.getPartitionId());
        partition.setMigrating(false);
    }

    private void sendToAllMigrationAwareServices(PartitionMigrationEvent event) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            try {
                service.beforeMigration(event);
                service.commitMigration(event);
            }
            catch (Throwable e) {
                this.logMigrationError(e);
            }
        }
    }

    private PartitionMigrationEvent createPartitionMigrationEvent() {
        int partitionId = this.getPartitionId();
        return new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, partitionId);
    }

    private void logMigrationError(Throwable e) {
        ILogger logger = this.getLogger();
        logger.warning("While promoting partition " + this.getPartitionId(), e);
    }

    private void logPromotingPartition() {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Promoting partition " + this.getPartitionId());
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

