/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EventData;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapEventFilter;
import com.hazelcast.multimap.impl.MultiMapEventsDispatcher;
import com.hazelcast.multimap.impl.MultiMapEventsPublisher;
import com.hazelcast.multimap.impl.MultiMapPartitionContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapWrapper;
import com.hazelcast.multimap.impl.ObjectMultiMapProxy;
import com.hazelcast.multimap.impl.operations.MultiMapMigrationOperation;
import com.hazelcast.multimap.impl.txn.TransactionalMultiMapProxy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MultiMapService
implements ManagedService,
RemoteService,
MigrationAwareService,
EventPublishingService<EventData, EntryListener>,
TransactionalService {
    public static final String SERVICE_NAME = "hz:impl:multiMapService";
    private static final int STATS_MAP_INITIAL_CAPACITY = 1000;
    private static final int REPLICA_ADDRESS_TRY_COUNT = 3;
    private static final int REPLICA_ADDRESS_SLEEP_WAIT_MILLIS = 1000;
    private final NodeEngine nodeEngine;
    private final MultiMapPartitionContainer[] partitionContainers;
    private final ConcurrentMap<String, LocalMultiMapStatsImpl> statsMap = new ConcurrentHashMap<String, LocalMultiMapStatsImpl>(1000);
    private final ConstructorFunction<String, LocalMultiMapStatsImpl> localMultiMapStatsConstructorFunction = new ConstructorFunction<String, LocalMultiMapStatsImpl>(){

        @Override
        public LocalMultiMapStatsImpl createNew(String key) {
            return new LocalMultiMapStatsImpl();
        }
    };
    private final ILogger logger;
    private final MultiMapEventsDispatcher dispatcher;
    private final MultiMapEventsPublisher publisher;

    public MultiMapService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.partitionContainers = new MultiMapPartitionContainer[partitionCount];
        this.logger = nodeEngine.getLogger(MultiMapService.class);
        this.dispatcher = new MultiMapEventsDispatcher(this, nodeEngine.getClusterService());
        this.publisher = new MultiMapEventsPublisher(nodeEngine);
    }

    @Override
    public void init(final NodeEngine nodeEngine, Properties properties) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        for (int partition = 0; partition < partitionCount; ++partition) {
            this.partitionContainers[partition] = new MultiMapPartitionContainer(this, partition);
        }
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor(SERVICE_NAME, new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

                @Override
                public LockStoreInfo createNew(ObjectNamespace key) {
                    String name = key.getObjectName();
                    final MultiMapConfig multiMapConfig = nodeEngine.getConfig().findMultiMapConfig(name);
                    return new LockStoreInfo(){

                        @Override
                        public int getBackupCount() {
                            return multiMapConfig.getSyncBackupCount();
                        }

                        @Override
                        public int getAsyncBackupCount() {
                            return multiMapConfig.getAsyncBackupCount();
                        }
                    };
                }
            });
        }
    }

    @Override
    public void reset() {
        for (MultiMapPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroy();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
        for (int i = 0; i < this.partitionContainers.length; ++i) {
            this.partitionContainers[i] = null;
        }
    }

    public MultiMapContainer getOrCreateCollectionContainer(int partitionId, String name) {
        return this.partitionContainers[partitionId].getOrCreateMultiMapContainer(name);
    }

    public MultiMapPartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        return new ObjectMultiMapProxy(this, this.nodeEngine, name);
    }

    @Override
    public void destroyDistributedObject(String name) {
        for (MultiMapPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroyCollection(name);
        }
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    public Set<Data> localKeySet(String name) {
        HashSet<Data> keySet = new HashSet<Data>();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        Address thisAddress = clusterService.getThisAddress();
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            InternalPartition partition = this.nodeEngine.getPartitionService().getPartition(i);
            MultiMapPartitionContainer partitionContainer = this.getPartitionContainer(i);
            MultiMapContainer multiMapContainer = partitionContainer.getCollectionContainer(name);
            if (multiMapContainer == null || !thisAddress.equals(partition.getOwnerOrNull())) continue;
            keySet.addAll(multiMapContainer.keySet());
        }
        this.getLocalMultiMapStatsImpl(name).incrementOtherOperations();
        return keySet;
    }

    public SerializationService getSerializationService() {
        return this.nodeEngine.getSerializationService();
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public void publishMultiMapEvent(String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        this.publisher.publishMultiMapEvent(mapName, eventType, numberOfEntriesAffected);
    }

    public final void publishEntryEvent(String multiMapName, EntryEventType eventType, Data key, Object newValue, Object oldValue) {
        this.publisher.publishEntryEvent(multiMapName, eventType, key, newValue, oldValue);
    }

    public String addListener(String name, EventListener listener, Data key, boolean includeValue, boolean local) {
        EventService eventService = this.nodeEngine.getEventService();
        MultiMapEventFilter filter = new MultiMapEventFilter(includeValue, key);
        EventRegistration registration = local ? eventService.registerLocalListener(SERVICE_NAME, name, filter, listener) : eventService.registerListener(SERVICE_NAME, name, filter, listener);
        return registration.getId();
    }

    public boolean removeListener(String name, String registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int replicaIndex = event.getReplicaIndex();
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[event.getPartitionId()];
        if (partitionContainer == null) {
            return null;
        }
        HashMap<String, Map> map = new HashMap<String, Map>(partitionContainer.containerMap.size());
        for (Map.Entry entry : partitionContainer.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            MultiMapContainer container = (MultiMapContainer)entry.getValue();
            if (container.getConfig().getTotalBackupCount() < replicaIndex) continue;
            map.put(name, container.getMultiMapWrappers());
        }
        if (map.isEmpty()) {
            return null;
        }
        return new MultiMapMigrationOperation(map);
    }

    public void insertMigratedData(int partitionId, Map<String, Map> map) {
        for (Map.Entry<String, Map> entry : map.entrySet()) {
            String name = entry.getKey();
            MultiMapContainer container = this.getOrCreateCollectionContainer(partitionId, name);
            Map collections = entry.getValue();
            long maxRecordId = -1L;
            for (Map.Entry wrapperEntry : collections.entrySet()) {
                MultiMapWrapper wrapper = (MultiMapWrapper)wrapperEntry.getValue();
                container.getMultiMapWrappers().put(wrapperEntry.getKey(), wrapper);
                long wrapperMaxRecordId = this.getMaxRecordId(wrapper);
                maxRecordId = Math.max(maxRecordId, wrapperMaxRecordId);
            }
            container.setId(maxRecordId);
        }
    }

    private long getMaxRecordId(MultiMapWrapper wrapper) {
        long maxRecordId = -1L;
        for (MultiMapRecord record : wrapper.getCollection(false)) {
            maxRecordId = Math.max(maxRecordId, record.getRecordId());
        }
        return maxRecordId;
    }

    private void clearMigrationData(int partitionId) {
        MultiMapPartitionContainer partitionContainer = this.partitionContainers[partitionId];
        if (partitionContainer != null) {
            partitionContainer.containerMap.clear();
        }
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearMigrationData(partitionId);
    }

    public LocalMapStats createStats(String name) {
        LocalMultiMapStatsImpl stats = this.getLocalMultiMapStatsImpl(name);
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        Address thisAddress = clusterService.getThisAddress();
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            Address owner;
            InternalPartition partition = this.nodeEngine.getPartitionService().getPartition(i);
            MultiMapPartitionContainer partitionContainer = this.getPartitionContainer(i);
            MultiMapContainer multiMapContainer = partitionContainer.getCollectionContainer(name);
            if (multiMapContainer == null || (owner = partition.getOwnerOrNull()) == null) continue;
            if (owner.equals(thisAddress)) {
                lockedEntryCount += multiMapContainer.getLockedCount();
                for (MultiMapWrapper wrapper : multiMapContainer.getMultiMapWrappers().values()) {
                    hits += (long)wrapper.getHits();
                    ownedEntryCount += (long)wrapper.getCollection(false).size();
                }
                continue;
            }
            int backupCount = multiMapContainer.getConfig().getTotalBackupCount();
            for (int j = 1; j <= backupCount; ++j) {
                Address replicaAddress = partition.getReplicaAddress(j);
                int memberSize = this.nodeEngine.getClusterService().getMembers().size();
                int tryCount = 3;
                while (memberSize > backupCount && replicaAddress == null && tryCount-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                    replicaAddress = partition.getReplicaAddress(j);
                }
                if (replicaAddress == null || !replicaAddress.equals(thisAddress)) continue;
                for (MultiMapWrapper wrapper : multiMapContainer.getMultiMapWrappers().values()) {
                    backupEntryCount += (long)wrapper.getCollection(false).size();
                }
            }
        }
        stats.setOwnedEntryCount(ownedEntryCount);
        stats.setBackupEntryCount(backupEntryCount);
        stats.setHits(hits);
        stats.setLockedEntryCount(lockedEntryCount);
        return stats;
    }

    public LocalMultiMapStatsImpl getLocalMultiMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localMultiMapStatsConstructorFunction);
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, TransactionSupport transaction) {
        return (T)new TransactionalMultiMapProxy(this.nodeEngine, this, name, transaction);
    }

    @Override
    public void rollbackTransaction(String transactionId) {
    }

    @Override
    public void dispatchEvent(EventData event, EntryListener listener) {
        this.dispatcher.dispatchEvent(event, listener);
    }
}

