/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.BackupResponse;
import com.hazelcast.spi.impl.InternalOperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Arrays;

final class Backup
extends Operation
implements BackupOperation,
IdentifiedDataSerializable {
    private Data backupOpData;
    private Address originalCaller;
    private long[] replicaVersions;
    private boolean sync;
    private Operation backupOp;
    private boolean valid = true;
    private BackupAwareOperation parentOp;

    Backup() {
    }

    Backup(Data backupOp, Address originalCaller, long[] replicaVersions, boolean sync, BackupAwareOperation parentOp) {
        this.backupOpData = backupOp;
        this.originalCaller = originalCaller;
        this.sync = sync;
        this.replicaVersions = replicaVersions;
        this.parentOp = parentOp;
        if (sync && originalCaller == null) {
            throw new IllegalArgumentException("Sync backup requires original caller address, Op: " + backupOp);
        }
    }

    public BackupAwareOperation getParentOp() {
        return this.parentOp;
    }

    @Override
    public void beforeRun() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        InternalPartition partition = nodeEngine.getPartitionService().getPartition(partitionId);
        Address owner = partition.getReplicaAddress(this.getReplicaIndex());
        if (!nodeEngine.getThisAddress().equals(owner)) {
            this.valid = false;
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Wrong target! " + this.toString() + " cannot be processed! Target should be: " + owner);
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (!this.valid) {
            return;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        if (this.backupOpData != null) {
            this.backupOp = (Operation)nodeEngine.getSerializationService().toObject(this.backupOpData);
            this.backupOp.setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
            this.backupOp.setNodeEngine(nodeEngine);
            this.backupOp.setCallerUuid(this.getCallerUuid());
            OperationAccessor.setCallerAddress(this.backupOp, this.getCallerAddress());
            OperationAccessor.setInvocationTime(this.backupOp, Clock.currentTimeMillis());
            this.backupOp.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
            this.backupOp.beforeRun();
            this.backupOp.run();
            this.backupOp.afterRun();
        }
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        partitionService.updatePartitionReplicaVersions(this.getPartitionId(), this.replicaVersions, this.getReplicaIndex());
    }

    @Override
    public void afterRun() throws Exception {
        if (this.valid && this.sync && this.getCallId() != 0L && this.originalCaller != null) {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            long callId = this.getCallId();
            InternalOperationService operationService = nodeEngine.operationService;
            if (!nodeEngine.getThisAddress().equals(this.originalCaller)) {
                BackupResponse backupResponse = new BackupResponse(callId, this.backupOp.isUrgent());
                operationService.send(backupResponse, this.originalCaller);
            } else {
                operationService.notifyBackupCall(callId);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        if (this.backupOp != null) {
            this.backupOp.logError(e);
        } else {
            ReplicaErrorLogger.log(e, this.getLogger());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeData(this.backupOpData);
        if (this.originalCaller != null) {
            out.writeBoolean(true);
            this.originalCaller.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLongArray(this.replicaVersions);
        out.writeBoolean(this.sync);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.backupOpData = in.readData();
        if (in.readBoolean()) {
            this.originalCaller = new Address();
            this.originalCaller.readData(in);
        }
        this.replicaVersions = in.readLongArray();
        this.sync = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Backup");
        sb.append("{backupOpBinary=").append(this.backupOpData);
        sb.append(", originalCaller=").append(this.originalCaller);
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append(", sync=").append(this.sync);
        sb.append('}');
        return sb.toString();
    }
}

