/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.messages.ReplicationMessage;
import com.hazelcast.replicatedmap.impl.record.AbstractBaseReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicatedEntryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedQueryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.VectorClockTimestamp;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ValidationUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractReplicatedRecordStore<K, V>
extends AbstractBaseReplicatedRecordStore<K, V> {
    static final String CLEAR_REPLICATION_MAGIC_KEY = "hz:impl:replicatedMapService$CLEAR$MESSAGE$";
    static final int TOMBSTONE_REMOVAL_PERIOD_MS = 300000;

    public AbstractReplicatedRecordStore(String name, NodeEngine nodeEngine, ReplicatedMapService replicatedMapService) {
        super(name, nodeEngine, replicatedMapService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTombstone(Object key) {
        ValidationUtil.isNotNull(key, "key");
        this.storage.checkState();
        Object marshalledKey = this.marshallKey(key);
        Object object = this.getMutex(marshalledKey);
        synchronized (object) {
            ReplicatedRecord current = this.storage.get(marshalledKey);
            if (current == null || current.getValueInternal() != null) {
                return;
            }
            this.storage.remove(marshalledKey, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Object oldValue;
        ValidationUtil.isNotNull(key, "key");
        long time = Clock.currentTimeMillis();
        this.storage.checkState();
        Object marshalledKey = this.marshallKey(key);
        Object object = this.getMutex(marshalledKey);
        synchronized (object) {
            ReplicatedRecord current = this.storage.get(marshalledKey);
            if (current == null) {
                oldValue = null;
            } else {
                oldValue = current.getValueInternal();
                if (oldValue != null) {
                    current.setValue(null, this.localMemberHash, 300000L);
                    this.scheduleTtlEntry(300000L, marshalledKey, null);
                    VectorClockTimestamp vectorClockTimestamp = current.incrementVectorClock(this.localMember);
                    ReplicationMessage message = this.buildReplicationMessage(key, null, vectorClockTimestamp, 300000L);
                    this.replicationPublisher.publishReplicatedMessage(message);
                }
            }
        }
        Object unmarshalledOldValue = this.unmarshallValue(oldValue);
        this.fireEntryListenerEvent(key, unmarshalledOldValue, null);
        if (this.replicatedMapConfig.isStatisticsEnabled()) {
            this.mapStats.incrementRemoves(Clock.currentTimeMillis() - time);
        }
        return unmarshalledOldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(Object key) {
        Object oldValue;
        ValidationUtil.isNotNull(key, "key");
        long time = Clock.currentTimeMillis();
        this.storage.checkState();
        Object marshalledKey = this.marshallKey(key);
        Object object = this.getMutex(marshalledKey);
        synchronized (object) {
            ReplicatedRecord current = this.storage.get(marshalledKey);
            if (current == null) {
                oldValue = null;
            } else {
                oldValue = current.getValueInternal();
                if (oldValue != null) {
                    current.setValueInternal(null, this.localMemberHash, 300000L);
                    this.scheduleTtlEntry(300000L, marshalledKey, null);
                    current.incrementVectorClock(this.localMember);
                }
            }
        }
        Object unmarshalledOldValue = this.unmarshallValue(oldValue);
        this.fireEntryListenerEvent(key, unmarshalledOldValue, null, EntryEventType.EVICTED);
        if (this.replicatedMapConfig.isStatisticsEnabled()) {
            this.mapStats.incrementRemoves(Clock.currentTimeMillis() - time);
        }
    }

    @Override
    public Object get(Object key) {
        Object value;
        long ttlMillis;
        ValidationUtil.isNotNull(key, "key");
        long time = Clock.currentTimeMillis();
        this.storage.checkState();
        ReplicatedRecord replicatedRecord = this.storage.get(this.marshallKey(key));
        long l = ttlMillis = replicatedRecord == null ? 0L : replicatedRecord.getTtlMillis();
        if (ttlMillis > 0L && Clock.currentTimeMillis() - replicatedRecord.getUpdateTime() >= ttlMillis) {
            replicatedRecord = null;
        }
        Object object = value = replicatedRecord == null ? null : this.unmarshallValue(replicatedRecord.getValue());
        if (this.replicatedMapConfig.isStatisticsEnabled()) {
            this.mapStats.incrementGets(Clock.currentTimeMillis() - time);
        }
        return value;
    }

    @Override
    public Object put(Object key, Object value) {
        ValidationUtil.isNotNull(key, "key");
        ValidationUtil.isNotNull(value, "value");
        this.storage.checkState();
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value, long ttl, TimeUnit timeUnit) {
        ValidationUtil.isNotNull(key, "key");
        ValidationUtil.isNotNull(value, "value");
        ValidationUtil.isNotNull(timeUnit, "timeUnit");
        if (ttl < 0L) {
            throw new IllegalArgumentException("ttl must be a positive integer");
        }
        long time = Clock.currentTimeMillis();
        this.storage.checkState();
        Object oldValue = null;
        Object marshalledKey = this.marshallKey(key);
        Object marshalledValue = this.marshallValue(value);
        Object object = this.getMutex(marshalledKey);
        synchronized (object) {
            ReplicatedRecord old;
            long ttlMillis = ttl == 0L ? 0L : timeUnit.toMillis(ttl);
            ReplicatedRecord record = old = this.storage.get(marshalledKey);
            if (old == null) {
                record = this.buildReplicatedRecord(marshalledKey, marshalledValue, new VectorClockTimestamp(), ttlMillis);
                this.storage.put(marshalledKey, record);
            } else {
                oldValue = old.getValueInternal();
                this.storage.get(marshalledKey).setValue(marshalledValue, this.localMemberHash, ttlMillis);
            }
            if (ttlMillis > 0L) {
                this.scheduleTtlEntry(ttlMillis, marshalledKey, marshalledValue);
            } else {
                this.cancelTtlEntry(marshalledKey);
            }
            VectorClockTimestamp vectorClockTimestamp = record.incrementVectorClock(this.localMember);
            ReplicationMessage message = this.buildReplicationMessage(key, value, vectorClockTimestamp, ttlMillis);
            this.replicationPublisher.publishReplicatedMessage(message);
        }
        Object unmarshalledOldValue = this.unmarshallValue(oldValue);
        this.fireEntryListenerEvent(key, unmarshalledOldValue, value);
        if (this.replicatedMapConfig.isStatisticsEnabled()) {
            this.mapStats.incrementPuts(Clock.currentTimeMillis() - time);
        }
        return unmarshalledOldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        ValidationUtil.isNotNull(key, "key");
        this.storage.checkState();
        this.mapStats.incrementOtherOperations();
        return this.containsKeyAndValue(key);
    }

    private boolean containsKeyAndValue(Object key) {
        ReplicatedRecord replicatedRecord = this.storage.get(this.marshallKey(key));
        return replicatedRecord != null && replicatedRecord.getValue() != null;
    }

    @Override
    public boolean containsValue(Object value) {
        ValidationUtil.isNotNull(value, "value");
        this.storage.checkState();
        this.mapStats.incrementOtherOperations();
        for (Map.Entry entry : this.storage.entrySet()) {
            Object entryValue = entry.getValue().getValue();
            if (value != entryValue && (entryValue == null || !this.unmarshallValue(entryValue).equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set keySet() {
        this.storage.checkState();
        HashSet<Object> keySet = new HashSet<Object>(this.storage.size());
        for (Object key : this.storage.keySet()) {
            if (!this.containsKeyAndValue(key)) continue;
            keySet.add(this.unmarshallKey(key));
        }
        this.mapStats.incrementOtherOperations();
        return keySet;
    }

    @Override
    public Collection values() {
        this.storage.checkState();
        ArrayList<Object> values = new ArrayList<Object>(this.storage.size());
        for (ReplicatedRecord record : this.storage.values()) {
            values.add(this.unmarshallValue(record.getValue()));
        }
        this.mapStats.incrementOtherOperations();
        return values;
    }

    @Override
    public Collection values(Comparator comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    @Override
    public Set entrySet() {
        this.storage.checkState();
        HashSet<AbstractMap.SimpleEntry<Object, Object>> entrySet = new HashSet<AbstractMap.SimpleEntry<Object, Object>>(this.storage.size());
        for (Map.Entry entry : this.storage.entrySet()) {
            Object keyOfEntry = entry.getKey();
            if (!this.containsKeyAndValue(keyOfEntry)) continue;
            Object key = this.unmarshallKey(keyOfEntry);
            Object value = this.unmarshallValue(entry.getValue().getValueInternal());
            entrySet.add(new AbstractMap.SimpleEntry<Object, Object>(key, value));
        }
        this.mapStats.incrementOtherOperations();
        return entrySet;
    }

    @Override
    public ReplicatedRecord getReplicatedRecord(Object key) {
        ValidationUtil.isNotNull(key, "key");
        this.storage.checkState();
        return this.storage.get(this.marshallKey(key));
    }

    @Override
    public boolean isEmpty() {
        this.mapStats.incrementOtherOperations();
        return this.storage.isEmpty();
    }

    @Override
    public int size() {
        this.mapStats.incrementOtherOperations();
        return this.storage.size();
    }

    @Override
    public void clear(boolean distribute, boolean emptyReplicationQueue) {
        this.storage.checkState();
        if (emptyReplicationQueue) {
            this.replicationPublisher.emptyReplicationQueue();
        }
        this.storage.clear();
        if (distribute) {
            this.replicationPublisher.distributeClear(emptyReplicationQueue);
        }
        this.mapStats.incrementOtherOperations();
    }

    @Override
    public String addEntryListener(EntryListener listener, Object key) {
        ValidationUtil.isNotNull(listener, "listener");
        ReplicatedEntryEventFilter eventFilter = new ReplicatedEntryEventFilter(this.marshallKey(key));
        this.mapStats.incrementOtherOperations();
        return this.replicatedMapService.addEventListener(listener, eventFilter, this.getName());
    }

    @Override
    public String addEntryListener(EntryListener listener, Predicate predicate, Object key) {
        ValidationUtil.isNotNull(listener, "listener");
        ReplicatedQueryEventFilter eventFilter = new ReplicatedQueryEventFilter(this.marshallKey(key), predicate);
        this.mapStats.incrementOtherOperations();
        return this.replicatedMapService.addEventListener(listener, eventFilter, this.getName());
    }

    @Override
    public boolean removeEntryListenerInternal(String id) {
        ValidationUtil.isNotNull(id, "id");
        this.mapStats.incrementOtherOperations();
        return this.replicatedMapService.removeEventListener(this.getName(), id);
    }

    private ReplicationMessage buildReplicationMessage(Object key, Object value, VectorClockTimestamp timestamp, long ttlMillis) {
        return new ReplicationMessage<Object, Object>(this.getName(), key, value, timestamp, this.localMember, this.localMemberHash, ttlMillis);
    }

    private ReplicatedRecord buildReplicatedRecord(Object key, Object value, VectorClockTimestamp timestamp, long ttlMillis) {
        return new ReplicatedRecord<Object, Object>(key, value, timestamp, this.localMemberHash, ttlMillis);
    }
}

