/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.instance.Node;
import java.util.concurrent.atomic.AtomicBoolean;

final class SplitBrainHandler
implements Runnable {
    private final Node node;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);

    public SplitBrainHandler(Node node) {
        this.node = node;
    }

    @Override
    public void run() {
        if (this.node.isMaster() && this.node.joined() && this.node.isActive() && !this.node.clusterService.isJoinInProgress() && this.inProgress.compareAndSet(false, true)) {
            try {
                this.searchForOtherClusters();
            }
            finally {
                this.inProgress.set(false);
            }
        }
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            joiner.searchForOtherClusters();
        }
    }
}

