/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.impl.QueuePortableHook;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class TxnOfferRequest
extends BaseTransactionRequest
implements Portable,
SecureRequest {
    String name;
    long timeout;
    Data data;

    public TxnOfferRequest() {
    }

    public TxnOfferRequest(String name, long timeout, Data data) {
        this.name = name;
        this.timeout = timeout;
        this.data = data;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext context = endpoint.getTransactionContext(this.txnId);
        TransactionalQueue<Data> queue = context.getQueue(this.name);
        return queue.offer(this.data, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeout);
        writer.getRawDataOutput().writeData(this.data);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.timeout = reader.readLong("t");
        this.data = reader.getRawDataInput().readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "add");
    }
}

