/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.nio.serialization.Data;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CoalescedWriteBehindQueue
implements WriteBehindQueue<DelayedEntry> {
    protected Map<Data, DelayedEntry> queue;

    public CoalescedWriteBehindQueue() {
        this.queue = new LinkedHashMap<Data, DelayedEntry>();
    }

    public CoalescedWriteBehindQueue(Map<Data, DelayedEntry> queue) {
        this.queue = queue;
    }

    @Override
    public boolean offer(DelayedEntry delayedEntry) {
        if (delayedEntry == null) {
            return false;
        }
        this.calculateStoreTime(delayedEntry);
        Data key = (Data)delayedEntry.getKey();
        this.queue.put(key, delayedEntry);
        return true;
    }

    private void calculateStoreTime(DelayedEntry delayedEntry) {
        Data key = (Data)delayedEntry.getKey();
        DelayedEntry currentEntry = this.queue.get(key);
        if (currentEntry != null) {
            long currentStoreTime = currentEntry.getStoreTime();
            delayedEntry.setStoreTime(currentStoreTime);
        }
    }

    @Override
    public DelayedEntry get(DelayedEntry entry) {
        return this.queue.get(entry.getKey());
    }

    @Override
    public DelayedEntry getFirst() {
        Iterator<DelayedEntry> iterator = this.queue.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public void removeFirst() {
        block0: {
            Set<Data> keySet = this.queue.keySet();
            Iterator<Data> iterator = keySet.iterator();
            if (!iterator.hasNext()) break block0;
            Data key = iterator.next();
            this.queue.remove(key);
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public WriteBehindQueue<DelayedEntry> getSnapShot() {
        return new CoalescedWriteBehindQueue(this.queue);
    }

    @Override
    public void addFront(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        LinkedHashMap<Data, DelayedEntry> newQueue = new LinkedHashMap<Data, DelayedEntry>();
        for (DelayedEntry next : collection) {
            newQueue.put((Data)next.getKey(), next);
        }
        newQueue.putAll(this.queue);
        this.queue = newQueue;
    }

    @Override
    public void addEnd(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (DelayedEntry entry : collection) {
            this.queue.put((Data)entry.getKey(), entry);
        }
    }

    @Override
    public void removeAll(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (DelayedEntry entry : collection) {
            Object value;
            Data entryKey = (Data)entry.getKey();
            Object entryValue = entry.getValue();
            DelayedEntry delayedEntry = this.queue.get(entryKey);
            if (delayedEntry == null || (value = delayedEntry.getValue()) != entryValue) continue;
            this.queue.remove(entryKey);
        }
    }

    @Override
    public List<DelayedEntry> removeAll() {
        List<DelayedEntry> delayedEntries = this.asList();
        this.queue.clear();
        return delayedEntries;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public List<DelayedEntry> asList() {
        Collection<DelayedEntry> values = this.queue.values();
        return new ArrayList<DelayedEntry>(values);
    }

    @Override
    public List<DelayedEntry> filterItems(long now) {
        ArrayList<DelayedEntry> delayedEntries = null;
        Collection<DelayedEntry> values = this.queue.values();
        for (DelayedEntry e : values) {
            if (delayedEntries == null) {
                delayedEntries = new ArrayList<DelayedEntry>();
            }
            if (e.getStoreTime() > now) continue;
            delayedEntries.add(e);
        }
        if (delayedEntries == null) {
            return Collections.emptyList();
        }
        return delayedEntries;
    }

    @Override
    public List<DelayedEntry> get(int count) {
        if (count <= 0) {
            return Collections.emptyList();
        }
        Collection<DelayedEntry> values = this.queue.values();
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DelayedEntry> delayedEntries = new ArrayList<DelayedEntry>(count);
        for (DelayedEntry e : values) {
            if (delayedEntries.size() == count) break;
            delayedEntries.add(e);
        }
        return delayedEntries;
    }
}

