/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

final class NodeShutdownLatch {
    private final Map<String, HazelcastInstanceImpl> registrations;
    private final Semaphore latch;
    private final MemberImpl localMember;

    NodeShutdownLatch(Node node) {
        this.localMember = node.localMember;
        Collection<MemberImpl> memberList = node.clusterService.getMemberList();
        this.registrations = new HashMap<String, HazelcastInstanceImpl>(3);
        HashSet<MemberImpl> members = new HashSet<MemberImpl>(memberList);
        members.remove(this.localMember);
        if (!members.isEmpty()) {
            Map<MemberImpl, HazelcastInstanceImpl> map = HazelcastInstanceFactory.getInstanceImplMap();
            for (Map.Entry<MemberImpl, HazelcastInstanceImpl> entry : map.entrySet()) {
                MemberImpl member = entry.getKey();
                if (!members.contains(member)) continue;
                HazelcastInstanceImpl instance = entry.getValue();
                if (!instance.node.isActive()) continue;
                try {
                    ClusterServiceImpl clusterService = instance.node.clusterService;
                    String id = clusterService.addMembershipListener(new ShutdownMembershipListener());
                    this.registrations.put(id, instance);
                }
                catch (Throwable throwable) {}
            }
        }
        this.latch = new Semaphore(0);
    }

    void await(long time, TimeUnit unit) {
        if (this.registrations.isEmpty()) {
            return;
        }
        int permits = this.registrations.size();
        for (HazelcastInstanceImpl hazelcastInstanceImpl : this.registrations.values()) {
            if (hazelcastInstanceImpl.node.isActive()) continue;
            --permits;
        }
        try {
            this.latch.tryAcquire(permits, time, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (Map.Entry entry : this.registrations.entrySet()) {
            HazelcastInstanceImpl instance = (HazelcastInstanceImpl)entry.getValue();
            try {
                instance.node.clusterService.removeMembershipListener((String)entry.getKey());
            }
            catch (Throwable throwable) {}
        }
        this.registrations.clear();
    }

    private class ShutdownMembershipListener
    implements MembershipListener {
        private ShutdownMembershipListener() {
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
        }

        @Override
        public void memberRemoved(MembershipEvent event) {
            if (NodeShutdownLatch.this.localMember.equals(event.getMember())) {
                NodeShutdownLatch.this.latch.release();
            }
        }

        @Override
        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

