/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.CollectionAddAllOperation;
import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CollectionAddAllRequest
extends CollectionRequest {
    protected List<Data> valueList;

    public CollectionAddAllRequest() {
    }

    public CollectionAddAllRequest(String name, List<Data> valueList) {
        super(name);
        this.valueList = valueList;
    }

    @Override
    protected Operation prepareOperation() {
        return new CollectionAddAllOperation(this.name, this.valueList);
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeInt(this.valueList.size());
        for (Data value : this.valueList) {
            out.writeData(value);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        int size = in.readInt();
        this.valueList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = in.readData();
            this.valueList.add(value);
        }
    }

    @Override
    public String getRequiredAction() {
        return "add";
    }

    @Override
    public String getMethodName() {
        return "addAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.valueList};
    }
}

