/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import com.hazelcast.transaction.client.CommitTransactionRequest;
import com.hazelcast.transaction.client.CreateTransactionRequest;
import com.hazelcast.transaction.client.PrepareTransactionRequest;
import com.hazelcast.transaction.client.RollbackTransactionRequest;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeUnit;

final class TransactionProxy {
    private static final ThreadLocal<Boolean> THREAD_FLAG = new ThreadLocal();
    private final TransactionOptions options;
    private final HazelcastClientInstanceImpl client;
    private final long threadId = Thread.currentThread().getId();
    private final ClientConnection connection;
    private SerializableXID sXid;
    private String txnId;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime;

    TransactionProxy(HazelcastClientInstanceImpl client, TransactionOptions options, ClientConnection connection) {
        this.options = options;
        this.client = client;
        this.connection = connection;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    public long getTimeoutMillis() {
        return this.options.getTimeoutMillis();
    }

    public boolean setTimeoutMillis(long timeoutMillis) {
        if (this.state == Transaction.State.NO_TXN && this.options.getTimeoutMillis() != timeoutMillis) {
            this.options.setTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    void begin() {
        try {
            if (this.state == Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is already active");
            }
            this.checkThread();
            if (THREAD_FLAG.get() != null) {
                throw new IllegalStateException("Nested transactions are not allowed!");
            }
            THREAD_FLAG.set(Boolean.TRUE);
            this.startTime = Clock.currentTimeMillis();
            this.txnId = (String)this.invoke(new CreateTransactionRequest(this.options, this.sXid));
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            this.closeConnection();
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void prepare() {
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            this.checkThread();
            this.checkTimeout();
            this.invoke(new PrepareTransactionRequest());
            this.state = Transaction.State.PREPARED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            this.closeConnection();
            throw ExceptionUtil.rethrow(e);
        }
    }

    void commit(boolean prepareAndCommit) {
        try {
            if (prepareAndCommit && this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            if (!prepareAndCommit && this.state != Transaction.State.PREPARED) {
                throw new TransactionNotActiveException("Transaction is not prepared");
            }
            this.checkThread();
            this.checkTimeout();
            this.invoke(new CommitTransactionRequest(prepareAndCommit));
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.closeConnection();
        }
    }

    void rollback() {
        try {
            if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
                throw new IllegalStateException("Transaction is not active");
            }
            if (this.state == Transaction.State.ROLLING_BACK) {
                this.state = Transaction.State.ROLLED_BACK;
                return;
            }
            this.checkThread();
            try {
                this.invoke(new RollbackTransactionRequest());
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
            this.state = Transaction.State.ROLLED_BACK;
        }
        finally {
            this.closeConnection();
        }
    }

    SerializableXID getXid() {
        return this.sXid;
    }

    void setXid(SerializableXID xid) {
        this.sXid = xid;
    }

    private void closeConnection() {
        THREAD_FLAG.set(null);
    }

    private void checkThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    private void checkTimeout() {
        if (this.startTime + this.options.getTimeoutMillis() < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }

    private <T> T invoke(ClientRequest request) {
        if (request instanceof BaseTransactionRequest) {
            ((BaseTransactionRequest)request).setTxnId(this.txnId);
            ((BaseTransactionRequest)request).setClientThreadId(this.threadId);
        }
        SerializationService ss = this.client.getSerializationService();
        ClientInvocationServiceImpl invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        try {
            ICompletableFuture f = invocationService.send(request, this.connection);
            return ss.toObject(f.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

