/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientReadHandler;
import com.hazelcast.client.connection.nio.ClientWriteHandler;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.RemoveAllListeners;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnection
implements Connection,
Closeable {
    private static final int WAIT_TIME_FOR_PACKETS_TO_BE_CONSUMED = 10;
    private volatile boolean live = true;
    private final ILogger logger = Logger.getLogger(ClientConnection.class);
    private final ClientWriteHandler writeHandler;
    private final ClientReadHandler readHandler;
    private final ClientConnectionManager connectionManager;
    private final int connectionId;
    private final SocketChannelWrapper socketChannelWrapper;
    private volatile Address remoteEndpoint;
    private final ConcurrentMap<Integer, ClientCallFuture> callIdMap = new ConcurrentHashMap<Integer, ClientCallFuture>();
    private final ConcurrentMap<Integer, ClientCallFuture> eventHandlerMap = new ConcurrentHashMap<Integer, ClientCallFuture>();
    private final ByteBuffer readBuffer;
    private final SerializationService serializationService;
    private final ClientExecutionService executionService;
    private final ClientInvocationServiceImpl invocationService;
    private boolean readFromSocket = true;
    private final AtomicInteger packetCount = new AtomicInteger(0);
    private volatile boolean heartBeating = true;

    public ClientConnection(ClientConnectionManager connectionManager, IOSelector in, IOSelector out, int connectionId, SocketChannelWrapper socketChannelWrapper, ClientExecutionService executionService, ClientInvocationServiceImpl invocationService, SerializationService serializationService) throws IOException {
        Socket socket = socketChannelWrapper.socket();
        this.connectionManager = connectionManager;
        this.serializationService = serializationService;
        this.executionService = executionService;
        this.invocationService = invocationService;
        this.socketChannelWrapper = socketChannelWrapper;
        this.connectionId = connectionId;
        this.readHandler = new ClientReadHandler(this, in, socket.getReceiveBufferSize());
        this.writeHandler = new ClientWriteHandler(this, out, socket.getSendBufferSize());
        this.readBuffer = ByteBuffer.allocate(socket.getReceiveBufferSize());
    }

    public void incrementPacketCount() {
        this.packetCount.incrementAndGet();
    }

    public void decrementPacketCount() {
        this.packetCount.decrementAndGet();
    }

    public void registerCallId(ClientCallFuture future) {
        int callId = this.connectionManager.newCallId();
        future.getRequest().setCallId(callId);
        this.callIdMap.put(callId, future);
        if (future.getHandler() != null) {
            this.eventHandlerMap.put(callId, future);
        }
    }

    public ClientCallFuture deRegisterCallId(int callId) {
        return (ClientCallFuture)this.callIdMap.remove(callId);
    }

    public ClientCallFuture deRegisterEventHandler(int callId) {
        return (ClientCallFuture)this.eventHandlerMap.remove(callId);
    }

    public EventHandler getEventHandler(int callId) {
        ClientCallFuture future = (ClientCallFuture)this.eventHandlerMap.get(callId);
        if (future == null) {
            return null;
        }
        return future.getHandler();
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public boolean write(SocketWritable packet) {
        if (!this.live) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + packet);
            }
            return false;
        }
        this.writeHandler.enqueueSocketWritable(packet);
        return true;
    }

    public void init() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.put(StringUtil.stringToBytes("CB1"));
        buffer.put(StringUtil.stringToBytes("JVM"));
        buffer.flip();
        this.socketChannelWrapper.write(buffer);
    }

    public void write(Data data) throws IOException {
        Packet packet = new Packet(data, this.serializationService.getPortableContext());
        int totalSize = packet.size();
        int bufferSize = 32768;
        ByteBuffer buffer = ByteBuffer.allocate(totalSize > 32768 ? 32768 : totalSize);
        boolean complete = false;
        while (!complete) {
            complete = packet.writeTo(buffer);
            buffer.flip();
            try {
                this.socketChannelWrapper.write(buffer);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            buffer.clear();
        }
    }

    public Data read() throws IOException {
        Packet packet = new Packet(this.serializationService.getPortableContext());
        while (true) {
            boolean complete;
            if (this.readFromSocket) {
                int readBytes = this.socketChannelWrapper.read(this.readBuffer);
                if (readBytes == -1) {
                    throw new EOFException("Remote socket closed!");
                }
                this.readBuffer.flip();
            }
            if (complete = packet.readFrom(this.readBuffer)) {
                if (this.readBuffer.hasRemaining()) {
                    this.readFromSocket = false;
                } else {
                    this.readBuffer.compact();
                    this.readFromSocket = true;
                }
                return packet.getData();
            }
            this.readFromSocket = true;
            this.readBuffer.clear();
        }
    }

    @Override
    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean isAlive() {
        return this.live;
    }

    @Override
    public long lastReadTime() {
        return this.readHandler.getLastHandle();
    }

    @Override
    public long lastWriteTime() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannelWrapper.socket().getInetAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getRemoteSocketAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannelWrapper.socket().getPort();
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannelWrapper;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientReadHandler getReadHandler() {
        return this.readHandler;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public Address getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getLocalSocketAddress();
    }

    private void innerClose() throws IOException {
        if (!this.live) {
            return;
        }
        this.live = false;
        if (this.socketChannelWrapper.isOpen()) {
            this.socketChannelWrapper.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
        if (this.socketChannelWrapper.isBlocking()) {
            return;
        }
        if (this.connectionManager.isAlive()) {
            try {
                this.executionService.execute(new CleanResourcesTask());
            }
            catch (RejectedExecutionException e) {
                this.logger.warning("Execution rejected ", e);
            }
        } else {
            this.cleanResources(new ConstructorFunction<Object, Throwable>(){

                @Override
                public Throwable createNew(Object arg) {
                    return new HazelcastException("Client is shutting down!");
                }
            });
        }
    }

    private void cleanResources(ConstructorFunction<Object, Throwable> responseCtor) {
        Iterator iter = this.callIdMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            ((ClientCallFuture)entry.getValue()).notify(responseCtor.createNew(null));
            this.eventHandlerMap.remove(entry.getKey());
        }
        Iterator iterator = this.eventHandlerMap.values().iterator();
        while (iterator.hasNext()) {
            ClientCallFuture future = (ClientCallFuture)iterator.next();
            iterator.remove();
            future.notify(responseCtor.createNew(null));
        }
    }

    public void close(Throwable t) {
        if (!this.live) {
            return;
        }
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        String message = "Connection [" + this.socketChannelWrapper.socket().getRemoteSocketAddress() + "] lost. Reason: ";
        message = t != null ? message + t.getClass().getName() + "[" + t.getMessage() + "]" : message + "Socket explicitly closed";
        this.logger.warning(message);
        if (!this.socketChannelWrapper.isBlocking()) {
            this.connectionManager.onConnectionClose(this);
        }
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    void heartBeatingFailed() {
        if (!this.heartBeating) {
            return;
        }
        RemoveAllListeners request = new RemoveAllListeners();
        this.invocationService.send((ClientRequest)request, this);
        this.heartBeating = false;
        this.connectionManager.onDetectingUnresponsiveConnection(this);
        Iterator iterator = this.eventHandlerMap.values().iterator();
        TargetDisconnectedException response = new TargetDisconnectedException(this.remoteEndpoint);
        while (iterator.hasNext()) {
            ClientCallFuture future = (ClientCallFuture)iterator.next();
            iterator.remove();
            future.notify(response);
        }
    }

    void heartBeatingSucceed() {
        this.heartBeating = true;
    }

    public boolean isHeartBeating() {
        return this.live && this.heartBeating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientConnection{");
        sb.append("live=").append(this.live);
        sb.append(", writeHandler=").append(this.writeHandler);
        sb.append(", readHandler=").append(this.readHandler);
        sb.append(", connectionId=").append(this.connectionId);
        sb.append(", socketChannel=").append(this.socketChannelWrapper);
        sb.append(", remoteEndpoint=").append(this.remoteEndpoint);
        sb.append('}');
        return sb.toString();
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            this.waitForPacketsProcessed();
            ClientConnection.this.cleanResources(new ConstructorFunction<Object, Throwable>(){

                @Override
                public Throwable createNew(Object arg) {
                    return new TargetDisconnectedException(ClientConnection.this.remoteEndpoint);
                }
            });
        }

        private void waitForPacketsProcessed() {
            long begin = System.currentTimeMillis();
            int count = ClientConnection.this.packetCount.get();
            while (count != 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    ClientConnection.this.logger.warning(e);
                    break;
                }
                long elapsed = System.currentTimeMillis() - begin;
                if (elapsed > 5L) {
                    ClientConnection.this.logger.warning("There are packets which are not processed " + count);
                    break;
                }
                count = ClientConnection.this.packetCount.get();
            }
        }
    }
}

