/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheEntry;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.eviction.EvictionChecker;
import com.hazelcast.cache.impl.eviction.EvictionPolicyEvaluator;
import com.hazelcast.cache.impl.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.cache.impl.eviction.EvictionStrategy;
import com.hazelcast.cache.impl.eviction.EvictionStrategyProvider;
import com.hazelcast.cache.impl.maxsize.CacheMaxSizeChecker;
import com.hazelcast.cache.impl.maxsize.impl.EntryCountCacheMaxSizeChecker;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordFactory;
import com.hazelcast.cache.impl.record.CacheRecordMap;
import com.hazelcast.cache.impl.record.SampleableCacheRecordMap;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheEvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.EventServiceImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;

public abstract class AbstractCacheRecordStore<R extends CacheRecord, CRM extends SampleableCacheRecordMap<Data, R>>
implements ICacheRecordStore {
    protected static final int DEFAULT_INITIAL_CAPACITY = 1000;
    protected final String name;
    protected final int partitionId;
    protected final int partitionCount;
    protected final NodeEngine nodeEngine;
    protected final AbstractCacheService cacheService;
    protected final CacheConfig cacheConfig;
    protected CRM records;
    protected CacheStatisticsImpl statistics;
    protected CacheLoader cacheLoader;
    protected CacheWriter cacheWriter;
    protected boolean isEventsEnabled = true;
    protected boolean isEventBatchingEnabled;
    protected ExpiryPolicy defaultExpiryPolicy;
    protected final CacheEvictionConfig evictionConfig;
    protected volatile boolean hasExpiringEntry;
    protected final Map<CacheEventType, Set<CacheEventData>> batchEvent = new HashMap<CacheEventType, Set<CacheEventData>>();
    protected final CacheMaxSizeChecker maxSizeChecker;
    protected final EvictionPolicyEvaluator<Data, R> evictionPolicyEvaluator;
    protected final EvictionChecker evictionChecker;
    protected final EvictionStrategy<Data, R, CRM> evictionStrategy;

    public AbstractCacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, AbstractCacheService cacheService) {
        this.name = name;
        this.partitionId = partitionId;
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.nodeEngine = nodeEngine;
        this.cacheService = cacheService;
        this.cacheConfig = cacheService.getCacheConfig(name);
        if (this.cacheConfig == null) {
            throw new CacheNotExistsException("Cache is already destroyed or not created yet, on " + nodeEngine.getLocalMember());
        }
        this.evictionConfig = this.cacheConfig.getEvictionConfig();
        if (this.evictionConfig == null) {
            throw new IllegalStateException("Eviction config cannot be null");
        }
        this.records = this.createRecordCacheMap();
        if (this.cacheConfig.getCacheLoaderFactory() != null) {
            Factory cacheLoaderFactory = this.cacheConfig.getCacheLoaderFactory();
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        }
        if (this.cacheConfig.getCacheWriterFactory() != null) {
            Factory cacheWriterFactory = this.cacheConfig.getCacheWriterFactory();
            this.cacheWriter = (CacheWriter)cacheWriterFactory.create();
        }
        if (this.cacheConfig.isStatisticsEnabled()) {
            this.statistics = cacheService.createCacheStatIfAbsent(name);
        }
        Factory expiryPolicyFactory = this.cacheConfig.getExpiryPolicyFactory();
        this.defaultExpiryPolicy = (ExpiryPolicy)expiryPolicyFactory.create();
        this.maxSizeChecker = this.createCacheMaxSizeChecker(this.evictionConfig.getSize(), this.evictionConfig.getMaxSizePolicy());
        this.evictionPolicyEvaluator = this.creatEvictionPolicyEvaluator(this.evictionConfig);
        this.evictionChecker = this.createEvictionChecker(this.evictionConfig);
        this.evictionStrategy = this.creatEvictionStrategy(this.evictionConfig);
    }

    protected boolean isReadThrough() {
        return this.cacheConfig.isReadThrough();
    }

    protected boolean isWriteThrough() {
        return this.cacheConfig.isWriteThrough();
    }

    protected boolean isStatisticsEnabled() {
        return this.statistics != null;
    }

    protected abstract CRM createRecordCacheMap();

    protected abstract CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data var1, R var2, long var3, int var5);

    protected abstract <T> R createRecord(T var1, long var2, long var4);

    protected abstract <T> Data valueToData(T var1);

    protected abstract <T> T dataToValue(Data var1);

    protected abstract <T> R valueToRecord(T var1);

    protected abstract <T> T recordToValue(R var1);

    protected abstract Data recordToData(R var1);

    protected abstract R dataToRecord(Data var1);

    protected abstract Data toHeapData(Object var1);

    protected CacheMaxSizeChecker createCacheMaxSizeChecker(int size, CacheEvictionConfig.CacheMaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-Size policy cannot be null");
        }
        if (maxSizePolicy == CacheEvictionConfig.CacheMaxSizePolicy.ENTRY_COUNT) {
            return new EntryCountCacheMaxSizeChecker(size, (CacheRecordMap)this.records, this.partitionCount);
        }
        return null;
    }

    protected EvictionPolicyEvaluator<Data, R> creatEvictionPolicyEvaluator(CacheEvictionConfig cacheEvictionConfig) {
        EvictionPolicy evictionPolicy = cacheEvictionConfig.getEvictionPolicy();
        if (evictionPolicy == null || evictionPolicy == EvictionPolicy.NONE) {
            throw new IllegalArgumentException("Eviction policy cannot be null or NONE");
        }
        return EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(cacheEvictionConfig);
    }

    protected EvictionChecker createEvictionChecker(CacheEvictionConfig cacheEvictionConfig) {
        return new MaxSizeEvictionChecker();
    }

    protected EvictionStrategy<Data, R, CRM> creatEvictionStrategy(CacheEvictionConfig cacheEvictionConfig) {
        return EvictionStrategyProvider.getEvictionStrategy(cacheEvictionConfig);
    }

    protected boolean isEvictionRequired() {
        if (this.maxSizeChecker != null) {
            return this.maxSizeChecker.isReachedToMaxSize();
        }
        return false;
    }

    protected void updateHasExpiringEntry(R record) {
        if (record != null && !this.hasExpiringEntry && record.getExpirationTime() >= 0L) {
            this.hasExpiringEntry = true;
        }
    }

    public boolean isEvictionEnabled() {
        return this.evictionStrategy != null && this.evictionPolicyEvaluator != null;
    }

    @Override
    public int evictIfRequired() {
        int evictedCount = 0;
        if (this.isEvictionEnabled()) {
            evictedCount = this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, this.evictionChecker);
            if (this.isStatisticsEnabled() && evictedCount > 0) {
                this.statistics.increaseCacheEvictions(evictedCount);
            }
        }
        return evictedCount;
    }

    protected Data toData(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof CacheRecord) {
            return this.recordToData((CacheRecord)obj);
        }
        return this.valueToData(obj);
    }

    protected <T> T toValue(Object obj) {
        if (obj instanceof Data) {
            return this.dataToValue((Data)obj);
        }
        if (obj instanceof CacheRecord) {
            return this.recordToValue((CacheRecord)obj);
        }
        return (T)obj;
    }

    protected R toRecord(Object obj) {
        if (obj instanceof Data) {
            return this.dataToRecord((Data)obj);
        }
        if (obj instanceof CacheRecord) {
            return (R)((CacheRecord)obj);
        }
        return this.valueToRecord(obj);
    }

    protected Data toEventData(Object obj) {
        if (this.isEventsEnabled) {
            return this.toHeapData(obj);
        }
        return null;
    }

    protected ExpiryPolicy getExpiryPolicy(ExpiryPolicy expiryPolicy) {
        if (expiryPolicy != null) {
            return expiryPolicy;
        }
        return this.defaultExpiryPolicy;
    }

    public boolean processExpiredEntry(Data key, R record, long now) {
        boolean isExpired;
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (!isExpired) {
            return false;
        }
        this.records.remove(key);
        if (this.isEventsEnabled) {
            this.publishEvent(CacheEventType.EXPIRED, key, null, this.toEventData(record), false, -1);
        }
        return true;
    }

    public R processExpiredEntry(Data key, R record, long expiryTime, long now) {
        boolean isExpired = CacheRecordFactory.isExpiredAt(expiryTime, now);
        if (!isExpired) {
            return record;
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increaseCacheExpiries(1L);
        }
        this.records.remove(key);
        if (this.isEventsEnabled) {
            this.publishEvent(CacheEventType.EXPIRED, key, null, this.toEventData(record), false, -1);
        }
        return null;
    }

    public R accessRecord(R record, ExpiryPolicy expiryPolicy, long now) {
        this.onRecordAccess(record, this.getExpiryPolicy(expiryPolicy), now);
        return record;
    }

    protected void updateGetAndPutStat(boolean isPutSucceed, boolean getValue, boolean oldValueNull, long start) {
        if (this.isStatisticsEnabled()) {
            if (isPutSucceed) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            if (getValue) {
                if (oldValueNull) {
                    this.statistics.increaseCacheMisses(1L);
                } else {
                    this.statistics.increaseCacheHits(1L);
                }
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
            }
        }
    }

    protected long updateAccessDuration(R record, ExpiryPolicy expiryPolicy, long now) {
        long expiryTime = -1L;
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForAccess();
            if (expiryDuration != null) {
                expiryTime = expiryDuration.getAdjustedTime(now);
                record.setExpirationTime(expiryTime);
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        return expiryTime;
    }

    protected long onRecordAccess(R record, ExpiryPolicy expiryPolicy, long now) {
        record.setAccessTime(now);
        record.incrementAccessHit();
        return this.updateAccessDuration(record, expiryPolicy, now);
    }

    protected void updateReplaceStat(boolean result, boolean isHit, long start) {
        if (this.isStatisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (isHit) {
                this.statistics.increaseCacheHits(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
    }

    protected void publishEvent(CacheEventType eventType, Data dataKey, Data dataOldValue, Data dataValue, boolean isOldValueAvailable, int completionId) {
        if (this.isEventBatchingEnabled) {
            CacheEventDataImpl cacheEventData = new CacheEventDataImpl(this.name, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable);
            Set<CacheEventData> cacheEventDatas = this.batchEvent.get((Object)eventType);
            if (cacheEventDatas == null) {
                cacheEventDatas = new HashSet<CacheEventData>();
                this.batchEvent.put(eventType, cacheEventDatas);
            }
            cacheEventDatas.add(cacheEventData);
        } else {
            this.cacheService.publishEvent(this.name, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable, dataKey.hashCode(), completionId);
        }
    }

    protected void publishBatchedEvents(String cacheName, CacheEventType cacheEventType, int orderKey) {
        Set<CacheEventData> cacheEventDatas = this.batchEvent.get((Object)cacheEventType);
        CacheEventSet ces = new CacheEventSet(cacheEventType, cacheEventDatas);
        this.cacheService.publishEvent(cacheName, ces, orderKey);
    }

    protected boolean compare(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    protected long expiryPolicyToTTL(ExpiryPolicy expiryPolicy) {
        if (expiryPolicy == null) {
            return -1L;
        }
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForCreation();
            if (expiryDuration == null || expiryDuration.isEternal()) {
                return -1L;
            }
            long durationAmount = expiryDuration.getDurationAmount();
            TimeUnit durationTimeUnit = expiryDuration.getTimeUnit();
            return TimeUnit.MILLISECONDS.convert(durationAmount, durationTimeUnit);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected ExpiryPolicy ttlToExpirePolicy(long ttl) {
        if (ttl >= 0L) {
            return new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
        }
        return new CreatedExpiryPolicy(Duration.ETERNAL);
    }

    protected R createRecord(long expiryTime) {
        return this.createRecord(null, Clock.currentTimeMillis(), expiryTime);
    }

    protected R createRecord(Object value, long expiryTime) {
        return this.createRecord(value, Clock.currentTimeMillis(), expiryTime);
    }

    protected R createRecord(Data keyData, Object value, long expirationTime, int completionId) {
        R record = this.createRecord(value, expirationTime);
        this.updateHasExpiringEntry(record);
        if (this.isEventsEnabled) {
            Data dataValue = this.toEventData(value);
            this.publishEvent(CacheEventType.CREATED, keyData, null, dataValue, false, completionId);
        }
        return record;
    }

    public R createRecordWithExpiry(Data key, Object value, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId) {
        Duration expiryDuration;
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        try {
            expiryDuration = expiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = expiryDuration.getAdjustedTime(now);
        if (!disableWriteThrough) {
            this.writeThroughCache(key, value);
        }
        if (!CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            R record = this.createRecord(key, value, expiryTime, completionId);
            this.records.put((Data)key, record);
            return record;
        }
        this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
        return null;
    }

    protected void onUpdateRecord(Data key, R record, Object value, Data oldDataValue) {
    }

    protected void onUpdateRecordError(Data key, R record, Object value, Data newDataValue, Data oldDataValue, Throwable error) {
    }

    protected R updateRecord(Data key, R record, Object value, int completionId) {
        Data dataOldValue = null;
        Data dataValue = null;
        Object recordValue = value;
        try {
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: {
                    recordValue = this.toData(value);
                    dataValue = (Data)recordValue;
                    dataOldValue = this.toData(record);
                    break;
                }
                case OBJECT: {
                    if (value instanceof Data) {
                        recordValue = this.dataToValue((Data)value);
                        dataValue = (Data)value;
                    } else {
                        dataValue = this.valueToData(value);
                    }
                    dataOldValue = this.toData(record);
                    break;
                }
                case NATIVE: {
                    recordValue = this.toData(value);
                    dataValue = (Data)recordValue;
                    dataOldValue = this.toData(record);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                }
            }
            Data eventDataKey = this.toEventData(key);
            Data eventDataValue = this.toEventData(dataValue);
            Data eventDataOldValue = this.toEventData(dataOldValue);
            record.setValue((Object)recordValue);
            this.onUpdateRecord(key, record, value, dataOldValue);
            this.updateHasExpiringEntry(record);
            if (this.isEventsEnabled) {
                this.publishEvent(CacheEventType.UPDATED, eventDataKey, eventDataOldValue, eventDataValue, true, completionId);
            }
            return record;
        }
        catch (Throwable error) {
            this.onUpdateRecordError(key, record, value, dataValue, dataOldValue, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    public boolean updateRecordWithExpiry(Data key, Object value, R record, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long expiryTime = -1L;
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForUpdate();
            if (expiryDuration != null) {
                expiryTime = expiryDuration.getAdjustedTime(now);
                record.setExpirationTime(expiryTime);
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        if (!disableWriteThrough) {
            this.writeThroughCache(key, value);
        }
        this.updateRecord(key, record, value, completionId);
        return this.processExpiredEntry(key, record, expiryTime, now) != null;
    }

    protected void onDeleteRecord(Data key, R record, Data dataValue, boolean deleted) {
    }

    protected void onDeleteRecordError(Data key, R record, Data dataValue, boolean deleted, Throwable error) {
    }

    protected boolean deleteRecord(Data key, int completionId) {
        CacheRecord record = (CacheRecord)this.records.remove(key);
        Data dataValue = null;
        try {
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: 
                case OBJECT: 
                case NATIVE: {
                    dataValue = this.toData(record);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                }
            }
            Data eventDataKey = this.toEventData(key);
            Data eventDataValue = this.toEventData(dataValue);
            this.onDeleteRecord(key, record, dataValue, record != null);
            if (this.records.size() == 0) {
                this.hasExpiringEntry = false;
            }
            if (this.isEventsEnabled) {
                this.publishEvent(CacheEventType.REMOVED, eventDataKey, null, eventDataValue, false, completionId);
            }
            return record != null;
        }
        catch (Throwable error) {
            this.onDeleteRecordError(key, record, dataValue, record != null, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    public R readThroughRecord(Data key, long now) {
        Duration expiryDuration;
        Object value = this.readThroughCache(key);
        if (value == null) {
            return null;
        }
        try {
            expiryDuration = this.defaultExpiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = expiryDuration.getAdjustedTime(now);
        if (CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            return null;
        }
        return this.createRecord(key, value, expiryTime, -1);
    }

    public Object readThroughCache(Data key) throws CacheLoaderException {
        if (this.isReadThrough() && this.cacheLoader != null) {
            try {
                Object o = this.dataToValue(key);
                return this.cacheLoader.load(o);
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during load", (Throwable)e);
                }
                throw (CacheLoaderException)e;
            }
        }
        return null;
    }

    public void writeThroughCache(Data key, Object value) throws CacheWriterException {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objKey = this.dataToValue(key);
                Object objValue = this.toValue(value);
                CacheEntry entry = new CacheEntry(objKey, objValue);
                this.cacheWriter.write(entry);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during write", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteCacheEntry(Data key) {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objKey = this.dataToValue(key);
                this.cacheWriter.delete(objKey);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during delete", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteAllCacheEntry(Set<Data> keys) {
        if (this.isWriteThrough() && this.cacheWriter != null && keys != null && !keys.isEmpty()) {
            HashMap keysToDelete = new HashMap();
            for (Data data : keys) {
                Object localKeyObj = this.dataToValue(data);
                keysToDelete.put(localKeyObj, data);
            }
            Set keysObject = keysToDelete.keySet();
            try {
                this.cacheWriter.deleteAll(keysObject);
            }
            catch (Exception exception) {
                if (!(exception instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during deleteAll", (Throwable)exception);
                }
                throw (CacheWriterException)exception;
            }
            finally {
                for (Object undeletedKey : keysObject) {
                    Data undeletedKeyData = (Data)keysToDelete.get(undeletedKey);
                    keys.remove(undeletedKeyData);
                }
            }
        }
    }

    protected Map<Data, Object> loadAllCacheEntry(Set<Data> keys) {
        if (this.cacheLoader != null) {
            Map loaded;
            HashMap keysToLoad = new HashMap();
            for (Data key : keys) {
                Object localKeyObj = this.dataToValue(key);
                keysToLoad.put(localKeyObj, key);
            }
            try {
                loaded = this.cacheLoader.loadAll(keysToLoad.keySet());
            }
            catch (Throwable e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during loadAll", e);
                }
                throw (CacheLoaderException)e;
            }
            HashMap<Data, Object> result = new HashMap<Data, Object>();
            for (Map.Entry entry : keysToLoad.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObject = loaded.get(keyObj);
                Data keyData = (Data)entry.getValue();
                result.put(keyData, valueObject);
            }
            return result;
        }
        return null;
    }

    @Override
    public CacheRecord getRecord(Data key) {
        return (CacheRecord)this.records.get(key);
    }

    @Override
    public void setRecord(Data key, CacheRecord record) {
        this.records.put((Data)key, (CacheRecord)record);
    }

    @Override
    public void putRecord(Data key, CacheRecord record) {
        if (!this.records.containsKey(key)) {
            this.evictIfRequired();
        }
        this.records.put((Data)key, (CacheRecord)record);
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        return (CacheRecord)this.records.remove(key);
    }

    protected void onGet(Data key, ExpiryPolicy expiryPolicy, Object value, R record) {
    }

    protected void onGetError(Data key, ExpiryPolicy expiryPolicy, Object value, R record, Throwable error) {
    }

    @Override
    public Object get(Data key, ExpiryPolicy expiryPolicy) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        Object value = null;
        CacheRecord<Object> record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        try {
            if (record == null || isExpired) {
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheMisses(1L);
                }
                if ((value = this.readThroughCache(key)) == null) {
                    return null;
                }
                record = this.createRecordWithExpiry(key, value, expiryPolicy, now, true, -1);
            } else {
                value = this.recordToValue(record);
                this.onRecordAccess(record, expiryPolicy, now);
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            this.onGet(key, expiryPolicy, value, record);
            return value;
        }
        catch (Throwable error) {
            this.onGetError(key, expiryPolicy, value, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean contains(Data key) {
        long now = Clock.currentTimeMillis();
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        return record != null && !isExpired;
    }

    protected void onPut(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue, boolean disableWriteThrough, R record, Object oldValue, boolean isExpired, boolean isNewPut, boolean isSaveSucceed) {
    }

    protected void onPutError(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue, boolean disableWriteThrough, R record, Object oldValue, boolean wouldBeNewPut, Throwable error) {
    }

    protected Object put(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue, boolean disableWriteThrough, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean isOnNewPut = false;
        Object oldValue = null;
        CacheRecord<Object> record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        try {
            boolean isSaveSucceed;
            if (record == null || isExpired) {
                isOnNewPut = true;
                record = this.createRecordWithExpiry(key, value, expiryPolicy, now, disableWriteThrough, completionId);
                isSaveSucceed = record != null;
            } else {
                if (getValue) {
                    oldValue = this.toValue(record);
                }
                isSaveSucceed = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, disableWriteThrough, completionId);
            }
            this.onPut(key, value, expiryPolicy, caller, getValue, disableWriteThrough, record, oldValue, isExpired, isOnNewPut, isSaveSucceed);
            this.updateGetAndPutStat(isSaveSucceed, getValue, oldValue == null, start);
            this.updateHasExpiringEntry(record);
            return oldValue;
        }
        catch (Throwable error) {
            this.onPutError(key, value, expiryPolicy, caller, getValue, disableWriteThrough, record, oldValue, isOnNewPut, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected Object put(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean getValue, int completionId) {
        return this.put(key, value, expiryPolicy, caller, getValue, false, completionId);
    }

    @Override
    public void put(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        this.put(key, value, expiryPolicy, caller, false, false, completionId);
    }

    @Override
    public Object getAndPut(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        return this.put(key, value, expiryPolicy, caller, true, false, completionId);
    }

    protected void onPutIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean disableWriteThrough, R record, boolean isExpired, boolean isSaveSucceed) {
    }

    protected void onPutIfAbsentError(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean disableWriteThrough, R record, Throwable error) {
    }

    protected boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, boolean disableWriteThrough, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        try {
            boolean result;
            if (record == null || isExpired) {
                result = this.createRecordWithExpiry(key, value, expiryPolicy, now, disableWriteThrough, completionId) != null;
            } else {
                result = false;
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            }
            this.onPutIfAbsent(key, value, expiryPolicy, caller, disableWriteThrough, record, isExpired, result);
            this.updateHasExpiringEntry(record);
            if (result && this.isStatisticsEnabled()) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            return result;
        }
        catch (Throwable error) {
            this.onPutIfAbsentError(key, value, expiryPolicy, caller, disableWriteThrough, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        return this.putIfAbsent(key, value, expiryPolicy, caller, false, completionId);
    }

    protected void onReplace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String caller, boolean getValue, R record, boolean isExpired, boolean replaced) {
    }

    protected void onReplaceError(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String caller, boolean getValue, R record, boolean isExpired, boolean replaced, Throwable error) {
    }

    @Override
    public boolean replace(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            if (record == null || isExpired) {
                replaced = false;
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            } else {
                replaced = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, false, completionId);
            }
            this.onReplace(key, null, value, expiryPolicy, caller, false, record, isExpired, replaced);
            this.updateHasExpiringEntry(record);
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
                if (replaced) {
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.addPutTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return replaced;
        }
        catch (Throwable error) {
            this.onReplaceError(key, null, value, expiryPolicy, caller, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean replace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean isHit = false;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            if (record == null || isExpired) {
                replaced = false;
            } else {
                isHit = true;
                Object currentValue = this.toValue(record);
                if (this.compare(currentValue, this.toValue(oldValue))) {
                    replaced = this.updateRecordWithExpiry(key, newValue, record, expiryPolicy, now, false, completionId);
                } else {
                    this.onRecordAccess(record, expiryPolicy, now);
                    replaced = false;
                }
            }
            if (!replaced) {
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            }
            this.onReplace(key, oldValue, newValue, expiryPolicy, caller, false, record, isExpired, replaced);
            this.updateReplaceStat(replaced, isHit, start);
            this.updateHasExpiringEntry(record);
            return replaced;
        }
        catch (Throwable error) {
            this.onReplaceError(key, oldValue, newValue, expiryPolicy, caller, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public Object getAndReplace(Data key, Object value, ExpiryPolicy expiryPolicy, String caller, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        Object obj = null;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            if (record != null) {
                obj = this.toValue(record);
            }
            if (record == null || isExpired) {
                obj = null;
                replaced = false;
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            } else {
                replaced = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, false, completionId);
            }
            this.onReplace(key, null, value, expiryPolicy, caller, false, record, isExpired, replaced);
            this.updateHasExpiringEntry(record);
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
                if (obj != null) {
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return obj;
        }
        catch (Throwable error) {
            this.onReplaceError(key, null, value, expiryPolicy, caller, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void onRemove(Data key, Object value, String caller, boolean getValue, R record, boolean removed) {
    }

    protected void onRemoveError(Data key, Object value, String caller, boolean getValue, R record, boolean removed, Throwable error) {
    }

    @Override
    public boolean remove(Data key, String caller, int completionId) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        boolean removed = false;
        try {
            if (record == null || isExpired) {
                removed = false;
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            } else {
                removed = this.deleteRecord(key, completionId);
            }
            this.onRemove(key, null, caller, false, record, removed);
            if (this.records.size() == 0) {
                this.hasExpiringEntry = false;
            }
            if (removed && this.isStatisticsEnabled()) {
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            }
            return removed;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, caller, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean remove(Data key, Object value, String caller, int completionId) {
        long now = Clock.currentTimeMillis();
        long start = System.nanoTime();
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        int hitCount = 0;
        boolean removed = false;
        try {
            if (record == null || isExpired) {
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheMisses(1L);
                }
                removed = false;
            } else {
                ++hitCount;
                if (this.compare(this.toValue(record), this.toValue(value))) {
                    this.deleteCacheEntry(key);
                    removed = this.deleteRecord(key, completionId);
                } else {
                    long expiryTime = this.onRecordAccess(record, this.defaultExpiryPolicy, now);
                    this.processExpiredEntry(key, record, expiryTime, now);
                    removed = false;
                }
            }
            if (!removed) {
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            }
            this.onRemove(key, value, caller, false, record, removed);
            if (this.records.size() == 0) {
                this.hasExpiringEntry = false;
            }
            this.updateRemoveStatistics(removed, hitCount, start);
            return removed;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, caller, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    private void updateRemoveStatistics(boolean result, int hitCount, long start) {
        if (result && this.isStatisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            if (hitCount == 1) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
    }

    @Override
    public Object getAndRemove(Data key, String caller, int completionId) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        boolean removed = false;
        try {
            Object obj;
            if (record == null || isExpired) {
                obj = null;
                removed = false;
                this.publishEvent(CacheEventType.COMPLETED, key, null, null, false, completionId);
            } else {
                obj = this.toValue(record);
                removed = this.deleteRecord(key, completionId);
            }
            this.onRemove(key, null, caller, false, record, removed);
            if (this.records.size() == 0) {
                this.hasExpiringEntry = false;
            }
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
                if (obj != null) {
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.increaseCacheRemovals(1L);
                    this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return obj;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, caller, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public MapEntrySet getAll(Set<Data> keySet, ExpiryPolicy expiryPolicy) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        MapEntrySet result = new MapEntrySet();
        for (Data key : keySet) {
            Object value = this.get(key, expiryPolicy);
            if (value == null) continue;
            result.add(key, this.toHeapData(value));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<Data> keys, int completionId) {
        HashSet<Data> keysToClean;
        long now = Clock.currentTimeMillis();
        HashSet<Data> localKeys = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        try {
            this.deleteAllCacheEntry(localKeys);
            keysToClean = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        }
        catch (Throwable throwable) {
            HashSet<Data> keysToClean2 = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
            for (Data key : keysToClean2) {
                this.isEventBatchingEnabled = true;
                CacheRecord record = (CacheRecord)this.records.get(key);
                if (localKeys.contains(key) && record != null) {
                    boolean isExpired = this.processExpiredEntry(key, record, now);
                    if (!isExpired) {
                        this.deleteRecord(key, -1);
                        if (this.isStatisticsEnabled()) {
                            this.statistics.increaseCacheRemovals(1L);
                        }
                    }
                    keys.add(key);
                } else {
                    keys.remove(key);
                }
                this.isEventBatchingEnabled = false;
                this.hasExpiringEntry = false;
            }
            int orderKey = keys.hashCode();
            this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
            this.publishEvent(CacheEventType.COMPLETED, new DefaultData(), null, null, false, completionId);
            throw throwable;
        }
        for (Data key : keysToClean) {
            this.isEventBatchingEnabled = true;
            CacheRecord record = (CacheRecord)this.records.get(key);
            if (localKeys.contains(key) && record != null) {
                boolean isExpired = this.processExpiredEntry(key, record, now);
                if (!isExpired) {
                    this.deleteRecord(key, -1);
                    if (this.isStatisticsEnabled()) {
                        this.statistics.increaseCacheRemovals(1L);
                    }
                }
                keys.add(key);
            } else {
                keys.remove(key);
            }
            this.isEventBatchingEnabled = false;
            this.hasExpiringEntry = false;
        }
        int orderKey = keys.hashCode();
        this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
        this.publishEvent(CacheEventType.COMPLETED, new DefaultData(), null, null, false, completionId);
    }

    @Override
    public Set<Data> loadAll(Set<Data> keys, boolean replaceExistingValues) {
        HashSet<Data> keysLoaded = new HashSet<Data>();
        Map<Data, Object> loaded = this.loadAllCacheEntry(keys);
        if (loaded == null || loaded.isEmpty()) {
            return keysLoaded;
        }
        if (replaceExistingValues) {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                this.put(key, value, null, null, false, true, -1);
                keysLoaded.add(key);
            }
        } else {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                boolean hasPut;
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !(hasPut = this.putIfAbsent(key, value, null, null, true, -1))) continue;
                keysLoaded.add(key);
            }
        }
        return keysLoaded;
    }

    @Override
    public CacheKeyIteratorResult iterator(int tableIndex, int size) {
        return this.records.fetchNext(tableIndex, size);
    }

    @Override
    public Object invoke(Data key, EntryProcessor entryProcessor, Object[] arguments, int completionId) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (isExpired) {
            record = null;
        }
        if (this.isStatisticsEnabled()) {
            if (record == null || isExpired) {
                this.statistics.increaseCacheMisses(1L);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
        }
        CacheEntryProcessorEntry entry = this.createCacheEntryProcessorEntry(key, record, now, completionId);
        Object process = entryProcessor.process((MutableEntry)entry, arguments);
        entry.applyChanges();
        return process;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public CacheStatisticsImpl getCacheStats() {
        return this.statistics;
    }

    @Override
    public CacheConfig getConfig() {
        return this.cacheConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<Data, CacheRecord> getReadOnlyRecords() {
        return Collections.unmodifiableMap(this.records);
    }

    @Override
    public void destroy() {
        this.clear();
        this.closeResources();
        this.closeListeners();
    }

    protected void closeListeners() {
        EventService eventService = this.cacheService.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", this.name);
        for (EventRegistration registration : candidates) {
            if (!(((EventServiceImpl.Registration)registration).getListener() instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)registration)).close();
            }
            catch (IOException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    protected void closeResources() {
        if (this.cacheWriter instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheWriter);
        }
        if (this.cacheLoader instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.cacheLoader);
        }
        if (this.defaultExpiryPolicy instanceof Closeable) {
            IOUtil.closeResource((Closeable)this.defaultExpiryPolicy);
        }
    }

    protected class MaxSizeEvictionChecker
    implements EvictionChecker {
        protected MaxSizeEvictionChecker() {
        }

        @Override
        public boolean isEvictionRequired() {
            if (AbstractCacheRecordStore.this.maxSizeChecker != null) {
                return AbstractCacheRecordStore.this.maxSizeChecker.isReachedToMaxSize();
            }
            return false;
        }
    }
}

