/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.TraceableOperation;
import com.hazelcast.spi.impl.BasicInvocation;
import com.hazelcast.spi.impl.BasicOperationService;
import com.hazelcast.spi.impl.BasicTargetInvocation;
import com.hazelcast.spi.impl.IsStillExecutingOperation;
import com.hazelcast.spi.impl.NormalResponse;
import com.hazelcast.spi.impl.TraceableIsStillExecutingOperation;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class BasicInvocationFuture<E>
implements InternalCompletableFuture<E> {
    private static final int CALL_TIMEOUT = 5000;
    volatile boolean interrupted;
    private BasicInvocation basicInvocation;
    private volatile ExecutionCallbackNode<E> callbackHead;
    private volatile Object response;
    private final BasicOperationService operationService;

    BasicInvocationFuture(BasicOperationService operationService, BasicInvocation basicInvocation, Callback<E> callback) {
        this.basicInvocation = basicInvocation;
        this.operationService = operationService;
        if (callback != null) {
            ExecutorCallbackAdapter adapter = new ExecutorCallbackAdapter(callback);
            this.callbackHead = new ExecutionCallbackNode(adapter, basicInvocation.getAsyncExecutor(), null);
        }
    }

    static long decrementTimeout(long timeout, long diff) {
        if (timeout == Long.MAX_VALUE) {
            return timeout;
        }
        return timeout - diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andThen(ExecutionCallback<E> callback, Executor executor) {
        ValidationUtil.isNotNull(callback, "callback");
        ValidationUtil.isNotNull(executor, "executor");
        BasicInvocationFuture basicInvocationFuture = this;
        synchronized (basicInvocationFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackHead = new ExecutionCallbackNode(callback, executor, this.callbackHead);
        }
    }

    @Override
    public void andThen(ExecutionCallback<E> callback) {
        this.andThen(callback, (Executor)this.basicInvocation.getAsyncExecutor());
    }

    private void runAsynchronous(final ExecutionCallback<E> callback, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object resp = BasicInvocationFuture.this.resolveApplicationResponse(BasicInvocationFuture.this.response);
                        if (resp == null || !(resp instanceof Throwable)) {
                            callback.onResponse(resp);
                        } else {
                            callback.onFailure((Throwable)resp);
                        }
                    }
                    catch (Throwable cause) {
                        ((BasicInvocationFuture)BasicInvocationFuture.this).basicInvocation.logger.severe("Failed asynchronous execution of execution callback: " + callback + "for call " + BasicInvocationFuture.this.basicInvocation, cause);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.basicInvocation.logger.warning("Execution of callback: " + callback + " is rejected!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object offeredResponse) {
        ExecutionCallbackNode<E> callbackChain;
        offeredResponse = this.resolveInternalResponse(offeredResponse);
        BasicInvocationFuture basicInvocationFuture = this;
        synchronized (basicInvocationFuture) {
            if (this.response != null && !(this.response instanceof BasicInvocation.InternalResponse)) {
                this.basicInvocation.logger.info("The InvocationFuture.set method of " + this.basicInvocation + " can only be called once");
                return;
            }
            this.response = offeredResponse;
            if (offeredResponse == BasicInvocation.WAIT_RESPONSE) {
                return;
            }
            callbackChain = this.callbackHead;
            this.callbackHead = null;
            this.notifyAll();
        }
        this.operationService.deregisterInvocation(this.basicInvocation);
        this.notifyCallbacks(callbackChain);
    }

    private void notifyCallbacks(ExecutionCallbackNode<E> callbackChain) {
        while (callbackChain != null) {
            this.runAsynchronous(callbackChain.callback, callbackChain.executor);
            callbackChain = callbackChain.next;
        }
    }

    private Object resolveInternalResponse(Object rawResponse) {
        if (rawResponse == null) {
            throw new IllegalArgumentException("response can't be null: " + this.basicInvocation);
        }
        if (rawResponse instanceof NormalResponse) {
            rawResponse = ((NormalResponse)rawResponse).getValue();
        }
        if (rawResponse == null) {
            rawResponse = BasicInvocation.NULL_RESPONSE;
        }
        return rawResponse;
    }

    @Override
    public E get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.basicInvocation.logger.severe("Unexpected timeout while processing " + this, e);
            return null;
        }
    }

    @Override
    public E getSafely() {
        try {
            return this.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object unresolvedResponse = this.waitForResponse(timeout, unit);
        return (E)this.resolveApplicationResponseOrThrowException(unresolvedResponse);
    }

    private Object waitForResponse(long time, TimeUnit unit) {
        long maxCallTimeoutMs;
        if (this.response != null && this.response != BasicInvocation.WAIT_RESPONSE) {
            return this.response;
        }
        long timeoutMs = BasicInvocationFuture.getTimeoutMs(time, unit);
        boolean longPolling = timeoutMs > (maxCallTimeoutMs = this.getMaxCallTimeoutMs());
        int pollCount = 0;
        while (timeoutMs >= 0L) {
            long pollTimeoutMs = Math.min(maxCallTimeoutMs, timeoutMs);
            long startMs = Clock.currentTimeMillis();
            long lastPollTime = 0L;
            ++pollCount;
            try {
                this.pollResponse(pollTimeoutMs);
                lastPollTime = Clock.currentTimeMillis() - startMs;
                timeoutMs = BasicInvocationFuture.decrementTimeout(timeoutMs, lastPollTime);
                if (this.response == BasicInvocation.WAIT_RESPONSE) continue;
                if (this.response != null) {
                    if (this.response != BasicInvocation.INTERRUPTED_RESPONSE && this.interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.response;
                }
            }
            catch (InterruptedException e) {
                this.interrupted = true;
            }
            if (this.interrupted || !longPolling) continue;
            Address target = this.basicInvocation.getTarget();
            if (this.basicInvocation.nodeEngine.getThisAddress().equals(target)) continue;
            this.basicInvocation.logger.warning("No response for " + lastPollTime + " ms. " + this.toString());
            boolean executing = this.isOperationExecuting(target);
            if (executing || this.response != null) continue;
            return this.newOperationTimeoutException(pollCount, pollTimeoutMs);
        }
        return BasicInvocation.TIMEOUT_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollResponse(long pollTimeoutMs) throws InterruptedException {
        if (pollTimeoutMs > 0L) {
            long currentTimeoutMs = pollTimeoutMs;
            long waitStart = Clock.currentTimeMillis();
            BasicInvocationFuture basicInvocationFuture = this;
            synchronized (basicInvocationFuture) {
                while (currentTimeoutMs > 0L && (this.response == null || this.response == BasicInvocation.WAIT_RESPONSE)) {
                    this.wait(currentTimeoutMs);
                    currentTimeoutMs = pollTimeoutMs - (Clock.currentTimeMillis() - waitStart);
                }
            }
        }
    }

    private long getMaxCallTimeoutMs() {
        return this.basicInvocation.callTimeout > 0L ? this.basicInvocation.callTimeout * 2L : Long.MAX_VALUE;
    }

    private static long getTimeoutMs(long time, TimeUnit unit) {
        long timeoutMs = unit.toMillis(time);
        if (timeoutMs < 0L) {
            timeoutMs = 0L;
        }
        return timeoutMs;
    }

    private Object newOperationTimeoutException(int pollCount, long pollTimeoutMs) {
        boolean hasResponse = this.basicInvocation.potentialResponse == null;
        int backupsExpected = this.basicInvocation.backupsExpected;
        int backupsCompleted = this.basicInvocation.backupsCompleted;
        if (hasResponse) {
            return new OperationTimeoutException("No response for " + pollTimeoutMs * (long)pollCount + " ms." + " Aborting invocation! " + this.toString() + " Not all backups have completed " + " backups-expected:" + backupsExpected + " backups-completed: " + backupsCompleted);
        }
        return new OperationTimeoutException("No response for " + pollTimeoutMs * (long)pollCount + " ms." + " Aborting invocation! " + this.toString() + " No response has been send " + " backups-expected:" + backupsExpected + " backups-completed: " + backupsCompleted);
    }

    private Object resolveApplicationResponseOrThrowException(Object unresolvedResponse) throws ExecutionException, InterruptedException, TimeoutException {
        Object response = this.resolveApplicationResponse(unresolvedResponse);
        if (response == null || !(response instanceof Throwable)) {
            return response;
        }
        if (response instanceof ExecutionException) {
            throw (ExecutionException)response;
        }
        if (response instanceof TimeoutException) {
            throw (TimeoutException)response;
        }
        if (response instanceof InterruptedException) {
            throw (InterruptedException)response;
        }
        if (response instanceof Error) {
            throw (Error)response;
        }
        throw new ExecutionException((Throwable)response);
    }

    private Object resolveApplicationResponse(Object unresolvedResponse) {
        if (unresolvedResponse == BasicInvocation.NULL_RESPONSE) {
            return null;
        }
        if (unresolvedResponse == BasicInvocation.TIMEOUT_RESPONSE) {
            return new TimeoutException("Call " + this.basicInvocation + " encountered a timeout");
        }
        if (unresolvedResponse == BasicInvocation.INTERRUPTED_RESPONSE) {
            return new InterruptedException("Call " + this.basicInvocation + " was interrupted");
        }
        Object response = unresolvedResponse;
        if (this.basicInvocation.resultDeserialized && response instanceof Data && (response = this.basicInvocation.nodeEngine.toObject(response)) == null) {
            return null;
        }
        if (response instanceof NormalResponse) {
            NormalResponse responseObj = (NormalResponse)response;
            if ((response = responseObj.getValue()) == null) {
                return null;
            }
            if (this.basicInvocation.resultDeserialized && response instanceof Data && (response = this.basicInvocation.nodeEngine.toObject(response)) == null) {
                return null;
            }
        }
        if (response instanceof Throwable) {
            Throwable throwable = (Throwable)response;
            if (this.basicInvocation.remote) {
                ExceptionUtil.fixRemoteStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
            }
            return throwable;
        }
        return response;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    private boolean isOperationExecuting(Address target) {
        Boolean executing = Boolean.FALSE;
        try {
            Operation isStillExecuting = this.createCheckOperation();
            BasicTargetInvocation inv = new BasicTargetInvocation(this.basicInvocation.nodeEngine, this.basicInvocation.serviceName, isStillExecuting, target, 0, 0L, 5000L, null, null, true);
            BasicInvocationFuture f = inv.invoke();
            this.basicInvocation.logger.warning("Asking if operation execution has been started: " + this.toString());
            executing = (Boolean)this.basicInvocation.nodeEngine.toObject(f.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            this.basicInvocation.logger.warning("While asking 'is-executing': " + this.toString(), e);
        }
        this.basicInvocation.logger.warning("'is-executing': " + executing + " -> " + this.toString());
        return executing;
    }

    private Operation createCheckOperation() {
        if (this.basicInvocation.op instanceof TraceableOperation) {
            TraceableOperation traceable = (TraceableOperation)((Object)this.basicInvocation.op);
            return new TraceableIsStillExecutingOperation(this.basicInvocation.serviceName, traceable.getTraceIdentifier());
        }
        return new IsStillExecutingOperation(this.basicInvocation.op.getCallId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BasicInvocationFuture{");
        sb.append("invocation=").append(this.basicInvocation.toString());
        sb.append(", done=").append(this.isDone());
        sb.append('}');
        return sb.toString();
    }

    private static final class ExecutorCallbackAdapter<E>
    implements ExecutionCallback<E> {
        private final Callback callback;

        private ExecutorCallbackAdapter(Callback callback) {
            this.callback = callback;
        }

        @Override
        public void onResponse(E response) {
            this.callback.notify(response);
        }

        @Override
        public void onFailure(Throwable t) {
            this.callback.notify(t);
        }
    }

    private static final class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

