/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import java.io.IOException;

final class PortableExtractor {
    private static final PortableFieldExtractor[] FIELD_EXTRACTORS = new PortableFieldExtractor[FieldType.values().length];

    private PortableExtractor() {
    }

    static Comparable extractValue(SerializationService serializationService, Data data, String fieldName) throws IOException {
        PortableContext portableContext = serializationService.getPortableContext();
        PortableFieldExtractor fieldExtractor = PortableExtractor.getFieldExtractor(data, fieldName, portableContext);
        PortableReader reader = serializationService.createPortableReader(data);
        return fieldExtractor.extract(reader, fieldName);
    }

    private static PortableFieldExtractor getFieldExtractor(Data data, String fieldName, PortableContext portableContext) {
        FieldDefinition fieldDefinition = PortableExtractor.getFieldDefinition(data, fieldName, portableContext);
        byte fieldType = fieldDefinition.getType().getId();
        if (fieldType < 0 || fieldType >= FIELD_EXTRACTORS.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid fieldType: " + fieldType);
        }
        PortableFieldExtractor fieldExtractor = FIELD_EXTRACTORS[fieldType];
        if (fieldExtractor == null) {
            throw new QueryException("Field extractor is not defined: " + fieldType);
        }
        return fieldExtractor;
    }

    private static FieldDefinition getFieldDefinition(Data data, String fieldName, PortableContext portableContext) {
        ClassDefinition classDefinition = portableContext.lookupClassDefinition(data);
        FieldDefinition fieldDefinition = portableContext.getFieldDefinition(classDefinition, fieldName);
        if (fieldDefinition == null) {
            throw new QueryException("Unknown Portable field: " + fieldName);
        }
        return fieldDefinition;
    }

    static AttributeType getAttributeType(PortableContext portableContext, Data data, String fieldName) {
        PortableFieldExtractor fieldExtractor = PortableExtractor.getFieldExtractor(data, fieldName, portableContext);
        return fieldExtractor.getAttributeType();
    }

    static {
        PortableExtractor.FIELD_EXTRACTORS[FieldType.PORTABLE.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.BYTE.getId()] = new PortableByteFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.BOOLEAN.getId()] = new PortableBooleanFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.CHAR.getId()] = new PortableCharFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.SHORT.getId()] = new PortableShortFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.INT.getId()] = new PortableIntegerFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.LONG.getId()] = new PortableLongFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.FLOAT.getId()] = new PortableFloatFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.DOUBLE.getId()] = new PortableDoubleFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.UTF.getId()] = new PortableUtfFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.PORTABLE_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.BYTE_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.CHAR_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.SHORT_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.INT_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.LONG_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.FLOAT_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
        PortableExtractor.FIELD_EXTRACTORS[FieldType.DOUBLE_ARRAY.getId()] = new PortableUnsupportedFieldExtractor();
    }

    private static interface PortableFieldExtractor {
        public Comparable extract(PortableReader var1, String var2) throws IOException;

        public AttributeType getAttributeType();
    }

    private static class PortableUnsupportedFieldExtractor
    implements PortableFieldExtractor {
        private PortableUnsupportedFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            throw new UnsupportedOperationException("Unsupported Portable field in query: " + fieldName);
        }

        @Override
        public AttributeType getAttributeType() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PortableBooleanFieldExtractor
    implements PortableFieldExtractor {
        private PortableBooleanFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Boolean.valueOf(reader.readBoolean(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.BOOLEAN;
        }
    }

    private static class PortableCharFieldExtractor
    implements PortableFieldExtractor {
        private PortableCharFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Character.valueOf(reader.readChar(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.CHAR;
        }
    }

    private static class PortableUtfFieldExtractor
    implements PortableFieldExtractor {
        private PortableUtfFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return reader.readUTF(fieldName);
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.STRING;
        }
    }

    private static class PortableShortFieldExtractor
    implements PortableFieldExtractor {
        private PortableShortFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Short.valueOf(reader.readShort(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.SHORT;
        }
    }

    private static class PortableFloatFieldExtractor
    implements PortableFieldExtractor {
        private PortableFloatFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Float.valueOf(reader.readFloat(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.FLOAT;
        }
    }

    private static class PortableDoubleFieldExtractor
    implements PortableFieldExtractor {
        private PortableDoubleFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Double.valueOf(reader.readDouble(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.DOUBLE;
        }
    }

    private static class PortableLongFieldExtractor
    implements PortableFieldExtractor {
        private PortableLongFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Long.valueOf(reader.readLong(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.LONG;
        }
    }

    private static class PortableByteFieldExtractor
    implements PortableFieldExtractor {
        private PortableByteFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Byte.valueOf(reader.readByte(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.BYTE;
        }
    }

    private static class PortableIntegerFieldExtractor
    implements PortableFieldExtractor {
        private PortableIntegerFieldExtractor() {
        }

        @Override
        public Comparable extract(PortableReader reader, String fieldName) throws IOException {
            return Integer.valueOf(reader.readInt(fieldName));
        }

        @Override
        public AttributeType getAttributeType() {
            return AttributeType.INTEGER;
        }
    }
}

