/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonArray;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.management.SerializableClientEndPoint;
import com.hazelcast.management.SerializableMXBeans;
import com.hazelcast.monitor.LocalCacheStats;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalInstanceStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMemoryStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MemberStateImpl
implements MemberState {
    public static final int DEFAULT_PARTITION_COUNT = 271;
    private String address;
    private Map<String, Long> runtimeProps = new HashMap<String, Long>();
    private Map<String, LocalMapStatsImpl> mapStats = new HashMap<String, LocalMapStatsImpl>();
    private Map<String, LocalMultiMapStatsImpl> multiMapStats = new HashMap<String, LocalMultiMapStatsImpl>();
    private Map<String, LocalQueueStatsImpl> queueStats = new HashMap<String, LocalQueueStatsImpl>();
    private Map<String, LocalTopicStatsImpl> topicStats = new HashMap<String, LocalTopicStatsImpl>();
    private Map<String, LocalExecutorStatsImpl> executorStats = new HashMap<String, LocalExecutorStatsImpl>();
    private Map<String, LocalCacheStats> cacheStats = new HashMap<String, LocalCacheStats>();
    private List<Integer> partitions = new ArrayList<Integer>(271);
    private Collection<SerializableClientEndPoint> clients = new HashSet<SerializableClientEndPoint>();
    private SerializableMXBeans beans = new SerializableMXBeans();
    private LocalMemoryStats memoryStats = new LocalMemoryStatsImpl();

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("address", this.address);
        JsonObject mapStatsObject = new JsonObject();
        for (Map.Entry<String, LocalMapStatsImpl> entry : this.mapStats.entrySet()) {
            mapStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("mapStats", mapStatsObject);
        JsonObject multimapStatsObject = new JsonObject();
        for (Map.Entry<String, LocalMultiMapStatsImpl> entry : this.multiMapStats.entrySet()) {
            multimapStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("multiMapStats", multimapStatsObject);
        JsonObject queueStatsObject = new JsonObject();
        for (Map.Entry<String, LocalQueueStatsImpl> entry : this.queueStats.entrySet()) {
            queueStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("queueStats", queueStatsObject);
        JsonObject topicStatsObject = new JsonObject();
        for (Map.Entry<String, LocalTopicStatsImpl> entry : this.topicStats.entrySet()) {
            topicStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("topicStats", topicStatsObject);
        JsonObject executorStatsObject = new JsonObject();
        for (Map.Entry<String, LocalExecutorStatsImpl> entry : this.executorStats.entrySet()) {
            executorStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("executorStats", executorStatsObject);
        JsonObject cacheStatsObject = new JsonObject();
        for (Map.Entry<String, LocalCacheStats> entry : this.cacheStats.entrySet()) {
            cacheStatsObject.add(entry.getKey(), entry.getValue().toJson());
        }
        root.add("cacheStats", cacheStatsObject);
        JsonObject runtimePropsObject = new JsonObject();
        for (Map.Entry<String, Long> entry : this.runtimeProps.entrySet()) {
            runtimePropsObject.add(entry.getKey(), entry.getValue());
        }
        root.add("runtimeProps", runtimePropsObject);
        JsonArray partitionsArray = new JsonArray();
        for (Integer lsPartition : this.partitions) {
            partitionsArray.add(lsPartition);
        }
        root.add("partitions", partitionsArray);
        JsonArray clientsArray = new JsonArray();
        for (SerializableClientEndPoint client : this.clients) {
            clientsArray.add(client.toJson());
        }
        root.add("clients", clientsArray);
        root.add("beans", this.beans.toJson());
        root.add("memoryStats", this.memoryStats.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        LocalInstanceStats stats;
        this.address = JsonUtil.getString(json, "address");
        for (JsonObject.Member next : JsonUtil.getObject(json, "mapStats")) {
            stats = new LocalMapStatsImpl();
            ((LocalMapStatsImpl)stats).fromJson(next.getValue().asObject());
            this.mapStats.put(next.getName(), (LocalMapStatsImpl)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "multiMapStats")) {
            stats = new LocalMultiMapStatsImpl();
            ((LocalMapStatsImpl)stats).fromJson(next.getValue().asObject());
            this.multiMapStats.put(next.getName(), (LocalMultiMapStatsImpl)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "queueStats")) {
            stats = new LocalQueueStatsImpl();
            ((LocalQueueStatsImpl)stats).fromJson(next.getValue().asObject());
            this.queueStats.put(next.getName(), (LocalQueueStatsImpl)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "topicStats")) {
            stats = new LocalTopicStatsImpl();
            ((LocalTopicStatsImpl)stats).fromJson(next.getValue().asObject());
            this.topicStats.put(next.getName(), (LocalTopicStatsImpl)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "executorStats")) {
            stats = new LocalExecutorStatsImpl();
            ((LocalExecutorStatsImpl)stats).fromJson(next.getValue().asObject());
            this.executorStats.put(next.getName(), (LocalExecutorStatsImpl)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "cacheStats", new JsonObject())) {
            stats = new LocalCacheStatsImpl();
            stats.fromJson(next.getValue().asObject());
            this.cacheStats.put(next.getName(), (LocalCacheStats)stats);
        }
        for (JsonObject.Member next : JsonUtil.getObject(json, "runtimeProps")) {
            this.runtimeProps.put(next.getName(), next.getValue().asLong());
        }
        JsonArray jsonPartitions = JsonUtil.getArray(json, "partitions");
        for (JsonValue jsonPartition : jsonPartitions) {
            this.partitions.add(jsonPartition.asInt());
        }
        JsonArray jsonClients = JsonUtil.getArray(json, "clients");
        for (JsonValue jsonClient : jsonClients) {
            SerializableClientEndPoint client = new SerializableClientEndPoint();
            client.fromJson(jsonClient.asObject());
            this.clients.add(client);
        }
        this.beans = new SerializableMXBeans();
        this.beans.fromJson(JsonUtil.getObject(json, "beans"));
        this.memoryStats.fromJson(JsonUtil.getObject(json, "memoryStats"));
    }

    public void clearPartitions() {
        this.partitions.clear();
    }

    public void addPartition(int partitionId) {
        this.partitions.add(partitionId);
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    public Map<String, Long> getRuntimeProps() {
        return this.runtimeProps;
    }

    public void setRuntimeProps(Map<String, Long> runtimeProps) {
        this.runtimeProps = runtimeProps;
    }

    @Override
    public LocalMapStats getLocalMapStats(String mapName) {
        return this.mapStats.get(mapName);
    }

    @Override
    public LocalMultiMapStats getLocalMultiMapStats(String mapName) {
        return this.multiMapStats.get(mapName);
    }

    @Override
    public LocalQueueStats getLocalQueueStats(String queueName) {
        return this.queueStats.get(queueName);
    }

    @Override
    public LocalTopicStats getLocalTopicStats(String topicName) {
        return this.topicStats.get(topicName);
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats(String executorName) {
        return this.executorStats.get(executorName);
    }

    @Override
    public LocalCacheStats getLocalCacheStats(String cacheName) {
        return this.cacheStats.get(cacheName);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void putLocalMapStats(String name, LocalMapStatsImpl localMapStats) {
        this.mapStats.put(name, localMapStats);
    }

    public void putLocalMultiMapStats(String name, LocalMultiMapStatsImpl localMultiMapStats) {
        this.multiMapStats.put(name, localMultiMapStats);
    }

    public void putLocalQueueStats(String name, LocalQueueStatsImpl localQueueStats) {
        this.queueStats.put(name, localQueueStats);
    }

    public void putLocalTopicStats(String name, LocalTopicStatsImpl localTopicStats) {
        this.topicStats.put(name, localTopicStats);
    }

    public void putLocalExecutorStats(String name, LocalExecutorStatsImpl localExecutorStats) {
        this.executorStats.put(name, localExecutorStats);
    }

    public void putLocalCacheStats(String name, LocalCacheStats localCacheStats) {
        this.cacheStats.put(name, localCacheStats);
    }

    @Override
    public Collection<SerializableClientEndPoint> getClients() {
        return this.clients;
    }

    @Override
    public SerializableMXBeans getMXBeans() {
        return this.beans;
    }

    public void setBeans(SerializableMXBeans beans) {
        this.beans = beans;
    }

    public void setClients(Collection<SerializableClientEndPoint> clients) {
        this.clients = clients;
    }

    @Override
    public LocalMemoryStats getLocalMemoryStats() {
        return this.memoryStats;
    }

    public void setLocalMemoryStats(LocalMemoryStats memoryStats) {
        this.memoryStats = memoryStats;
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.mapStats != null ? this.mapStats.hashCode() : 0);
        result = 31 * result + (this.multiMapStats != null ? this.multiMapStats.hashCode() : 0);
        result = 31 * result + (this.queueStats != null ? this.queueStats.hashCode() : 0);
        result = 31 * result + (this.topicStats != null ? this.topicStats.hashCode() : 0);
        result = 31 * result + (this.executorStats != null ? this.executorStats.hashCode() : 0);
        result = 31 * result + (this.cacheStats != null ? this.cacheStats.hashCode() : 0);
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberStateImpl that = (MemberStateImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.executorStats != null ? !this.executorStats.equals(that.executorStats) : that.executorStats != null) {
            return false;
        }
        if (this.mapStats != null ? !this.mapStats.equals(that.mapStats) : that.mapStats != null) {
            return false;
        }
        if (this.multiMapStats != null ? !this.multiMapStats.equals(that.multiMapStats) : that.multiMapStats != null) {
            return false;
        }
        if (this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null) {
            return false;
        }
        if (this.queueStats != null ? !this.queueStats.equals(that.queueStats) : that.queueStats != null) {
            return false;
        }
        if (this.runtimeProps != null ? !this.runtimeProps.equals(that.runtimeProps) : that.runtimeProps != null) {
            return false;
        }
        if (this.topicStats != null ? !this.topicStats.equals(that.topicStats) : that.topicStats != null) {
            return false;
        }
        if (this.cacheStats != null ? !this.cacheStats.equals(that.cacheStats) : that.cacheStats != null) {
            return false;
        }
        return !(this.memoryStats != null ? !this.memoryStats.equals(that.memoryStats) : that.memoryStats != null);
    }

    public String toString() {
        return "MemberStateImpl{address=" + this.address + ", runtimeProps=" + this.runtimeProps + ", mapStats=" + this.mapStats + ", multiMapStats=" + this.multiMapStats + ", queueStats=" + this.queueStats + ", topicStats=" + this.topicStats + ", executorStats=" + this.executorStats + ", cacheStats=" + this.cacheStats + ", partitions=" + this.partitions + ", memoryStats=" + this.memoryStats + '}';
    }
}

