/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.memory;

import com.hazelcast.memory.GCStatsSupport;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.impl.LocalMemoryStatsImpl;
import com.hazelcast.util.EmptyStatement;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class MemoryStatsSupport {
    private static final MBeanServer PLATFORM_M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final long TOTAL_PHYSICAL_MEMORY = MemoryStatsSupport.queryPhysicalMemory("TotalPhysicalMemorySize");

    private MemoryStatsSupport() {
    }

    public static long totalPhysicalMemory() {
        return TOTAL_PHYSICAL_MEMORY;
    }

    public static long freePhysicalMemory() {
        return MemoryStatsSupport.queryPhysicalMemory("FreePhysicalMemorySize");
    }

    private static long queryPhysicalMemory(String type) {
        try {
            ObjectName name = new ObjectName("java.lang", "type", "OperatingSystem");
            Object attribute = PLATFORM_M_BEAN_SERVER.getAttribute(name, type);
            if (attribute != null) {
                return Long.parseLong(attribute.toString());
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        return -1L;
    }

    public static MemoryUsage getHeapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    public static LocalMemoryStats getMemoryStats() {
        LocalMemoryStatsImpl stats = new LocalMemoryStatsImpl();
        stats.setTotalPhysical(MemoryStatsSupport.totalPhysicalMemory());
        stats.setFreePhysical(MemoryStatsSupport.freePhysicalMemory());
        MemoryUsage memoryUsage = MemoryStatsSupport.getHeapMemoryUsage();
        stats.setMaxHeap(memoryUsage.getMax());
        stats.setCommittedHeap(memoryUsage.getCommitted());
        stats.setUsedHeap(memoryUsage.getUsed());
        stats.setCommittedNativeMemory(-99L);
        stats.setMaxNativeMemory(-99L);
        stats.setUsedNativeMemory(-99L);
        stats.setFreeNativeMemory(-99L);
        stats.setGcStats(GCStatsSupport.getGCStats());
        return stats;
    }
}

