/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.map.impl.operation.EvictAllBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public class EvictAllOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    private boolean shouldRunOnBackup;
    private int numberOfEvictedEntries;

    public EvictAllOperation() {
    }

    public EvictAllOperation(String name) {
        super(name);
    }

    @Override
    public void run() throws Exception {
        this.mapService.getMapServiceContext().getNearCacheProvider().clearNearCache(this.name);
        RecordStore recordStore = this.mapService.getMapServiceContext().getExistingRecordStore(this.getPartitionId(), this.name);
        if (recordStore == null) {
            return;
        }
        this.numberOfEvictedEntries = recordStore.evictAll(false);
        this.shouldRunOnBackup = true;
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldRunOnBackup;
    }

    @Override
    public Object getResponse() {
        return this.numberOfEvictedEntries;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapService.getMapServiceContext().getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapService.getMapServiceContext().getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new EvictAllBackupOperation(this.name);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.numberOfEvictedEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.numberOfEvictedEntries = in.readInt();
    }

    public String toString() {
        return "EvictAllOperation{shouldRunOnBackup=" + this.shouldRunOnBackup + ", numberOfEvictedEntries=" + this.numberOfEvictedEntries + '}';
    }
}

