/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.mapstore.MapStoreManager;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.StoreEvent;
import com.hazelcast.map.impl.mapstore.writebehind.StoreListener;
import com.hazelcast.map.impl.mapstore.writebehind.StoreWorker;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessors;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.executor.ExecutorType;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WriteBehindManager
implements MapStoreManager {
    private static final String EXECUTOR_NAME_PREFIX = "hz:scheduled:mapstore:";
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private final ScheduledExecutorService scheduledExecutor;
    private WriteBehindProcessor writeBehindProcessor;
    private StoreWorker storeWorker;
    private MapContainer mapContainer;
    private String executorName;

    public WriteBehindManager(MapContainer mapContainer) {
        this.mapContainer = mapContainer;
        this.writeBehindProcessor = this.createWriteBehindProcessor(mapContainer);
        this.storeWorker = new StoreWorker(mapContainer, this.writeBehindProcessor);
        this.executorName = EXECUTOR_NAME_PREFIX + mapContainer.getName();
        this.scheduledExecutor = this.getScheduledExecutorService(mapContainer.getMapServiceContext());
    }

    @Override
    public void start() {
        this.scheduledExecutor.scheduleAtFixedRate(this.storeWorker, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        NodeEngine nodeEngine = this.mapContainer.getMapServiceContext().getNodeEngine();
        nodeEngine.getExecutionService().shutdownExecutor(this.executorName);
    }

    @Override
    public MapDataStore getMapDataStore(int partitionId) {
        return MapDataStores.createWriteBehindStore(this.mapContainer, partitionId, this.writeBehindProcessor);
    }

    private WriteBehindProcessor createWriteBehindProcessor(final MapContainer mapContainer) {
        final MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        WriteBehindProcessor writeBehindProcessor = WriteBehindProcessors.createWriteBehindProcessor(mapContainer);
        writeBehindProcessor.addStoreListener(new StoreListener<DelayedEntry>(){

            @Override
            public void beforeStore(StoreEvent<DelayedEntry> storeEvent) {
            }

            @Override
            public void afterStore(StoreEvent<DelayedEntry> storeEvent) {
                DelayedEntry delayedEntry = storeEvent.getSource();
                Object value = delayedEntry.getValue();
                if (value != null) {
                    return;
                }
                Data key = (Data)storeEvent.getSource().getKey();
                int partitionId = delayedEntry.getPartitionId();
                PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
                RecordStore recordStore = partitionContainer.getExistingRecordStore(mapContainer.getName());
                if (recordStore != null) {
                    recordStore.getMapDataStore().addTransient(key, Clock.currentTimeMillis());
                }
            }
        });
        return writeBehindProcessor;
    }

    private ScheduledExecutorService getScheduledExecutorService(MapServiceContext mapServiceContext) {
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(this.executorName, 1, 10000, ExecutorType.CACHED);
        return executionService.getScheduledExecutor(this.executorName);
    }
}

