/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.map.impl.AbstractMapServiceContextSupport;
import com.hazelcast.map.impl.BasicMapContextQuerySupport;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapContextQuerySupport;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapEventPublisherSupport;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.NearCacheProvider;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.eviction.EvictionOperator;
import com.hazelcast.map.impl.eviction.ExpirationManager;
import com.hazelcast.map.merge.MergePolicyProvider;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultMapServiceContext
extends AbstractMapServiceContextSupport
implements MapServiceContext {
    private final PartitionContainer[] partitionContainers;
    private final ConcurrentMap<String, MapContainer> mapContainers;
    private final AtomicReference<Collection<Integer>> ownedPartitions;
    private final ConstructorFunction<String, MapContainer> mapConstructor = new ConstructorFunction<String, MapContainer>(){

        @Override
        public MapContainer createNew(String mapName) {
            return new MapContainer(mapName, DefaultMapServiceContext.this.nodeEngine.getConfig().findMapConfig(mapName), DefaultMapServiceContext.this.getService().getMapServiceContext());
        }
    };
    private final AtomicInteger writeBehindQueueItemCounter = new AtomicInteger(0);
    private final ExpirationManager expirationManager;
    private final NearCacheProvider nearCacheProvider;
    private final LocalMapStatsProvider localMapStatsProvider;
    private final MergePolicyProvider mergePolicyProvider;
    private final MapEventPublisher mapEventPublisher;
    private final MapContextQuerySupport mapContextQuerySupport;
    private EvictionOperator evictionOperator;
    private MapService mapService;

    public DefaultMapServiceContext(NodeEngine nodeEngine) {
        super(nodeEngine);
        this.setMapServiceContext(this);
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.partitionContainers = new PartitionContainer[partitionCount];
        this.mapContainers = new ConcurrentHashMap<String, MapContainer>();
        this.ownedPartitions = new AtomicReference();
        this.expirationManager = new ExpirationManager(this, nodeEngine);
        this.evictionOperator = EvictionOperator.create(this);
        this.nearCacheProvider = new NearCacheProvider(this, nodeEngine);
        this.localMapStatsProvider = new LocalMapStatsProvider(this, nodeEngine);
        this.mergePolicyProvider = new MergePolicyProvider(nodeEngine);
        this.mapEventPublisher = new MapEventPublisherSupport(this);
        this.mapContextQuerySupport = new BasicMapContextQuerySupport(this);
    }

    @Override
    public MapContainer getMapContainer(String mapName) {
        return ConcurrencyUtil.getOrPutSynchronized(this.mapContainers, mapName, this.mapContainers, this.mapConstructor);
    }

    @Override
    public Map<String, MapContainer> getMapContainers() {
        return this.mapContainers;
    }

    @Override
    public PartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    @Override
    public void initPartitionsContainers() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        PartitionContainer[] partitionContainers = this.partitionContainers;
        for (int i = 0; i < partitionCount; ++i) {
            partitionContainers[i] = new PartitionContainer(this.getService(), i);
        }
    }

    @Override
    public void clearPartitionData(int partitionId) {
        PartitionContainer container = this.partitionContainers[partitionId];
        if (container != null) {
            for (RecordStore mapPartition : container.getMaps().values()) {
                mapPartition.clearPartition();
            }
            container.getMaps().clear();
        }
    }

    @Override
    public String serviceName() {
        return "hz:impl:mapService";
    }

    @Override
    public MapService getService() {
        return this.mapService;
    }

    @Override
    public void clearPartitions() {
        PartitionContainer[] containers;
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.clear();
        }
    }

    @Override
    public void destroyMapStores() {
        for (MapContainer mapContainer : this.mapContainers.values()) {
            MapStoreWrapper store = mapContainer.getStore();
            if (store == null) continue;
            store.destroy();
        }
    }

    @Override
    public void flushMaps() {
        for (PartitionContainer partitionContainer : this.partitionContainers) {
            for (String mapName : this.mapContainers.keySet()) {
                RecordStore recordStore = partitionContainer.getRecordStore(mapName);
                recordStore.flush();
            }
        }
    }

    @Override
    public void destroyMap(String mapName) {
        PartitionContainer[] containers;
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.destroyMap(mapName);
        }
    }

    @Override
    public void reset() {
        this.clearPartitions();
        this.getNearCacheProvider().clear();
    }

    @Override
    public NearCacheProvider getNearCacheProvider() {
        return this.nearCacheProvider;
    }

    @Override
    public RecordStore getRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getRecordStore(mapName);
    }

    @Override
    public RecordStore getExistingRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getExistingRecordStore(mapName);
    }

    @Override
    public Collection<Integer> getOwnedPartitions() {
        Collection<Integer> partitions = this.ownedPartitions.get();
        if (partitions == null) {
            this.reloadOwnedPartitions();
            partitions = this.ownedPartitions.get();
        }
        return partitions;
    }

    @Override
    public void reloadOwnedPartitions() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        Collection<Integer> partitions = partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
        if (partitions == null) {
            partitions = Collections.emptySet();
        }
        this.ownedPartitions.set(Collections.unmodifiableSet(new LinkedHashSet<Integer>(partitions)));
    }

    @Override
    public boolean isOwnedKey(Data key) {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        Integer partitionId = partitionService.getPartitionId(key);
        try {
            Address owner = partitionService.getPartitionOwnerOrWait(partitionId);
            return this.nodeEngine.getThisAddress().equals(owner);
        }
        catch (InterruptedException e) {
            throw new HazelcastException(e);
        }
    }

    @Override
    public AtomicInteger getWriteBehindQueueItemCounter() {
        return this.writeBehindQueueItemCounter;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public EvictionOperator getEvictionOperator() {
        return this.evictionOperator;
    }

    @Override
    public void setService(MapService mapService) {
        this.mapService = mapService;
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public MergePolicyProvider getMergePolicyProvider() {
        return this.mergePolicyProvider;
    }

    @Override
    public MapEventPublisher getMapEventPublisher() {
        return this.mapEventPublisher;
    }

    @Override
    public MapContextQuerySupport getMapContextQuerySupport() {
        return this.mapContextQuerySupport;
    }

    @Override
    public LocalMapStatsProvider getLocalMapStatsProvider() {
        return this.localMapStatsProvider;
    }

    public void setEvictionOperator(EvictionOperator evictionOperator) {
        this.evictionOperator = evictionOperator;
    }
}

