/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ValidationUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    private static final ILogger LOGGER = Logger.getLogger(ConfigXmlGenerator.class);
    private static final int INDENT = 5;
    private final boolean formatted;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    public String generate(Config config) {
        ValidationUtil.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-3.3.xsd\">");
        xml.append("<group>");
        xml.append("<name>").append(config.getGroupConfig().getName()).append("</name>");
        xml.append("<password>").append("****").append("</password>");
        xml.append("</group>");
        if (config.getLicenseKey() != null) {
            xml.append("<license-key>").append(config.getLicenseKey()).append("</license-key>");
        }
        if (config.getManagementCenterConfig() != null) {
            ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
            xml.append("<management-center enabled=\"").append(mcConfig.isEnabled()).append("\" update-interval=\"").append(mcConfig.getUpdateInterval()).append("\">").append(mcConfig.getUrl()).append("</management-center>");
        }
        this.appendProperties(xml, config.getProperties());
        this.wanReplicationXmlGenerator(xml, config);
        this.networkConfigXmlGenerator(xml, config);
        this.mapConfigXmlGenerator(xml, config);
        this.queueXmlGenerator(xml, config);
        this.multiMapXmlGenerator(xml, config);
        this.topicXmlGenerator(xml, config);
        this.semaphoreXmlGenerator(xml, config);
        this.executorXmlGenerator(xml, config);
        this.partititonGroupXmlGenerator(xml, config);
        this.listenerXmlGenerator(xml, config);
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private void listenerXmlGenerator(StringBuilder xml, Config config) {
        if (!config.getListenerConfigs().isEmpty()) {
            xml.append("<listeners>");
            for (ListenerConfig lc : config.getListenerConfigs()) {
                xml.append("<listener>");
                String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                xml.append(clazz);
                xml.append("</listener>");
            }
            xml.append("</listeners>");
        }
    }

    private void partititonGroupXmlGenerator(StringBuilder xml, Config config) {
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg != null) {
            xml.append("<partition-group enabled=\"").append(pg.isEnabled()).append("\" group-type=\"").append((Object)pg.getGroupType()).append("\" />");
        }
    }

    private void executorXmlGenerator(StringBuilder xml, Config config) {
        Collection<ExecutorConfig> exCfgs = config.getExecutorConfigs().values();
        for (ExecutorConfig ex : exCfgs) {
            xml.append("<executor-service name=\"").append(ex.getName()).append("\">");
            xml.append("<pool-size>").append(ex.getPoolSize()).append("</pool-size>");
            xml.append("<queue-capacity>").append(ex.getQueueCapacity()).append("</queue-capacity>");
            xml.append("</executor-service>");
        }
    }

    private void semaphoreXmlGenerator(StringBuilder xml, Config config) {
        Collection<SemaphoreConfig> semaphoreCfgs = config.getSemaphoreConfigs();
        for (SemaphoreConfig sc : semaphoreCfgs) {
            xml.append("<semaphore name=\"").append(sc.getName()).append("\">");
            xml.append("<initial-permits>").append(sc.getInitialPermits()).append("</initial-permits>");
            xml.append("<backup-count>").append(sc.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(sc.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("</semaphore>");
        }
    }

    private void topicXmlGenerator(StringBuilder xml, Config config) {
        Collection<TopicConfig> tCfgs = config.getTopicConfigs().values();
        for (TopicConfig t : tCfgs) {
            xml.append("<topic name=\"").append(t.getName()).append("\">");
            xml.append("<global-ordering-enabled>").append(t.isGlobalOrderingEnabled()).append("</global-ordering-enabled>");
            if (!t.getMessageListenerConfigs().isEmpty()) {
                xml.append("<message-listeners>");
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    xml.append("<message-listener>");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</message-listener>");
                }
                xml.append("</message-listeners>");
            }
            xml.append("</topic>");
        }
    }

    private void multiMapXmlGenerator(StringBuilder xml, Config config) {
        Collection<MultiMapConfig> mmCfgs = config.getMultiMapConfigs().values();
        for (MultiMapConfig mm : mmCfgs) {
            xml.append("<multimap name=\"").append(mm.getName()).append("\">");
            xml.append("<value-collection-type>").append((Object)mm.getValueCollectionType()).append("</value-collection-type>");
            if (!mm.getEntryListenerConfigs().isEmpty()) {
                xml.append("<entry-listeners>");
                for (EntryListenerConfig lc : mm.getEntryListenerConfigs()) {
                    xml.append("<entry-listener include-value=\"").append(lc.isIncludeValue()).append("\" local=\"").append(lc.isLocal()).append("\">");
                    String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                    xml.append(clazz);
                    xml.append("</entry-listener>");
                }
                xml.append("</entry-listeners>");
            }
            xml.append("</multimap>");
        }
    }

    private void queueXmlGenerator(StringBuilder xml, Config config) {
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig q : qCfgs) {
            xml.append("<queue name=\"").append(q.getName()).append("\">");
            xml.append("<queue-max-size>").append(q.getMaxSize()).append("</queue-max-size>");
            xml.append("<queue-sync-backup-count>").append(q.getBackupCount()).append("</queue-sync-backup-count>");
            xml.append("<queue-async-backup-count>").append(q.getAsyncBackupCount()).append("</queue-async-backup-count>");
            if (!q.getItemListenerConfigs().isEmpty()) {
                xml.append("<item-listeners>");
                for (ItemListenerConfig lc : q.getItemListenerConfigs()) {
                    xml.append("<item-listener include-value=\"").append(lc.isIncludeValue()).append("\">");
                    xml.append(lc.getClassName());
                    xml.append("</item-listener>");
                }
                xml.append("</item-listeners>");
            }
            xml.append("</queue>");
        }
    }

    private void wanReplicationXmlGenerator(StringBuilder xml, Config config) {
        Collection<WanReplicationConfig> wanRepConfigs = config.getWanReplicationConfigs().values();
        for (WanReplicationConfig wan : wanRepConfigs) {
            xml.append("<wan-replication name=\"").append(wan.getName()).append("\">");
            List<WanTargetClusterConfig> targets = wan.getTargetClusterConfigs();
            for (WanTargetClusterConfig t : targets) {
                xml.append("<target-cluster group-name=\"").append(t.getGroupName()).append("\" group-password=\"").append(t.getGroupPassword()).append("\">");
                xml.append("<replication-impl>").append(t.getReplicationImpl()).append("</replication-impl>");
                xml.append("<end-points>");
                List<String> eps = t.getEndpoints();
                for (String ep : eps) {
                    xml.append("<address>").append(ep).append("</address>");
                }
                xml.append("</end-points>").append("</target-cluster>");
            }
            xml.append("</wan-replication>");
        }
    }

    private void networkConfigXmlGenerator(StringBuilder xml, Config config) {
        NetworkConfig netCfg = config.getNetworkConfig();
        xml.append("<network>");
        if (netCfg.getPublicAddress() != null) {
            xml.append("<public-address>").append(netCfg.getPublicAddress()).append("</public-address>");
        }
        xml.append("<port port-count=\"").append(netCfg.getPortCount()).append("\" ").append("auto-increment=\"").append(netCfg.isPortAutoIncrement()).append("\">").append(netCfg.getPort()).append("</port>");
        JoinConfig join = netCfg.getJoin();
        xml.append("<join>");
        this.multicastConfigXmlGenerator(xml, join);
        this.tcpConfigXmlGenerator(xml, join);
        this.awsConfigXmlGenerator(xml, join);
        xml.append("</join>");
        this.interfacesConfigXmlGenerator(xml, netCfg);
        this.sslConfigXmlGenerator(xml, netCfg);
        this.socketInterceptorConfigXmlGenerator(xml, netCfg);
        this.symmetricEncInterceptorConfigXmlGenerator(xml, netCfg);
        xml.append("</network>");
    }

    private void mapConfigXmlGenerator(StringBuilder xml, Config config) {
        Collection<MapConfig> mCfgs = config.getMapConfigs().values();
        for (MapConfig m : mCfgs) {
            xml.append("<map name=\"").append(m.getName()).append("\">");
            xml.append("<in-memory-format>").append((Object)m.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("<backup-count>").append(m.getBackupCount()).append("</backup-count>");
            xml.append("<async-backup-count>").append(m.getAsyncBackupCount()).append("</async-backup-count>");
            xml.append("<time-to-live-seconds>").append(m.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(m.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<eviction-policy>").append((Object)m.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<max-size policy=\"").append((Object)m.getMaxSizeConfig().getMaxSizePolicy()).append("\">").append(m.getMaxSizeConfig().getSize()).append("</max-size>");
            xml.append("<eviction-percentage>").append(m.getEvictionPercentage()).append("</eviction-percentage>");
            xml.append("<min-eviction-check-millis>").append(m.getMinEvictionCheckMillis()).append("</min-eviction-check-millis>");
            xml.append("<merge-policy>").append(m.getMergePolicy()).append("</merge-policy>");
            xml.append("<read-backup-data>").append(m.isReadBackupData()).append("</read-backup-data>");
            xml.append("<statistics-enabled>").append(m.isStatisticsEnabled()).append("</statistics-enabled>");
            this.mapStoreConfigXmlGenerator(xml, m);
            this.mapWanReplicationConfigXmlGenerator(xml, m);
            this.mapIndexConfigXmlGenerator(xml, m);
            this.mapEntryListenerConfigXmlGenerator(xml, m);
            this.mapPartitionStrategyConfigXmlGenerator(xml, m);
        }
    }

    private void mapPartitionStrategyConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getPartitioningStrategyConfig() != null) {
            xml.append("<partition-strategy>");
            PartitioningStrategyConfig psc = m.getPartitioningStrategyConfig();
            if (psc.getPartitioningStrategy() != null) {
                xml.append(psc.getPartitioningStrategy().getClass().getName());
            } else {
                xml.append(psc.getPartitioningStrategyClass());
            }
            xml.append("</partition-strategy>");
        }
        xml.append("</map>");
    }

    private void mapEntryListenerConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getEntryListenerConfigs().isEmpty()) {
            xml.append("<entry-listeners>");
            for (EntryListenerConfig lc : m.getEntryListenerConfigs()) {
                xml.append("<entry-listener include-value=\"").append(lc.isIncludeValue()).append("\" local=\"").append(lc.isLocal()).append("\">");
                String clazz = lc.getImplementation() != null ? lc.getImplementation().getClass().getName() : lc.getClassName();
                xml.append(clazz);
                xml.append("</entry-listener>");
            }
            xml.append("</entry-listeners>");
        }
    }

    private void mapIndexConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (!m.getMapIndexConfigs().isEmpty()) {
            xml.append("<indexes>");
            for (MapIndexConfig indexCfg : m.getMapIndexConfigs()) {
                xml.append("<index ordered=\"").append(indexCfg.isOrdered()).append("\">");
                xml.append(indexCfg.getAttribute());
                xml.append("</index>");
            }
            xml.append("</indexes>");
        }
    }

    private void mapWanReplicationConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getWanReplicationRef() != null) {
            WanReplicationRef wan = m.getWanReplicationRef();
            xml.append("<wan-replication-ref name=\"").append(wan.getName()).append("\">");
            xml.append("<merge-policy>").append(wan.getMergePolicy()).append("</merge-policy>");
            xml.append("</wan-replication-ref>");
        }
    }

    private void mapStoreConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getMapStoreConfig() != null) {
            String factoryClass;
            MapStoreConfig s = m.getMapStoreConfig();
            xml.append("<map-store enabled=\"").append(s.isEnabled()).append("\">");
            String clazz = s.getImplementation() != null ? s.getImplementation().getClass().getName() : s.getClassName();
            xml.append("<class-name>").append(clazz).append("</class-name>");
            String string = factoryClass = s.getFactoryImplementation() != null ? s.getFactoryImplementation().getClass().getName() : s.getFactoryClassName();
            if (factoryClass != null) {
                xml.append("<factory-class-name>").append(factoryClass).append("</factory-class-name>");
            }
            xml.append("<write-delay-seconds>").append(s.getWriteDelaySeconds()).append("</write-delay-seconds>");
            xml.append("<write-batch-size>").append(s.getWriteBatchSize()).append("</write-batch-size>");
            this.appendProperties(xml, s.getProperties());
            xml.append("</map-store>");
        }
    }

    private void nearCacheStoreConfigXmlGenerator(StringBuilder xml, MapConfig m) {
        if (m.getNearCacheConfig() != null) {
            NearCacheConfig n = m.getNearCacheConfig();
            xml.append("<near-cache>");
            xml.append("<max-size>").append(n.getMaxSize()).append("</max-size>");
            xml.append("<time-to-live-seconds>").append(n.getTimeToLiveSeconds()).append("</time-to-live-seconds>");
            xml.append("<max-idle-seconds>").append(n.getMaxIdleSeconds()).append("</max-idle-seconds>");
            xml.append("<eviction-policy>").append(n.getEvictionPolicy()).append("</eviction-policy>");
            xml.append("<invalidate-on-change>").append(n.isInvalidateOnChange()).append("</invalidate-on-change>");
            xml.append("<in-memory-format>").append((Object)n.getInMemoryFormat()).append("</in-memory-format>");
            xml.append("</near-cache>");
        }
    }

    private void multicastConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        MulticastConfig mcast = join.getMulticastConfig();
        xml.append("<multicast enabled=\"").append(mcast.isEnabled()).append("\">");
        xml.append("<multicast-group>").append(mcast.getMulticastGroup()).append("</multicast-group>");
        xml.append("<multicast-port>").append(mcast.getMulticastPort()).append("</multicast-port>");
        xml.append("<multicast-timeout-seconds>").append(mcast.getMulticastTimeoutSeconds()).append("</multicast-timeout-seconds>");
        xml.append("<multicast-time-to-live>").append(mcast.getMulticastTimeToLive()).append("</multicast-time-to-live>");
        if (!mcast.getTrustedInterfaces().isEmpty()) {
            xml.append("<trusted-interfaces>");
            for (String trustedInterface : mcast.getTrustedInterfaces()) {
                xml.append("<interface>").append(trustedInterface).append("</interface>");
            }
            xml.append("</trusted-interfaces>");
        }
        xml.append("</multicast>");
    }

    private void tcpConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        TcpIpConfig tcpCfg = join.getTcpIpConfig();
        xml.append("<tcp-ip enabled=\"").append(tcpCfg.isEnabled()).append("\">");
        List<String> members = tcpCfg.getMembers();
        for (String m : members) {
            xml.append("<member>").append(m).append("</member>");
        }
        if (tcpCfg.getRequiredMember() != null) {
            xml.append("<required-member>").append(tcpCfg.getRequiredMember()).append("</required-member>");
        }
        xml.append("</tcp-ip>");
    }

    private void awsConfigXmlGenerator(StringBuilder xml, JoinConfig join) {
        AwsConfig awsConfig = join.getAwsConfig();
        xml.append("<aws enabled=\"").append(awsConfig.isEnabled()).append("\">");
        xml.append("<access-key>").append(awsConfig.getAccessKey()).append("</access-key>");
        xml.append("<secret-key>").append(awsConfig.getSecretKey()).append("</secret-key>");
        xml.append("<region>").append(awsConfig.getRegion()).append("</region>");
        xml.append("<security-group-name>").append(awsConfig.getSecurityGroupName()).append("</security-group-name>");
        xml.append("<tag-key>").append(awsConfig.getTagKey()).append("</tag-key>");
        xml.append("<tag-value>").append(awsConfig.getTagValue()).append("</tag-value>");
        xml.append("</aws>");
    }

    private void interfacesConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        InterfacesConfig interfaces = netCfg.getInterfaces();
        xml.append("<interfaces enabled=\"").append(interfaces.isEnabled()).append("\">");
        Collection<String> interfaceList = interfaces.getInterfaces();
        for (String i : interfaceList) {
            xml.append("<interface>").append(i).append("</interface>");
        }
        xml.append("</interfaces>");
    }

    private void sslConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SSLConfig ssl = netCfg.getSSLConfig();
        xml.append("<ssl enabled=\"").append(ssl != null && ssl.isEnabled()).append("\">");
        if (ssl != null) {
            String className = ssl.getFactoryImplementation() != null ? ssl.getFactoryImplementation().getClass().getName() : ssl.getFactoryClassName();
            xml.append("<factory-class-name>").append(className).append("</factory-class-name>");
            this.appendProperties(xml, ssl.getProperties());
        }
        xml.append("</ssl>");
    }

    private void socketInterceptorConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SocketInterceptorConfig socket = netCfg.getSocketInterceptorConfig();
        xml.append("<socket-interceptor enabled=\"").append(socket != null && socket.isEnabled()).append("\">");
        if (socket != null) {
            String className = socket.getImplementation() != null ? socket.getImplementation().getClass().getName() : socket.getClassName();
            xml.append("<class-name>").append(className).append("</class-name>");
            this.appendProperties(xml, socket.getProperties());
        }
        xml.append("</socket-interceptor>");
    }

    private void symmetricEncInterceptorConfigXmlGenerator(StringBuilder xml, NetworkConfig netCfg) {
        SymmetricEncryptionConfig sec = netCfg.getSymmetricEncryptionConfig();
        xml.append("<symmetric-encryption enabled=\"").append(sec != null && sec.isEnabled()).append("\">");
        if (sec != null) {
            xml.append("<algorithm>").append(sec.getAlgorithm()).append("</algorithm>");
            xml.append("<salt>").append(sec.getSalt()).append("</salt>");
            xml.append("<password>").append(sec.getPassword()).append("</password>");
            xml.append("<iteration-count>").append(sec.getIterationCount()).append("</iteration-count>");
        }
        xml.append("</symmetric-encryption>");
    }

    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        try {
            Transformer transformer;
            StreamResult xmlOutput;
            StreamSource xmlInput;
            block8: {
                TransformerFactory transformerFactory;
                block7: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block7;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block8;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            LOGGER.warning(e);
            return input;
        }
    }

    private void appendProperties(StringBuilder xml, Properties props) {
        if (!props.isEmpty()) {
            xml.append("<properties>");
            Set<Object> keys = props.keySet();
            for (Object key : keys) {
                xml.append("<property name=\"").append(key).append("\">").append(props.getProperty(key.toString())).append("</property>");
            }
            xml.append("</properties>");
        }
    }
}

