/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.TrackableJob;
import com.hazelcast.mapreduce.impl.AbstractJob;
import com.hazelcast.mapreduce.impl.client.ClientCancellationRequest;
import com.hazelcast.mapreduce.impl.client.ClientJobProcessInformationRequest;
import com.hazelcast.mapreduce.impl.client.ClientMapReduceRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientMapReduceProxy
extends ClientProxy
implements JobTracker {
    private final ConcurrentMap<String, ClientTrackableJob> trackableJobs = new ConcurrentHashMap<String, ClientTrackableJob>();

    public ClientMapReduceProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        for (ClientTrackableJob trackableJob : this.trackableJobs.values()) {
            trackableJob.completableFuture.cancel(false);
        }
    }

    @Override
    public <K, V> Job<K, V> newJob(KeyValueSource<K, V> source) {
        return new ClientJob<K, V>(this.getName(), source);
    }

    @Override
    public <V> TrackableJob<V> getTrackableJob(String jobId) {
        return (TrackableJob)this.trackableJobs.get(jobId);
    }

    public String toString() {
        return "JobTracker{name='" + this.getName() + '\'' + '}';
    }

    private <T> T invoke(InvocationClientRequest request, String jobId) throws Exception {
        ClientContext context = this.getContext();
        ClientInvocationService cis = context.getInvocationService();
        ClientTrackableJob trackableJob = (ClientTrackableJob)this.trackableJobs.get(jobId);
        if (trackableJob != null) {
            Address runningMember = trackableJob.jobOwner;
            ICompletableFuture future = cis.invokeOnTarget(request, runningMember);
            return (T)future.get();
        }
        return null;
    }

    private final class ClientTrackableJob<V>
    implements TrackableJob<V> {
        private final String jobId;
        private final Address jobOwner;
        private final AbstractCompletableFuture<V> completableFuture;

        private ClientTrackableJob(String jobId, Address jobOwner, AbstractCompletableFuture<V> completableFuture) {
            this.jobId = jobId;
            this.jobOwner = jobOwner;
            this.completableFuture = completableFuture;
        }

        @Override
        public JobTracker getJobTracker() {
            return ClientMapReduceProxy.this;
        }

        @Override
        public String getName() {
            return ClientMapReduceProxy.this.getName();
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        public ICompletableFuture<V> getCompletableFuture() {
            return this.completableFuture;
        }

        @Override
        public JobProcessInformation getJobProcessInformation() {
            try {
                return (JobProcessInformation)ClientMapReduceProxy.this.invoke(new ClientJobProcessInformationRequest(this.getName(), this.jobId), this.jobId);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore(ignore);
                return null;
            }
        }
    }

    private class ClientCompletableFuture<V>
    extends AbstractCompletableFuture<V>
    implements JobCompletableFuture<V> {
        private final String jobId;
        private final CountDownLatch latch;
        private volatile boolean cancelled;

        protected ClientCompletableFuture(String jobId) {
            super(null, Logger.getLogger(ClientCompletableFuture.class));
            this.jobId = jobId;
            this.latch = new CountDownLatch(1);
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                this.cancelled = (Boolean)ClientMapReduceProxy.this.invoke(new ClientCancellationRequest(ClientMapReduceProxy.this.getName(), this.jobId), this.jobId);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore(ignore);
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setResult(Object result) {
            super.setResult(result);
            this.latch.countDown();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            ValidationUtil.isNotNull(unit, "unit");
            if (!this.latch.await(timeout, unit) || !this.isDone()) {
                throw new TimeoutException("timeout reached");
            }
            return this.getResult();
        }

        @Override
        protected ExecutorService getAsyncExecutor() {
            return ClientMapReduceProxy.this.getContext().getExecutionService().getAsyncExecutor();
        }
    }

    private class ClientJob<KeyIn, ValueIn>
    extends AbstractJob<KeyIn, ValueIn> {
        public ClientJob(String name, KeyValueSource<KeyIn, ValueIn> keyValueSource) {
            super(name, ClientMapReduceProxy.this, keyValueSource);
        }

        @Override
        protected <T> JobCompletableFuture<T> invoke(final Collator collator) {
            try {
                final String jobId = UuidUtil.buildRandomUuidString();
                ClientContext context = ClientMapReduceProxy.this.getContext();
                ClientInvocationService cis = context.getInvocationService();
                ClientMapReduceRequest request = new ClientMapReduceRequest(this.name, jobId, this.keys, this.predicate, this.mapper, this.combinerFactory, this.reducerFactory, this.keyValueSource, this.chunkSize, this.topologyChangedStrategy);
                final ClientCompletableFuture completableFuture = new ClientCompletableFuture(jobId);
                ClientCallFuture future = (ClientCallFuture)cis.invokeOnRandomTarget(request, null);
                future.andThen(new ExecutionCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Object res) {
                        Object response = res;
                        try {
                            if (collator != null) {
                                response = collator.collate(((Map)response).entrySet());
                            }
                        }
                        finally {
                            completableFuture.setResult(response);
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable throwable) {
                        Throwable t = throwable;
                        try {
                            if (t instanceof ExecutionException && t.getCause() instanceof CancellationException) {
                                t = t.getCause();
                            }
                            completableFuture.setResult(t);
                        }
                        finally {
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }
                });
                Address runningMember = future.getConnection().getRemoteEndpoint();
                ClientMapReduceProxy.this.trackableJobs.putIfAbsent(jobId, new ClientTrackableJob(jobId, runningMember, completableFuture));
                return completableFuture;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

