/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client.txn.proxy;

import com.hazelcast.client.impl.client.txn.TransactionContextProxy;
import com.hazelcast.client.impl.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.impl.client.TxnMultiMapGetRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapPutRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapRemoveAllRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapRemoveRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapSizeRequest;
import com.hazelcast.multimap.impl.client.TxnMultiMapValueCountRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.transaction.TransactionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(String name, TransactionContextProxy proxy) {
        super(name, proxy);
    }

    @Override
    public boolean put(K key, V value) throws TransactionException {
        TxnMultiMapPutRequest request = new TxnMultiMapPutRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> get(K key) {
        TxnMultiMapGetRequest request = new TxnMultiMapGetRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public boolean remove(Object key, Object value) {
        TxnMultiMapRemoveRequest request = new TxnMultiMapRemoveRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> remove(Object key) {
        TxnMultiMapRemoveAllRequest request = new TxnMultiMapRemoveAllRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public int valueCount(K key) {
        TxnMultiMapValueCountRequest request = new TxnMultiMapValueCountRequest(this.getName(), this.toData(key));
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public int size() {
        TxnMultiMapSizeRequest request = new TxnMultiMapSizeRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public String getName() {
        return (String)this.getId();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    void onDestroy() {
    }
}

