/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public abstract class AbstractCacheRecord<V>
implements CacheRecord<V>,
DataSerializable {
    protected long expirationTime = -1L;

    protected AbstractCacheRecord() {
    }

    public AbstractCacheRecord(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public boolean isExpiredAt(long now) {
        return this.expirationTime > -1L && this.expirationTime <= now;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.expirationTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.expirationTime = in.readLong();
    }
}

