/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.AbstractCacheProxyBase;
import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractInternalCacheProxy<K, V>
extends AbstractCacheProxyBase<K, V>
implements ICache<K, V> {
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;
    private final AtomicInteger completionIdCounter = new AtomicInteger();
    private final Object completionRegistrationMutex = new Object();
    private volatile String completionRegistrationId;

    protected AbstractInternalCacheProxy(CacheConfig cacheConfig, NodeEngine nodeEngine, ICacheService cacheService) {
        super(cacheConfig, nodeEngine, cacheService);
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
    }

    protected <T> InternalCompletableFuture<T> invoke(Operation op, Data keyData, boolean completionOperation) {
        Integer completionId = null;
        if (completionOperation) {
            completionId = this.registerCompletionLatch(1);
            if (op instanceof MutableOperation) {
                ((MutableOperation)((Object)op)).setCompletionId(completionId);
            }
        }
        try {
            int partitionId = CacheProxyUtil.getPartitionId(this.getNodeEngine(), keyData);
            InternalCompletableFuture f = this.getNodeEngine().getOperationService().invokeOnPartition(this.getServiceName(), op, partitionId);
            if (completionOperation) {
                this.waitCompletionLatch(completionId);
            }
            InternalCompletableFuture internalCompletableFuture = f;
            return internalCompletableFuture;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
        finally {
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
        }
    }

    protected <T> InternalCompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(oldValue);
        Operation operation = isGet ? this.operationProvider.createGetAndRemoveOperation((Data)keyData, -1) : this.operationProvider.createRemoveOperation((Data)keyData, (Data)valueData, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected <T> InternalCompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, newValue);
        }
        Object keyData = this.serializationService.toData(key);
        Object oldValueData = this.serializationService.toData(oldValue);
        Object newValueData = this.serializationService.toData(newValue);
        Operation operation = isGet ? this.operationProvider.createGetAndReplaceOperation((Data)keyData, (Data)newValueData, expiryPolicy, -1) : this.operationProvider.createReplaceOperation((Data)keyData, (Data)oldValueData, (Data)newValueData, expiryPolicy, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected <T> InternalCompletableFuture<T> putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(value);
        Operation op = this.operationProvider.createPutOperation((Data)keyData, (Data)valueData, expiryPolicy, isGet, -1);
        return this.invoke(op, (Data)keyData, withCompletionEvent);
    }

    protected InternalCompletableFuture<Boolean> putIfAbsentAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key, value);
        Object keyData = this.serializationService.toData(key);
        Object valueData = this.serializationService.toData(value);
        Operation operation = this.operationProvider.createPutIfAbsentOperation((Data)keyData, (Data)valueData, expiryPolicy, -1);
        return this.invoke(operation, (Data)keyData, withCompletionEvent);
    }

    protected void clearInternal() {
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        Integer completionId = this.registerCompletionLatch(partitionCount);
        OperationService operationService = this.getNodeEngine().getOperationService();
        OperationFactory operationFactory = this.operationProvider.createClearOperationFactory(completionId);
        try {
            Map<Integer, Object> results = operationService.invokeOnAllPartitions(this.getServiceName(), operationFactory);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.waitCompletionLatch(completionId, partitionCount - completionCount);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void removeAllInternal(Set<? extends K> keys) {
        HashSet<Data> keysData;
        if (keys != null) {
            keysData = new HashSet<Data>();
            for (K key : keys) {
                keysData.add((Data)this.serializationService.toData(key));
            }
        } else {
            keysData = null;
        }
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        Integer completionId = this.registerCompletionLatch(partitionCount);
        OperationService operationService = this.getNodeEngine().getOperationService();
        OperationFactory operationFactory = this.operationProvider.createRemoveAllOperationFactory(keysData, completionId);
        try {
            Map<Integer, Object> results = operationService.invokeOnAllPartitions(this.getServiceName(), operationFactory);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.waitCompletionLatch(completionId, partitionCount - completionCount);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst(t, CacheException.class);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
            this.registerCompletionListener();
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    public void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        ICacheService service = this.getService();
        for (String regId : listenerRegistrations) {
            service.deregisterListener(this.nameWithPrefix, regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.deregisterCompletionListener();
    }

    protected void countDownCompletionLatch(int id) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(id);
        if (countDownLatch == null) {
            return;
        }
        countDownLatch.countDown();
        if (countDownLatch.getCount() == 0L) {
            this.deregisterCompletionLatch(id);
        }
    }

    protected Integer registerCompletionLatch(int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int id = this.completionIdCounter.incrementAndGet();
            CountDownLatch countDownLatch = new CountDownLatch(count);
            this.syncLocks.put(id, countDownLatch);
            return id;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        this.syncLocks.remove(countDownLatchId);
    }

    protected void waitCompletionLatch(Integer countDownLatchId) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, int offset) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            for (int i = 0; i < offset; ++i) {
                countDownLatch.countDown();
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompletionListener() {
        if (!this.syncListenerRegistrations.isEmpty() && this.completionRegistrationId == null) {
            Object object = this.completionRegistrationMutex;
            synchronized (object) {
                if (this.completionRegistrationId == null) {
                    ICacheService service = this.getService();
                    CacheCompletionEventListener entryListener = new CacheCompletionEventListener();
                    this.completionRegistrationId = service.registerListener(this.getDistributedObjectName(), entryListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterCompletionListener() {
        if (this.syncListenerRegistrations.isEmpty() && this.completionRegistrationId != null) {
            Object object = this.completionRegistrationMutex;
            synchronized (object) {
                ICacheService service;
                boolean isDeregistered;
                if (this.completionRegistrationId != null && (isDeregistered = (service = this.getService()).deregisterListener(this.getDistributedObjectName(), this.completionRegistrationId))) {
                    this.completionRegistrationId = null;
                }
            }
        }
    }

    private final class CacheCompletionEventListener
    implements CacheEventListener {
        private CacheCompletionEventListener() {
        }

        @Override
        public void handleEvent(Object eventObject) {
            CacheEventData cacheEventData;
            if (eventObject instanceof CacheEventData && (cacheEventData = (CacheEventData)eventObject).getCacheEventType() == CacheEventType.COMPLETED) {
                Integer completionId = (Integer)AbstractInternalCacheProxy.this.serializationService.toObject(cacheEventData.getDataValue());
                AbstractInternalCacheProxy.this.countDownCompletionLatch(completionId);
            }
        }
    }
}

