/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public final class FutureUtil {
    public static final ExceptionHandler RETHROW_EVERYTHING = new ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            ExceptionUtil.rethrow(throwable);
        }
    };
    public static final ExceptionHandler IGNORE_ALL_EXCEPTIONS = new ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable instanceof MemberLeftException) {
                LOGGER.finest("Member left while waiting for futures...", throwable);
            }
        }
    };
    public static final ExceptionHandler MEMBER_LEFT_ONLY = new ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable instanceof MemberLeftException && LOGGER.isFinestEnabled()) {
                LOGGER.finest("Member left while waiting for futures...", throwable);
            }
        }
    };
    public static final ExceptionHandler RETHROW_EXECUTION_EXCEPTION = new ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable instanceof MemberLeftException) {
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Member left while waiting for futures...", throwable);
                }
            } else if (throwable instanceof ExecutionException) {
                throw new HazelcastException(throwable);
            }
        }
    };
    private static final ILogger LOGGER = Logger.getLogger(FutureUtil.class);

    private FutureUtil() {
    }

    @PrivateApi
    public static ExceptionHandler logAllExceptions(final ILogger logger, final String message, final Level level) {
        if (logger.isLoggable(level)) {
            return new ExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    logger.log(level, message, throwable);
                }
            };
        }
        return IGNORE_ALL_EXCEPTIONS;
    }

    @PrivateApi
    public static ExceptionHandler logAllExceptions(final String message, final Level level) {
        if (LOGGER.isLoggable(level)) {
            return new ExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    LOGGER.log(level, message, throwable);
                }
            };
        }
        return IGNORE_ALL_EXCEPTIONS;
    }

    @PrivateApi
    public static ExceptionHandler logAllExceptions(final ILogger logger, final Level level) {
        if (logger.isLoggable(level)) {
            return new ExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    logger.log(level, "Exception occurred", throwable);
                }
            };
        }
        return IGNORE_ALL_EXCEPTIONS;
    }

    @PrivateApi
    public static ExceptionHandler logAllExceptions(final Level level) {
        if (LOGGER.isLoggable(level)) {
            return new ExceptionHandler(){

                @Override
                public void handleException(Throwable throwable) {
                    LOGGER.log(level, "Exception occurred", throwable);
                }
            };
        }
        return IGNORE_ALL_EXCEPTIONS;
    }

    @PrivateApi
    public static <V> Collection<V> returnWithDeadline(Collection<Future> futures, long timeout, TimeUnit timeUnit) throws TimeoutException {
        return FutureUtil.returnWithDeadline(futures, timeout, timeUnit, MEMBER_LEFT_ONLY);
    }

    @PrivateApi
    public static <V> Collection<V> returnWithDeadline(Collection<Future> futures, long timeout, TimeUnit timeUnit, ExceptionHandler exceptionHandler) throws TimeoutException {
        return FutureUtil.returnWithDeadline(futures, timeout, timeUnit, timeout, timeUnit, exceptionHandler);
    }

    @PrivateApi
    public static <V> Collection<V> returnWithDeadline(Collection<Future> futures, long overallTimeout, TimeUnit overallTimeUnit, long perFutureTimeout, TimeUnit perFutureTimeUnit) throws TimeoutException {
        return FutureUtil.returnWithDeadline(futures, overallTimeout, overallTimeUnit, perFutureTimeout, perFutureTimeUnit, MEMBER_LEFT_ONLY);
    }

    @PrivateApi
    public static <V> Collection<V> returnWithDeadline(Collection<Future> futures, long overallTimeout, TimeUnit overallTimeUnit, long perFutureTimeout, TimeUnit perFutureTimeUnit, ExceptionHandler exceptionHandler) throws TimeoutException {
        long overallTimeoutNanos = FutureUtil.calculateTimeout(overallTimeout, overallTimeUnit);
        long perFutureTimeoutNanos = FutureUtil.calculateTimeout(perFutureTimeout, perFutureTimeUnit);
        long deadline = System.nanoTime() + overallTimeoutNanos;
        ArrayList<V> results = new ArrayList<V>(futures.size());
        for (Future future : futures) {
            try {
                long timeoutNanos = FutureUtil.calculateFutureTimeout(perFutureTimeoutNanos, deadline);
                V value = FutureUtil.executeWithDeadline(future, timeoutNanos, exceptionHandler);
                if (value == null) continue;
                results.add(value);
            }
            catch (TimeoutException e) {
                FutureUtil.cancelAllFutures(futures);
                throw e;
            }
            catch (RuntimeException e) {
                FutureUtil.cancelAllFutures(futures);
                throw e;
            }
            catch (Exception e) {
                FutureUtil.cancelAllFutures(futures);
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    @PrivateApi
    public static void waitWithDeadline(Collection<Future> futures, long timeout, TimeUnit timeUnit) throws TimeoutException {
        FutureUtil.waitWithDeadline(futures, timeout, timeUnit, MEMBER_LEFT_ONLY);
    }

    @PrivateApi
    public static void waitWithDeadline(Collection<Future> futures, long timeout, TimeUnit timeUnit, ExceptionHandler exceptionHandler) throws TimeoutException {
        FutureUtil.waitWithDeadline(futures, timeout, timeUnit, timeout, timeUnit, exceptionHandler);
    }

    @PrivateApi
    public static void waitWithDeadline(Collection<Future> futures, long overallTimeout, TimeUnit overallTimeUnit, long perFutureTimeout, TimeUnit perFutureTimeUnit) throws TimeoutException {
        FutureUtil.waitWithDeadline(futures, overallTimeout, overallTimeUnit, perFutureTimeout, perFutureTimeUnit, MEMBER_LEFT_ONLY);
    }

    @PrivateApi
    public static void waitWithDeadline(Collection<Future> futures, long overallTimeout, TimeUnit overallTimeUnit, long perFutureTimeout, TimeUnit perFutureTimeUnit, ExceptionHandler exceptionHandler) throws TimeoutException {
        long overallTimeoutNanos = FutureUtil.calculateTimeout(overallTimeout, overallTimeUnit);
        long perFutureTimeoutNanos = FutureUtil.calculateTimeout(perFutureTimeout, perFutureTimeUnit);
        long deadline = System.nanoTime() + overallTimeoutNanos;
        for (Future future : futures) {
            try {
                long timeoutNanos = FutureUtil.calculateFutureTimeout(perFutureTimeoutNanos, deadline);
                FutureUtil.executeWithDeadline(future, timeoutNanos, exceptionHandler);
            }
            catch (TimeoutException e) {
                FutureUtil.cancelAllFutures(futures);
                throw e;
            }
            catch (RuntimeException e) {
                FutureUtil.cancelAllFutures(futures);
                throw e;
            }
            catch (Exception e) {
                FutureUtil.cancelAllFutures(futures);
                throw new RuntimeException(e);
            }
        }
    }

    private static <V> void cancelAllFutures(Collection<Future> futures) {
        for (Future future : futures) {
            future.cancel(true);
        }
    }

    private static <V> V executeWithDeadline(Future<V> future, long timeoutNanos, ExceptionHandler exceptionHandler) throws Exception {
        try {
            if (timeoutNanos <= 0L) {
                if (future.isDone() || future.isCancelled()) {
                    return FutureUtil.retrieveValue(future);
                }
                throw new TimeoutException();
            }
            return future.get(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (MemberLeftException e) {
            exceptionHandler.handleException(e);
        }
        catch (ExecutionException e) {
            exceptionHandler.handleException(e);
        }
        return null;
    }

    private static <V> V retrieveValue(Future<V> future) throws ExecutionException, InterruptedException {
        if (future instanceof InternalCompletableFuture) {
            return (V)((InternalCompletableFuture)future).getSafely();
        }
        return future.get();
    }

    private static long calculateTimeout(long timeout, TimeUnit timeUnit) {
        timeUnit = timeUnit == null ? TimeUnit.SECONDS : timeUnit;
        return timeUnit.toNanos(timeout);
    }

    private static long calculateFutureTimeout(long perFutureTimeoutNanos, long deadline) {
        long remainingNanos = deadline - System.nanoTime();
        return Math.min(remainingNanos, perFutureTimeoutNanos);
    }

    public static interface ExceptionHandler {
        public void handleException(Throwable var1);
    }
}

