/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MaxSizeConfigReadOnly;

public class MaxSizeConfig {
    private MaxSizeConfigReadOnly readOnly;
    private int size = Integer.MAX_VALUE;
    private MaxSizePolicy maxSizePolicy = MaxSizePolicy.PER_NODE;

    public MaxSizeConfig() {
    }

    public MaxSizeConfig(int size, MaxSizePolicy maxSizePolicy) {
        this.size = size;
        this.maxSizePolicy = maxSizePolicy;
    }

    public MaxSizeConfig(MaxSizeConfig config) {
        this.size = config.size;
        this.maxSizePolicy = config.maxSizePolicy;
    }

    public MaxSizeConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MaxSizeConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getSize() {
        return this.size;
    }

    public MaxSizeConfig setSize(int size) {
        int paramSize = size;
        if (paramSize <= 0) {
            paramSize = Integer.MAX_VALUE;
        }
        this.size = paramSize;
        return this;
    }

    public MaxSizePolicy getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public MaxSizeConfig setMaxSizePolicy(MaxSizePolicy maxSizePolicy) {
        this.maxSizePolicy = maxSizePolicy;
        return this;
    }

    public String toString() {
        return "MaxSizeConfig{maxSizePolicy='" + (Object)((Object)this.maxSizePolicy) + '\'' + ", size=" + this.size + '}';
    }

    public static enum MaxSizePolicy {
        PER_NODE,
        PER_PARTITION,
        USED_HEAP_PERCENTAGE,
        USED_HEAP_SIZE;

    }
}

