/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.map.record.RecordReplicationInfo;
import com.hazelcast.map.record.Records;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation {
    private Map<String, Set<RecordReplicationInfo>> data;
    private Map<String, List<DelayedEntry>> delayedEntries;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(MapService mapService, PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
            String name = (String)entry.getKey();
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>(recordStore.size());
            Iterator<Record> iterator = recordStore.iterator();
            while (iterator.hasNext()) {
                Record record = iterator.next();
                RecordReplicationInfo recordReplicationInfo = this.createRecordReplicationInfo(record, mapService);
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(name, recordSet);
        }
        this.readDelayedEntries(container);
    }

    private void readDelayedEntries(PartitionContainer container) {
        this.delayedEntries = new HashMap<String, List<DelayedEntry>>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            WriteBehindQueue<DelayedEntry> writeBehindQueue;
            List<DelayedEntry> delayedEntries;
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            if (!mapContainer.isWriteBehindMapStoreEnabled() || (delayedEntries = (writeBehindQueue = ((WriteBehindStore)recordStore.getMapDataStore()).getWriteBehindQueue()).getSnapShot().asList()) != null && delayedEntries.size() == 0) continue;
            this.delayedEntries.put((String)entry.getKey(), delayedEntries);
        }
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        if (this.data != null) {
            for (Map.Entry<String, Collection<Object>> entry : this.data.entrySet()) {
                Set recordReplicationInfos = (Set)entry.getValue();
                String mapName = entry.getKey();
                RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), mapName);
                recordStore.reset();
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Data key = recordReplicationInfo.getKey();
                    Data value = recordReplicationInfo.getValue();
                    MapContainer mapContainer = mapServiceContext.getMapContainer(mapName);
                    Record newRecord = mapContainer.createRecord(key, value, -1L, Clock.currentTimeMillis());
                    Records.applyRecordInfo(newRecord, recordReplicationInfo);
                    recordStore.putRecord(key, newRecord);
                }
                recordStore.setLoaded(true);
            }
        }
        for (Map.Entry<String, Collection<Object>> entry : this.delayedEntries.entrySet()) {
            RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), entry.getKey());
            List replicatedEntries = (List)entry.getValue();
            WriteBehindQueue<DelayedEntry> writeBehindQueue = ((WriteBehindStore)recordStore.getMapDataStore()).getWriteBehindQueue();
            writeBehindQueue.addEnd(replicatedEntries);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int j;
        int i;
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (i = 0; i < size; ++i) {
            String name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
        size = in.readInt();
        this.delayedEntries = new HashMap<String, List<DelayedEntry>>(size);
        for (i = 0; i < size; ++i) {
            String mapName = in.readUTF();
            int listSize = in.readInt();
            ArrayList<DelayedEntry<Data, Data>> delayedEntriesList = new ArrayList<DelayedEntry<Data, Data>>(listSize);
            for (j = 0; j < listSize; ++j) {
                Data key = IOUtil.readNullableData(in);
                Data value = IOUtil.readNullableData(in);
                long storeTime = in.readLong();
                int partitionId = in.readInt();
                DelayedEntry<Data, Data> entry = DelayedEntry.create(key, value, storeTime, partitionId);
                delayedEntriesList.add(entry);
            }
            this.delayedEntries.put(mapName, delayedEntriesList);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> mapEntry : this.data.entrySet()) {
            out.writeUTF(mapEntry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = mapEntry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        out.writeInt(this.delayedEntries.size());
        for (Map.Entry<String, List<DelayedEntry>> entry : this.delayedEntries.entrySet()) {
            out.writeUTF(entry.getKey());
            List<DelayedEntry> delayedEntryList = entry.getValue();
            out.writeInt(delayedEntryList.size());
            for (DelayedEntry e : delayedEntryList) {
                Data key = mapServiceContext.toData(e.getKey());
                Data value = mapServiceContext.toData(e.getValue());
                IOUtil.writeNullableData(out, key);
                IOUtil.writeNullableData(out, value);
                out.writeLong(e.getStoreTime());
                out.writeInt(e.getPartitionId());
            }
        }
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    private RecordReplicationInfo createRecordReplicationInfo(Record record, MapService mapService) {
        RecordInfo info = Records.buildRecordInfo(record);
        return new RecordReplicationInfo(record.getKey(), mapService.getMapServiceContext().toData(record.getValue()), info);
    }
}

