/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCache;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.operation.InvalidateNearCacheOperation;
import com.hazelcast.map.operation.NearCacheKeySetInvalidationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NearCacheProvider {
    private final ConcurrentMap<String, NearCache> nearCacheMap = new ConcurrentHashMap<String, NearCache>();
    private final ConstructorFunction<String, NearCache> nearCacheConstructor = new ConstructorFunction<String, NearCache>(){

        @Override
        public NearCache createNew(String mapName) {
            MapContainer mapContainer = NearCacheProvider.this.mapServiceContext.getMapContainer(mapName);
            SizeEstimator nearCacheSizeEstimator = mapContainer.getNearCacheSizeEstimator();
            NearCache nearCache = new NearCache(mapName, NearCacheProvider.this.nodeEngine);
            nearCache.setNearCacheSizeEstimator(nearCacheSizeEstimator);
            return nearCache;
        }
    };
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public NearCacheProvider(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = nodeEngine;
    }

    public NearCache getNearCache(String mapName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.nearCacheMap, mapName, this.nearCacheConstructor);
    }

    public void clear() {
        for (NearCache nearCache : this.nearCacheMap.values()) {
            nearCache.clear();
        }
        this.nearCacheMap.clear();
    }

    public void remove(String mapName) {
        NearCache nearCache = (NearCache)this.nearCacheMap.remove(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    public Object putNearCache(String mapName, Data key, Data value) {
        if (!this.isNearCacheEnabled(mapName)) {
            return null;
        }
        NearCache nearCache = this.getNearCache(mapName);
        return nearCache.put(key, value);
    }

    public void invalidateNearCache(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getNearCache(mapName);
        nearCache.invalidate(key);
    }

    public void invalidateNearCache(String mapName, Collection<Data> keys) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getNearCache(mapName);
        nearCache.invalidate(keys);
    }

    public void clearNearCache(String mapName) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        NearCache nearCache = this.getNearCache(mapName);
        if (nearCache != null) {
            nearCache.clear();
        }
    }

    public void invalidateAllNearCaches(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                Operation operation = new InvalidateNearCacheOperation(mapName, key).setServiceName("hz:impl:mapService");
                this.nodeEngine.getOperationService().send(operation, member.getAddress());
            }
            catch (Throwable throwable) {
                throw new HazelcastException(throwable);
            }
        }
        this.invalidateNearCache(mapName, key);
    }

    public boolean isNearCacheAndInvalidationEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.isNearCacheEnabled() && mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange();
    }

    public boolean isNearCacheEnabled(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        return mapContainer.isNearCacheEnabled();
    }

    public void invalidateAllNearCaches(String mapName, Set<Data> keys) {
        if (!this.isNearCacheEnabled(mapName)) {
            return;
        }
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Operation operation = new NearCacheKeySetInvalidationOperation(mapName, keys).setServiceName("hz:impl:mapService");
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                this.nodeEngine.getOperationService().send(operation, member.getAddress());
            }
            catch (Throwable throwable) {
                this.nodeEngine.getLogger(this.getClass()).warning(throwable);
            }
        }
        for (Data key : keys) {
            this.invalidateNearCache(mapName, key);
        }
    }

    public Object getFromNearCache(String mapName, Data key) {
        if (!this.isNearCacheEnabled(mapName)) {
            return null;
        }
        NearCache nearCache = this.getNearCache(mapName);
        return nearCache.get(key);
    }
}

