/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.cluster.TcpIpJoiner;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;

public class TcpIpJoinerOverAWS
extends TcpIpJoiner {
    final AWSClient aws;
    final ILogger logger;

    public TcpIpJoinerOverAWS(Node node) {
        super(node);
        this.logger = node.getLogger(this.getClass());
        AwsConfig awsConfig = node.getConfig().getNetworkConfig().getJoin().getAwsConfig();
        this.aws = new AWSClient(awsConfig);
        if (awsConfig.getRegion() != null && awsConfig.getRegion().length() > 0) {
            this.aws.setEndpoint("ec2." + awsConfig.getRegion() + ".amazonaws.com");
        }
    }

    @Override
    protected Collection<String> getMembers() {
        try {
            Collection<String> list = this.aws.getPrivateIpAddresses();
            if (list.isEmpty()) {
                this.logger.warning("No EC2 instances found!");
            } else if (this.logger.isFinestEnabled()) {
                StringBuilder sb = new StringBuilder("Found the following EC2 instances:\n");
                for (String ip : list) {
                    sb.append("    ").append(ip).append("\n");
                }
                this.logger.finest(sb.toString());
            }
            return list;
        }
        catch (Exception e) {
            this.logger.warning(e);
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected int getConnTimeoutSeconds() {
        AwsConfig awsConfig = this.node.getConfig().getNetworkConfig().getJoin().getAwsConfig();
        return awsConfig.getConnectionTimeoutSeconds();
    }

    @Override
    public String getType() {
        return "aws";
    }
}

