/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberInfoUpdateOperation;
import com.hazelcast.cluster.PostJoinOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.util.FutureUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FinalizeJoinOperation
extends MemberInfoUpdateOperation
implements JoinOperation {
    static final int FINALIZE_JOIN_MAX_TIMEOUT = 30;
    private PostJoinOperation postJoinOp;

    public FinalizeJoinOperation() {
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime) {
        super(members, masterTime, true);
        this.postJoinOp = postJoinOp;
    }

    @Override
    public void run() throws Exception {
        if (this.isValid()) {
            this.processMemberUpdate();
            ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
            NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
            Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
            OperationService operationService = nodeEngine.getOperationService();
            ArrayList<Future> calls = null;
            if (postJoinOperations != null && postJoinOperations.length > 0) {
                Collection<MemberImpl> members = clusterService.getMemberList();
                calls = new ArrayList<Future>(members.size());
                for (MemberImpl member : members) {
                    if (member.localMember()) continue;
                    PostJoinOperation operation = new PostJoinOperation(postJoinOperations);
                    InternalCompletableFuture f = operationService.createInvocationBuilder("hz:core:clusterService", (Operation)operation, member.getAddress()).setTryCount(10).setTryPauseMillis(100L).invoke();
                    calls.add(f);
                }
            }
            if (this.postJoinOp != null) {
                this.postJoinOp.setNodeEngine(nodeEngine);
                OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
                OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
                this.postJoinOp.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                operationService.runOperationOnCallingThread(this.postJoinOp);
            }
            if (calls != null) {
                FutureUtil.waitWithDeadline(calls, Math.min(calls.size(), 30), TimeUnit.SECONDS, new FinalizeJoinExceptionHandler());
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOperation();
            this.postJoinOp.readData(in);
        }
    }

    private class FinalizeJoinExceptionHandler
    implements FutureUtil.ExceptionHandler {
        private FinalizeJoinExceptionHandler() {
        }

        @Override
        public void handleException(Throwable throwable) {
            ILogger logger;
            if (throwable instanceof ExecutionException && (logger = FinalizeJoinOperation.this.getLogger()).isFinestEnabled()) {
                logger.finest("Error while executing post-join operations -> " + throwable.getClass().getSimpleName() + "[" + throwable.getMessage() + "]", throwable);
            }
        }
    }
}

