/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.operation.CacheReplaceOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CacheReplaceRequest
extends AbstractCacheRequest {
    protected Data key;
    protected Data value;
    protected Data currentValue;
    protected ExpiryPolicy expiryPolicy;
    private int completionId;

    public CacheReplaceRequest() {
    }

    public CacheReplaceRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy) {
        super(name);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
    }

    public CacheReplaceRequest(String name, Data key, Data currentValue, Data value, ExpiryPolicy expiryPolicy) {
        super(name);
        this.key = key;
        this.value = value;
        this.currentValue = currentValue;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheReplaceOperation(this.name, this.key, this.currentValue, this.value, this.expiryPolicy, this.completionId);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("c", this.completionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
        IOUtil.writeNullableData(out, this.currentValue);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.completionId = reader.readInt("c");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
        this.currentValue = IOUtil.readNullableData(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }
}

