/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.impl.SafeStateCheckOperation;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PartitionServiceProxy
implements PartitionService {
    private final InternalPartitionService partitionService;
    private final ConcurrentMap<Integer, PartitionProxy> mapPartitions = new ConcurrentHashMap<Integer, PartitionProxy>();
    private final Set<Partition> partitions = new TreeSet<Partition>();
    private final Random random = new Random();
    private final ILogger logger;

    public PartitionServiceProxy(InternalPartitionService partitionService) {
        this.partitionService = partitionService;
        for (int i = 0; i < partitionService.getPartitionCount(); ++i) {
            PartitionProxy partitionProxy = new PartitionProxy(i);
            this.partitions.add(partitionProxy);
            this.mapPartitions.put(i, partitionProxy);
        }
        this.logger = this.getNode().getLogger(PartitionServiceProxy.class);
    }

    @Override
    public String randomPartitionKey() {
        return Integer.toString(this.random.nextInt(this.partitionService.getPartitionCount()));
    }

    @Override
    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public PartitionProxy getPartition(Object key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.getPartition(partitionId);
    }

    @Override
    public String addMigrationListener(MigrationListener migrationListener) {
        return this.partitionService.addMigrationListener(migrationListener);
    }

    @Override
    public boolean removeMigrationListener(String registrationId) {
        return this.partitionService.removeMigrationListener(registrationId);
    }

    @Override
    public boolean isClusterSafe() {
        Node node = this.getNode();
        Collection<MemberImpl> memberList = node.clusterService.getMemberList();
        if (memberList == null || memberList.isEmpty() || memberList.size() < 2) {
            return true;
        }
        ArrayList futures = new ArrayList(memberList.size());
        for (MemberImpl member : memberList) {
            Address address = member.getAddress();
            SafeStateCheckOperation operation = new SafeStateCheckOperation();
            InternalCompletableFuture future = node.getNodeEngine().getOperationService().invokeOnTarget("hz:core:partitionService", operation, address);
            futures.add(future);
        }
        int maxWaitTime = PartitionServiceProxy.getMaxWaitTime(node);
        for (Future future : futures) {
            try {
                Object result = future.get(maxWaitTime, TimeUnit.SECONDS);
                boolean safe = (Boolean)result;
                if (safe) continue;
                return false;
            }
            catch (Exception e) {
                this.logger.warning("Error while querying cluster's safe state", e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isMemberSafe(Member member) {
        boolean safe;
        if (member == null) {
            throw new NullPointerException("Parameter member should not be null");
        }
        MemberImpl localMember = this.getNode().getLocalMember();
        if (localMember.equals(member)) {
            return this.isLocalMemberSafe();
        }
        Address target = ((MemberImpl)member).getAddress();
        SafeStateCheckOperation operation = new SafeStateCheckOperation();
        InternalCompletableFuture future = this.getNode().getNodeEngine().getOperationService().invokeOnTarget("hz:core:partitionService", operation, target);
        try {
            Object result = future.get(10L, TimeUnit.SECONDS);
            safe = (Boolean)result;
        }
        catch (Throwable t) {
            safe = false;
            this.logger.warning("Error while querying member's safe state [" + member + "]", t);
        }
        return safe;
    }

    @Override
    public boolean isLocalMemberSafe() {
        if (!this.nodeActive()) {
            return true;
        }
        return this.partitionService.isMemberStateSafe();
    }

    @Override
    public boolean forceLocalMemberToBeSafe(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (timeout < 1L) {
            throw new IllegalArgumentException();
        }
        if (!this.nodeActive()) {
            return true;
        }
        return this.partitionService.prepareToSafeShutdown(timeout, unit);
    }

    @Override
    public boolean drain(long timeout, TimeUnit timeunit) {
        if (timeunit == null) {
            throw new NullPointerException();
        }
        if (timeout < 1L) {
            throw new IllegalArgumentException();
        }
        if (!this.nodeActive()) {
            return true;
        }
        return this.partitionService.drain(timeout, timeunit);
    }

    private boolean nodeActive() {
        Node node = this.getNode();
        return node.isActive();
    }

    private Node getNode() {
        InternalPartitionServiceImpl impl = (InternalPartitionServiceImpl)this.partitionService;
        return impl.getNode();
    }

    private static int getMaxWaitTime(Node node) {
        return node.getGroupProperties().GRACEFUL_SHUTDOWN_MAX_WAIT.getInteger();
    }

    public PartitionProxy getPartition(int partitionId) {
        return (PartitionProxy)this.mapPartitions.get(partitionId);
    }

    public class PartitionProxy
    implements Partition,
    Comparable {
        final int partitionId;

        PartitionProxy(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address address = PartitionServiceProxy.this.partitionService.getPartitionOwner(this.partitionId);
            if (address == null) {
                return null;
            }
            return PartitionServiceProxy.this.partitionService.getMember(address);
        }

        public int compareTo(Object o) {
            PartitionProxy partition = (PartitionProxy)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionProxy partition = (PartitionProxy)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.getOwner();
        }
    }
}

