/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.impl.client.MultiTargetClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.AddInterceptorOperationFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class MapAddInterceptorRequest
extends MultiTargetClientRequest
implements Portable,
SecureRequest {
    private String name;
    private MapInterceptor mapInterceptor;
    private transient String id;

    public MapAddInterceptorRequest() {
    }

    public MapAddInterceptorRequest(String name, MapInterceptor mapInterceptor) {
        this.name = name;
        this.mapInterceptor = mapInterceptor;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapService mapService = (MapService)this.getService();
        this.id = mapService.getMapServiceContext().addInterceptor(this.name, this.mapInterceptor);
        return new AddInterceptorOperationFactory(this.id, this.name, this.mapInterceptor);
    }

    @Override
    protected Object reduce(Map<Address, Object> map) {
        return this.id;
    }

    @Override
    public Collection<Address> getTargets() {
        Collection<MemberImpl> memberList = this.getClientEngine().getClusterService().getMemberList();
        HashSet<Address> addresses = new HashSet<Address>();
        for (MemberImpl member : memberList) {
            if (member.localMember()) continue;
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.mapInterceptor);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.mapInterceptor = (MapInterceptor)in.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.mapInterceptor};
    }
}

