/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

public enum Capability {
    PARTITION_HOST(0);

    private final int id;

    private Capability(int id) {
        this.id = id;
    }

    public static Capability valueOf(int id) {
        for (Capability capability : Capability.values()) {
            if (capability.id != id) continue;
            return capability;
        }
        throw new IllegalArgumentException(String.format("No capability with id [%d] could be found", id));
    }

    public static Set<Capability> readCapabilities(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        EnumSet<Capability> capabilities = EnumSet.noneOf(Capability.class);
        for (int i = 0; i < size; ++i) {
            capabilities.add(Capability.valueOf(in.readInt()));
        }
        return capabilities;
    }

    public static void writeCapabilities(ObjectDataOutput out, Set<Capability> capabilities) throws IOException {
        out.writeInt(capabilities.size());
        for (Capability capability : capabilities) {
            out.writeInt(capability.id);
        }
    }
}

