/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.HealthMonitorLevel;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class HealthMonitor
extends Thread {
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private static final double PERCENTAGE_MULTIPLIER = 100.0;
    private static final double THRESHOLD = 70.0;
    private static final Set<String> YOUNG_GC = new HashSet<String>(3);
    private static final Set<String> OLD_GC = new HashSet<String>(3);
    private final ILogger logger;
    private final Node node;
    private final Runtime runtime;
    private final OperatingSystemMXBean osMxBean;
    private final HealthMonitorLevel logLevel;
    private final int delaySeconds;
    private final ClusterServiceImpl clusterService;
    private final ExecutionService executionService;
    private final EventService eventService;
    private final LockService lockService;
    private final OperationService operationService;
    private final ProxyService proxyService;
    private final ConnectionManager connectionManager;
    private final ClientEngineImpl clientEngine;
    private final ThreadMXBean threadMxBean;

    public HealthMonitor(HazelcastInstanceImpl hazelcastInstance, HealthMonitorLevel logLevel, int delaySeconds) {
        super(hazelcastInstance.node.threadGroup, hazelcastInstance.node.getThreadNamePrefix("HealthMonitor"));
        this.setDaemon(true);
        this.node = hazelcastInstance.node;
        this.logger = this.node.getLogger(HealthMonitor.class.getName());
        this.runtime = Runtime.getRuntime();
        this.osMxBean = ManagementFactory.getOperatingSystemMXBean();
        this.logLevel = logLevel;
        this.delaySeconds = delaySeconds;
        this.threadMxBean = ManagementFactory.getThreadMXBean();
        this.clusterService = this.node.getClusterService();
        this.executionService = this.node.nodeEngine.getExecutionService();
        this.eventService = this.node.nodeEngine.getEventService();
        this.lockService = (LockService)this.node.nodeEngine.getSharedService("hz:impl:lockService");
        this.operationService = this.node.nodeEngine.getOperationService();
        this.proxyService = this.node.nodeEngine.getProxyService();
        this.clientEngine = this.node.clientEngine;
        this.connectionManager = this.node.connectionManager;
    }

    @Override
    public void run() {
        if (this.logLevel == HealthMonitorLevel.OFF) {
            return;
        }
        while (this.node.isActive()) {
            switch (this.logLevel) {
                case NOISY: {
                    HealthMetrics metrics = new HealthMetrics();
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                case SILENT: {
                    HealthMetrics metrics = new HealthMetrics();
                    if (!metrics.exceedsThreshold()) break;
                    this.logger.log(Level.INFO, metrics.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("unrecognized logLevel:" + (Object)((Object)this.logLevel));
                }
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.delaySeconds));
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static long get(OperatingSystemMXBean mbean, String methodName, long defaultValue) {
        try {
            Method method = mbean.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object value = method.invoke((Object)mbean, new Object[0]);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Double) {
                double v = (Double)value;
                return Math.round(v * 100.0);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        return defaultValue;
    }

    public static String percentageString(double p) {
        return String.format("%.2f", p) + "%";
    }

    public static String numberToUnitRepresentation(long number) {
        for (int i = 6; i > 0; --i) {
            double step = Math.pow(1024.0, i);
            if (!((double)number > step)) continue;
            return String.format("%3.1f%s", (double)number / step, UNITS[i]);
        }
        return Long.toString(number);
    }

    static {
        YOUNG_GC.add("PS Scavenge");
        YOUNG_GC.add("ParNew");
        YOUNG_GC.add("G1 Young Generation");
        OLD_GC.add("PS MarkSweep");
        OLD_GC.add("ConcurrentMarkSweep");
        OLD_GC.add("G1 Old Generation");
    }

    private static final class GcMetrics {
        final long minorCount;
        final long minorTime;
        final long majorCount;
        final long majorTime;
        final long unknownCount;
        final long unknownTime;

        private GcMetrics() {
            long minorCount = 0L;
            long minorTime = 0L;
            long majorCount = 0L;
            long majorTime = 0L;
            long unknownCount = 0L;
            long unknownTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count < 0L) continue;
                if (YOUNG_GC.contains(gc.getName())) {
                    minorCount += count;
                    minorTime += gc.getCollectionTime();
                    continue;
                }
                if (OLD_GC.contains(gc.getName())) {
                    majorCount += count;
                    majorTime += gc.getCollectionTime();
                    continue;
                }
                unknownCount += count;
                unknownTime += gc.getCollectionTime();
            }
            this.minorCount = minorCount;
            this.minorTime = minorTime;
            this.majorCount = majorCount;
            this.majorTime = majorTime;
            this.unknownCount = unknownCount;
            this.unknownTime = unknownTime;
        }
    }

    private class HealthMetrics {
        private final long physicalMemoryTotal;
        private final long physicalMemoryFree;
        private final long swapSpaceTotal;
        private final long swapSpaceFree;
        private final long memoryFree;
        private final long memoryTotal;
        private final long memoryUsed;
        private final long memoryMax;
        private final double memoryUsedOfTotalPercentage;
        private final double memoryUsedOfMaxPercentage;
        private final double processCpuLoad;
        private final double systemLoadAverage;
        private final double systemCpuLoad;
        private final int threadCount;
        private final int peakThreadCount;
        private final long clusterTimeDiff;
        private final int asyncExecutorQueueSize;
        private final int clientExecutorQueueSize;
        private final int queryExecutorQueueSize;
        private final int scheduledExecutorQueueSize;
        private final int systemExecutorQueueSize;
        private final int eventQueueSize;
        private final int lockCount;
        private final int operationServiceOperationExecutorQueueSize;
        private final int operationServiceOperationPriorityExecutorQueueSize;
        private final int operationServiceOperationResponseQueueSize;
        private final String responseStats;
        private final int runningOperationsCount;
        private final int remoteOperationsCount;
        private final long executedOperationsCount;
        private final String remoteOperationStats;
        private final int proxyCount;
        private final int clientEndpointCount;
        private final int activeConnectionCount;
        private final int connectionCount;
        private final int ioExecutorQueueSize;
        private final GcMetrics gcMetrics;

        public HealthMetrics() {
            this.physicalMemoryTotal = HealthMonitor.get(HealthMonitor.this.osMxBean, "getTotalPhysicalMemorySize", -1L);
            this.physicalMemoryFree = HealthMonitor.get(HealthMonitor.this.osMxBean, "getFreePhysicalMemorySize", -1L);
            this.swapSpaceTotal = HealthMonitor.get(HealthMonitor.this.osMxBean, "getTotalSwapSpaceSize", -1L);
            this.swapSpaceFree = HealthMonitor.get(HealthMonitor.this.osMxBean, "getFreeSwapSpaceSize", -1L);
            this.memoryFree = HealthMonitor.this.runtime.freeMemory();
            this.memoryTotal = HealthMonitor.this.runtime.totalMemory();
            this.memoryUsed = this.memoryTotal - this.memoryFree;
            this.memoryMax = HealthMonitor.this.runtime.maxMemory();
            this.memoryUsedOfTotalPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryTotal;
            this.memoryUsedOfMaxPercentage = 100.0 * (double)this.memoryUsed / (double)this.memoryMax;
            this.processCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getProcessCpuLoad", -1L);
            this.systemLoadAverage = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemLoadAverage", -1L);
            this.systemCpuLoad = HealthMonitor.get(HealthMonitor.this.osMxBean, "getSystemCpuLoad", -1L);
            this.threadCount = HealthMonitor.this.threadMxBean.getThreadCount();
            this.peakThreadCount = HealthMonitor.this.threadMxBean.getPeakThreadCount();
            this.clusterTimeDiff = HealthMonitor.this.clusterService.getClusterTimeDiff();
            this.asyncExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:async").getQueueSize();
            this.clientExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:client").getQueueSize();
            this.queryExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:query").getQueueSize();
            this.scheduledExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:scheduled").getQueueSize();
            this.systemExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:system").getQueueSize();
            this.ioExecutorQueueSize = HealthMonitor.this.executionService.getExecutor("hz:io").getQueueSize();
            this.eventQueueSize = HealthMonitor.this.eventService.getEventQueueSize();
            this.lockCount = HealthMonitor.this.lockService.getAllLocks().size();
            this.operationServiceOperationExecutorQueueSize = HealthMonitor.this.operationService.getOperationExecutorQueueSize();
            this.operationServiceOperationPriorityExecutorQueueSize = HealthMonitor.this.operationService.getPriorityOperationExecutorQueueSize();
            this.operationServiceOperationResponseQueueSize = HealthMonitor.this.operationService.getResponseQueueSize();
            this.responseStats = HealthMonitor.this.operationService.getResponseStats();
            this.runningOperationsCount = HealthMonitor.this.operationService.getRunningOperationsCount();
            this.remoteOperationsCount = HealthMonitor.this.operationService.getRemoteOperationsCount();
            this.executedOperationsCount = HealthMonitor.this.operationService.getExecutedOperationCount();
            this.remoteOperationStats = HealthMonitor.this.operationService.getRemoteOperationStats();
            this.proxyCount = HealthMonitor.this.proxyService.getProxyCount();
            this.clientEndpointCount = HealthMonitor.this.clientEngine.getClientEndpointCount();
            this.activeConnectionCount = HealthMonitor.this.connectionManager.getActiveConnectionCount();
            this.connectionCount = HealthMonitor.this.connectionManager.getConnectionCount();
            this.gcMetrics = new GcMetrics();
        }

        public boolean exceedsThreshold() {
            if (this.memoryUsedOfMaxPercentage > 70.0) {
                return true;
            }
            if (this.processCpuLoad > 70.0) {
                return true;
            }
            return this.systemCpuLoad > 70.0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("processors=").append(HealthMonitor.this.runtime.availableProcessors()).append(", ");
            sb.append("physical.memory.total=").append(HealthMonitor.numberToUnitRepresentation(this.physicalMemoryTotal)).append(", ");
            sb.append("physical.memory.free=").append(HealthMonitor.numberToUnitRepresentation(this.physicalMemoryFree)).append(", ");
            sb.append("swap.space.total=").append(HealthMonitor.numberToUnitRepresentation(this.swapSpaceTotal)).append(", ");
            sb.append("swap.space.free=").append(HealthMonitor.numberToUnitRepresentation(this.swapSpaceFree)).append(", ");
            sb.append("heap.memory.used=").append(HealthMonitor.numberToUnitRepresentation(this.memoryUsed)).append(", ");
            sb.append("heap.memory.free=").append(HealthMonitor.numberToUnitRepresentation(this.memoryFree)).append(", ");
            sb.append("heap.memory.total=").append(HealthMonitor.numberToUnitRepresentation(this.memoryTotal)).append(", ");
            sb.append("heap.memory.max=").append(HealthMonitor.numberToUnitRepresentation(this.memoryMax)).append(", ");
            sb.append("heap.memory.used/total=").append(HealthMonitor.percentageString(this.memoryUsedOfTotalPercentage)).append(", ");
            sb.append("heap.memory.used/max=").append(HealthMonitor.percentageString(this.memoryUsedOfMaxPercentage)).append(", ");
            sb.append("minor.gc.count=").append(this.gcMetrics.minorCount).append(", ");
            sb.append("minor.gc.time=").append(this.gcMetrics.minorTime).append("ms, ");
            sb.append("major.gc.count=").append(this.gcMetrics.majorCount).append(", ");
            sb.append("major.gc.time=").append(this.gcMetrics.majorTime).append("ms, ");
            if (this.gcMetrics.unknownCount > 0L) {
                sb.append("unknown.gc.count=").append(this.gcMetrics.unknownCount).append(", ");
                sb.append("unknown.gc.time=").append(this.gcMetrics.unknownTime).append("ms, ");
            }
            sb.append("load.process=").append(String.format("%.2f", this.processCpuLoad)).append("%, ");
            sb.append("load.system=").append(String.format("%.2f", this.systemCpuLoad)).append("%, ");
            sb.append("load.systemAverage=").append(String.format("%.2f", this.systemLoadAverage)).append("%, ");
            sb.append("thread.count=").append(this.threadCount).append(", ");
            sb.append("thread.peakCount=").append(this.peakThreadCount).append(", ");
            sb.append("cluster.timeDiff=").append(this.clusterTimeDiff).append(", ");
            sb.append("event.q.size=").append(this.eventQueueSize).append(", ");
            sb.append("executor.q.async.size=").append(this.asyncExecutorQueueSize).append(", ");
            sb.append("executor.q.client.size=").append(this.clientExecutorQueueSize).append(", ");
            sb.append("executor.q.query.size=").append(this.queryExecutorQueueSize).append(", ");
            sb.append("executor.q.scheduled.size=").append(this.scheduledExecutorQueueSize).append(", ");
            sb.append("executor.q.io.size=").append(this.ioExecutorQueueSize).append(", ");
            sb.append("executor.q.system.size=").append(this.systemExecutorQueueSize).append(", ");
            sb.append("executor.q.operation.size=").append(this.operationServiceOperationExecutorQueueSize).append(", ");
            sb.append("executor.q.priorityOperation.size=").append(this.operationServiceOperationPriorityExecutorQueueSize).append(", ");
            sb.append("executor.q.response.size=").append(this.operationServiceOperationResponseQueueSize).append(", ");
            sb.append("executor.q.response.stats=(").append(this.responseStats).append("), ");
            sb.append("lock.count=").append(this.lockCount).append(", ");
            sb.append("operations.remote.size=").append(this.remoteOperationsCount).append(", ");
            sb.append("operations.running.size=").append(this.runningOperationsCount).append(", ");
            sb.append("operations.executed.count=").append(this.executedOperationsCount).append(", ");
            sb.append("operations.remote.stats=(").append(this.remoteOperationStats).append("), ");
            sb.append("proxy.count=").append(this.proxyCount).append(", ");
            sb.append("clientEndpoint.count=").append(this.clientEndpointCount).append(", ");
            sb.append("connection.active.count=").append(this.activeConnectionCount).append(", ");
            sb.append("connection.count=").append(this.connectionCount);
            return sb.toString();
        }
    }
}

