/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.PartitionAware;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.NIOThread;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.BasicDispatcher;
import com.hazelcast.util.executor.HazelcastManagedThread;
import com.hazelcast.util.executor.ManagedExecutorService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class BasicOperationScheduler {
    public static final int TERMINATION_TIMEOUT_SECONDS = 3;
    final OperationThread[] partitionOperationThreads;
    final OperationThread[] genericOperationThreads;
    private final ILogger logger;
    private final Node node;
    private final ExecutionService executionService;
    private final BasicDispatcher dispatcher;
    private final BlockingQueue genericWorkQueue = new LinkedBlockingQueue();
    private final ConcurrentLinkedQueue genericPriorityWorkQueue = new ConcurrentLinkedQueue();
    private final ResponseThread[] responseThreads;
    private final BlockingQueue<Packet> responseWorkQueue = new LinkedBlockingQueue<Packet>();
    private volatile boolean shutdown;
    private final Runnable priorityTaskTrigger = new Runnable(){

        @Override
        public void run() {
        }

        public String toString() {
            return "TriggerTask";
        }
    };

    public BasicOperationScheduler(Node node, ExecutionService executionService, BasicDispatcher dispatcher) {
        this.executionService = executionService;
        this.logger = node.getLogger(BasicOperationScheduler.class);
        this.node = node;
        this.dispatcher = dispatcher;
        this.genericOperationThreads = new OperationThread[this.getGenericOperationThreadCount()];
        BasicOperationScheduler.initOperationThreads(this.genericOperationThreads, new GenericOperationThreadFactory());
        this.partitionOperationThreads = new OperationThread[this.getPartitionOperationThreadCount()];
        BasicOperationScheduler.initOperationThreads(this.partitionOperationThreads, new PartitionOperationThreadFactory());
        this.responseThreads = new ResponseThread[this.getResponseThreadCount()];
        BasicOperationScheduler.initResponseThreads(this.responseThreads, new ResponseThreadFactory());
        this.logger.info("Starting with " + this.genericOperationThreads.length + " generic operation threads, " + this.partitionOperationThreads.length + " partition operation threads and" + this.responseThreads.length + " response threads.");
    }

    @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private static void initOperationThreads(OperationThread[] operationThreads, ThreadFactory threadFactory) {
        for (int threadId = 0; threadId < operationThreads.length; ++threadId) {
            OperationThread operationThread;
            operationThreads[threadId] = operationThread = (OperationThread)threadFactory.newThread(null);
            operationThread.start();
        }
    }

    @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private static void initResponseThreads(ResponseThread[] responseThreads, ThreadFactory threadFactory) {
        for (int threadId = 0; threadId < responseThreads.length; ++threadId) {
            ResponseThread responseThread;
            responseThreads[threadId] = responseThread = (ResponseThread)threadFactory.newThread(null);
            responseThread.start();
        }
    }

    private int getGenericOperationThreadCount() {
        int threadCount = this.node.getGroupProperties().GENERIC_OPERATION_THREAD_COUNT.getInteger();
        if (threadCount <= 0) {
            int coreSize = Runtime.getRuntime().availableProcessors();
            threadCount = coreSize * 2;
        }
        return threadCount;
    }

    private int getPartitionOperationThreadCount() {
        int threadCount = this.node.getGroupProperties().PARTITION_OPERATION_THREAD_COUNT.getInteger();
        if (threadCount <= 0) {
            int coreSize = Runtime.getRuntime().availableProcessors();
            threadCount = coreSize * 2;
        }
        return threadCount;
    }

    public int getResponseThreadCount() {
        int threadCount = this.node.getGroupProperties().RESPONSE_THREAD_COUNT.getInteger();
        if (threadCount <= 0) {
            int coreSize;
            threadCount = coreSize = Runtime.getRuntime().availableProcessors();
        }
        return threadCount;
    }

    int getPartitionIdForExecution(Operation op) {
        return op instanceof PartitionAwareOperation ? op.getPartitionId() : -1;
    }

    boolean isAllowedToRunInCurrentThread(Operation op) {
        return this.isAllowedToRunInCurrentThread(this.getPartitionIdForExecution(op));
    }

    boolean isInvocationAllowedFromCurrentThread(Operation op) {
        return this.isInvocationAllowedFromCurrentThread(this.getPartitionIdForExecution(op));
    }

    boolean isAllowedToRunInCurrentThread(int partitionId) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof NIOThread) {
            return false;
        }
        if (partitionId < 0) {
            return true;
        }
        if (!(currentThread instanceof OperationThread)) {
            return false;
        }
        OperationThread operationThread = (OperationThread)currentThread;
        if (!operationThread.isPartitionSpecific) {
            return false;
        }
        int threadId = operationThread.threadId;
        return this.toPartitionThreadIndex(partitionId) == threadId;
    }

    boolean isInvocationAllowedFromCurrentThread(int partitionId) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof OperationThread) {
            OperationThread operationThread;
            if (partitionId > -1 && (operationThread = (OperationThread)currentThread).isPartitionSpecific) {
                int threadId = operationThread.threadId;
                return this.toPartitionThreadIndex(partitionId) == threadId;
            }
            return true;
        }
        return !(currentThread instanceof NIOThread);
    }

    public int getOperationExecutorQueueSize() {
        int size = 0;
        for (OperationThread t : this.partitionOperationThreads) {
            size += t.workQueue.size();
        }
        return size += this.genericWorkQueue.size();
    }

    public int getPriorityOperationExecutorQueueSize() {
        int size = 0;
        for (OperationThread t : this.partitionOperationThreads) {
            size += t.priorityWorkQueue.size();
        }
        return size += this.genericPriorityWorkQueue.size();
    }

    public int getResponseQueueSize() {
        return this.responseWorkQueue.size();
    }

    public void execute(Operation op) {
        String executorName = op.getExecutorName();
        if (executorName == null) {
            int partitionId = this.getPartitionIdForExecution(op);
            boolean hasPriority = op.isUrgent();
            this.execute(op, partitionId, hasPriority);
        } else {
            this.executeOnExternalExecutor(op, executorName);
        }
    }

    public void execute(Runnable task, int partitionId) {
        this.execute(task, partitionId, false);
    }

    private void executeOnExternalExecutor(Operation op, String executorName) {
        ManagedExecutorService executor = this.executionService.getExecutor(executorName);
        if (executor == null) {
            throw new IllegalStateException("Could not found executor with name: " + executorName);
        }
        if (op instanceof PartitionAware) {
            throw new IllegalStateException("PartitionAwareOperation " + op + " can't be executed on a " + "custom executor with name: " + executorName);
        }
        if (op instanceof UrgentSystemOperation) {
            throw new IllegalStateException("UrgentSystemOperation " + op + " can't be executed on a custom " + "executor with name: " + executorName);
        }
        executor.execute(new LocalOperationProcessor(op));
    }

    public void execute(Packet packet) {
        block4: {
            try {
                if (packet.isHeaderSet(1)) {
                    this.responseWorkQueue.add(packet);
                } else {
                    int partitionId = packet.getPartitionId();
                    boolean hasPriority = packet.isUrgent();
                    this.execute(packet, partitionId, hasPriority);
                }
            }
            catch (RejectedExecutionException e) {
                if (!this.node.nodeEngine.isActive()) break block4;
                throw e;
            }
        }
    }

    private void execute(Object task, int partitionId, boolean priority) {
        Queue priorityWorkQueue;
        BlockingQueue workQueue;
        if (task == null) {
            throw new NullPointerException();
        }
        if (partitionId < 0) {
            workQueue = this.genericWorkQueue;
            priorityWorkQueue = this.genericPriorityWorkQueue;
        } else {
            OperationThread partitionOperationThread = this.partitionOperationThreads[this.toPartitionThreadIndex(partitionId)];
            workQueue = partitionOperationThread.workQueue;
            priorityWorkQueue = partitionOperationThread.priorityWorkQueue;
        }
        if (priority) {
            this.offerWork(priorityWorkQueue, task);
            this.offerWork(workQueue, this.priorityTaskTrigger);
        } else {
            this.offerWork(workQueue, task);
        }
    }

    private void offerWork(Queue queue, Object task) {
        boolean offer = queue.offer(task);
        if (!offer) {
            this.logger.severe("Failed to offer " + task + " to BasicOperationScheduler due to overload");
        }
    }

    private int toPartitionThreadIndex(int partitionId) {
        return partitionId % this.partitionOperationThreads.length;
    }

    public void shutdown() {
        this.shutdown = true;
        BasicOperationScheduler.interruptAll(this.partitionOperationThreads);
        BasicOperationScheduler.interruptAll(this.genericOperationThreads);
        BasicOperationScheduler.interruptAll(this.responseThreads);
        BasicOperationScheduler.awaitTermination(this.partitionOperationThreads);
        BasicOperationScheduler.awaitTermination(this.genericOperationThreads);
        BasicOperationScheduler.awaitTermination(this.responseThreads);
    }

    private static void interruptAll(Thread[] threads) {
        for (Thread thread : threads) {
            thread.interrupt();
        }
    }

    private static void awaitTermination(Thread[] threads) {
        for (Thread thread : threads) {
            try {
                thread.join(TimeUnit.SECONDS.toMillis(3L));
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "BasicOperationScheduler{node=" + this.node.getThisAddress() + '}';
    }

    private final class LocalOperationProcessor
    implements Runnable {
        private final Operation op;

        private LocalOperationProcessor(Operation op) {
            this.op = op;
        }

        @Override
        public void run() {
            BasicOperationScheduler.this.dispatcher.dispatch(this.op);
        }
    }

    private class ResponseThread
    extends Thread {
        public ResponseThread(String threadName) {
            super(((BasicOperationScheduler)BasicOperationScheduler.this).node.threadGroup, threadName);
            this.setContextClassLoader(BasicOperationScheduler.this.node.getConfigClassLoader());
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (Throwable t) {
                BasicOperationScheduler.this.logger.severe(t);
            }
        }

        private void doRun() {
            while (true) {
                Object task;
                try {
                    task = BasicOperationScheduler.this.responseWorkQueue.take();
                }
                catch (InterruptedException e) {
                    if (!BasicOperationScheduler.this.shutdown) continue;
                    return;
                }
                if (BasicOperationScheduler.this.shutdown) {
                    return;
                }
                this.process(task);
            }
        }

        private void process(Object task) {
            try {
                BasicOperationScheduler.this.dispatcher.dispatch(task);
            }
            catch (Exception e) {
                BasicOperationScheduler.this.logger.severe("Failed to process task: " + task + " on partitionThread:" + this.getName());
            }
        }
    }

    final class OperationThread
    extends HazelcastManagedThread {
        private final int threadId;
        private final boolean isPartitionSpecific;
        private final BlockingQueue workQueue;
        private final Queue priorityWorkQueue;

        public OperationThread(String name, boolean isPartitionSpecific, int threadId, BlockingQueue workQueue, Queue priorityWorkQueue) {
            super(((BasicOperationScheduler)BasicOperationScheduler.this).node.threadGroup, name);
            this.setContextClassLoader(BasicOperationScheduler.this.node.getConfigClassLoader());
            this.isPartitionSpecific = isPartitionSpecific;
            this.workQueue = workQueue;
            this.priorityWorkQueue = priorityWorkQueue;
            this.threadId = threadId;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (Throwable t) {
                BasicOperationScheduler.this.logger.severe(t);
            }
        }

        private void doRun() {
            while (true) {
                Object task;
                try {
                    task = this.workQueue.take();
                }
                catch (InterruptedException e) {
                    if (!BasicOperationScheduler.this.shutdown) continue;
                    return;
                }
                if (BasicOperationScheduler.this.shutdown) {
                    return;
                }
                this.processPriorityMessages();
                this.process(task);
            }
        }

        private void process(Object task) {
            try {
                BasicOperationScheduler.this.dispatcher.dispatch(task);
            }
            catch (Exception e) {
                BasicOperationScheduler.this.logger.severe("Failed to process task: " + task + " on partitionThread:" + this.getName());
            }
        }

        private void processPriorityMessages() {
            Object task;
            while ((task = this.priorityWorkQueue.poll()) != null) {
                this.process(task);
            }
            return;
        }
    }

    private class ResponseThreadFactory
    implements ThreadFactory {
        private int threadId;

        private ResponseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable ignore) {
            String threadName = BasicOperationScheduler.this.node.getThreadPoolNamePrefix("response") + this.threadId;
            ResponseThread thread = new ResponseThread(threadName);
            ++this.threadId;
            return thread;
        }
    }

    private class PartitionOperationThreadFactory
    implements ThreadFactory {
        private int threadId;

        private PartitionOperationThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable ignore) {
            String threadName = BasicOperationScheduler.this.node.getThreadPoolNamePrefix("partition-operation") + this.threadId;
            LinkedBlockingQueue workQueue = new LinkedBlockingQueue();
            ConcurrentLinkedQueue priorityWorkQueue = new ConcurrentLinkedQueue();
            OperationThread thread = new OperationThread(threadName, true, this.threadId, workQueue, priorityWorkQueue);
            ++this.threadId;
            return thread;
        }
    }

    private class GenericOperationThreadFactory
    implements ThreadFactory {
        private int threadId;

        private GenericOperationThreadFactory() {
        }

        @Override
        public OperationThread newThread(Runnable ignore) {
            String threadName = BasicOperationScheduler.this.node.getThreadPoolNamePrefix("generic-operation") + this.threadId;
            OperationThread thread = new OperationThread(threadName, false, this.threadId, BasicOperationScheduler.this.genericWorkQueue, BasicOperationScheduler.this.genericPriorityWorkQueue);
            ++this.threadId;
            return thread;
        }
    }
}

