/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.MergeOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class MapSplitBrainHandlerService
implements SplitBrainHandlerService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public MapSplitBrainHandlerService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public Runnable prepareMergeRunnable() {
        long now = this.getNow();
        Map<String, MapContainer> mapContainers = this.mapServiceContext.getMapContainers();
        HashMap<MapContainer, Collection<Record>> recordMap = new HashMap<MapContainer, Collection<Record>>(mapContainers.size());
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        Address thisAddress = this.nodeEngine.getClusterService().getThisAddress();
        for (MapContainer mapContainer : mapContainers.values()) {
            for (int i = 0; i < partitionCount; ++i) {
                RecordStore recordStore = this.mapServiceContext.getPartitionContainer(i).getRecordStore(mapContainer.getName());
                if (thisAddress.equals(partitionService.getPartitionOwner(i))) {
                    ArrayList<Record> records = (ArrayList<Record>)recordMap.get(mapContainer);
                    if (records == null) {
                        records = new ArrayList<Record>();
                        recordMap.put(mapContainer, records);
                    }
                    Iterator<Record> iterator = recordStore.iterator(now);
                    while (iterator.hasNext()) {
                        Record record = iterator.next();
                        records.add(record);
                    }
                }
                recordStore.reset();
            }
        }
        return new Merger(recordMap);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private class Merger
    implements Runnable {
        Map<MapContainer, Collection<Record>> recordMap;

        public Merger(Map<MapContainer, Collection<Record>> recordMap) {
            this.recordMap = recordMap;
        }

        @Override
        public void run() {
            for (final MapContainer mapContainer : this.recordMap.keySet()) {
                Collection<Record> recordList = this.recordMap.get(mapContainer);
                String mergePolicyName = mapContainer.getMapConfig().getMergePolicy();
                final MapMergePolicy finalMergePolicy = MapSplitBrainHandlerService.this.mapServiceContext.getMergePolicyProvider().getMergePolicy(mergePolicyName);
                for (final Record record : recordList) {
                    MapSplitBrainHandlerService.this.nodeEngine.getExecutionService().submit("hz:map-merge", new Runnable(){

                        @Override
                        public void run() {
                            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(record.getKey(), MapSplitBrainHandlerService.this.mapServiceContext.toData(record.getValue()), record);
                            MergeOperation operation = new MergeOperation(mapContainer.getName(), record.getKey(), entryView, finalMergePolicy);
                            try {
                                int partitionId = MapSplitBrainHandlerService.this.nodeEngine.getPartitionService().getPartitionId(record.getKey());
                                InternalCompletableFuture f = MapSplitBrainHandlerService.this.nodeEngine.getOperationService().invokeOnPartition(MapSplitBrainHandlerService.this.mapServiceContext.serviceName(), operation, partitionId);
                                f.get();
                            }
                            catch (Throwable t) {
                                throw ExceptionUtil.rethrow(t);
                            }
                        }
                    });
                }
            }
        }
    }
}

