/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.ReplicatedMapService;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class ReplicatedMapClearOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private String mapName;
    private boolean emptyReplicationQueue;

    public ReplicatedMapClearOperation() {
    }

    public ReplicatedMapClearOperation(String mapName, boolean emptyReplicationQueue) {
        this.mapName = mapName;
        this.emptyReplicationQueue = emptyReplicationQueue;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore recordStore = service.getReplicatedRecordStore(this.mapName, false);
        if (recordStore != null) {
            recordStore.clear(false, this.emptyReplicationQueue);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeBoolean(this.emptyReplicationQueue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.emptyReplicationQueue = in.readBoolean();
    }
}

