/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.client;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.client.ReplicatedMapPortableHook;
import java.io.IOException;

public class ReplicatedMapPortableEntryEvent
implements Portable {
    private Object key;
    private Object value;
    private Object oldValue;
    private EntryEventType eventType;
    private String uuid;

    ReplicatedMapPortableEntryEvent() {
    }

    ReplicatedMapPortableEntryEvent(Object key, Object value, Object oldValue, EntryEventType eventType, String uuid) {
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.eventType = eventType;
        this.uuid = uuid;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public EntryEventType getEventType() {
        return this.eventType;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("e", this.eventType.getType());
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.key);
        out.writeObject(this.value);
        out.writeObject(this.oldValue);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.eventType = EntryEventType.getByType(reader.readInt("e"));
        this.uuid = reader.readUTF("u");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readObject();
        this.value = in.readObject();
        this.oldValue = in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }
}

