/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class ClientReplicatedMapPutTtlRequest
extends AbstractReplicatedMapClientRequest {
    private Object key;
    private Object value;
    private long ttlMillis;

    ClientReplicatedMapPutTtlRequest() {
        super(null);
    }

    public ClientReplicatedMapPutTtlRequest(String mapName, Object key, Object value, long ttlMillis) {
        super(mapName);
        this.key = key;
        this.value = value;
        this.ttlMillis = ttlMillis;
    }

    public Object call() throws Exception {
        ReplicatedRecordStore recordStore = this.getReplicatedRecordStore();
        return recordStore.put(this.key, this.value, this.ttlMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("ttlMillis", this.ttlMillis);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.key);
        out.writeObject(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.ttlMillis = reader.readLong("ttlMillis");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readObject();
        this.value = in.readObject();
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "put");
    }

    @Override
    public String getMethodName() {
        return "put";
    }

    @Override
    public Object[] getParameters() {
        if (this.ttlMillis == 0L) {
            return new Object[]{this.key, this.value};
        }
        return new Object[]{this.key, this.value, this.ttlMillis, TimeUnit.MILLISECONDS};
    }
}

