/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.AllPartitionsClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.MapPutAllOperationFactory;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public class MapPutAllRequest
extends AllPartitionsClientRequest
implements Portable,
SecureRequest {
    protected String name;
    private MapEntrySet entrySet;

    public MapPutAllRequest() {
    }

    public MapPutAllRequest(String name, MapEntrySet entrySet) {
        this.name = name;
        this.entrySet = entrySet;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 40;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MapPutAllOperationFactory(this.name, this.entrySet);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapService mapService = (MapService)this.getService();
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            Object result = mapService.getMapServiceContext().toObject(entry.getValue());
            if (!(result instanceof Throwable)) continue;
            throw ExceptionUtil.rethrow((Throwable)result);
        }
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput output = writer.getRawDataOutput();
        this.entrySet.writeData(output);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput input = reader.getRawDataInput();
        this.entrySet = new MapEntrySet();
        this.entrySet.readData(input);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        HashMap<Data, Data> map = new HashMap<Data, Data>();
        for (Map.Entry<Data, Data> entry : this.entrySet.getEntrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new Object[]{map};
    }
}

