/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.util.ConstructorFunction;
import java.util.Properties;

class MapManagedService
implements ManagedService {
    private MapServiceContext mapServiceContext;

    MapManagedService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.mapServiceContext.initPartitionsContainers();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor(this.mapServiceContext.serviceName(), new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

                @Override
                public LockStoreInfo createNew(ObjectNamespace key) {
                    final MapContainer mapContainer = MapManagedService.this.mapServiceContext.getMapContainer(key.getObjectName());
                    return new LockStoreInfo(){

                        @Override
                        public int getBackupCount() {
                            return mapContainer.getBackupCount();
                        }

                        @Override
                        public int getAsyncBackupCount() {
                            return mapContainer.getAsyncBackupCount();
                        }
                    };
                }
            });
        }
        this.mapServiceContext.getExpirationManager().start();
    }

    @Override
    public void reset() {
        this.mapServiceContext.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            MapServiceContext mapServiceContext = this.mapServiceContext;
            mapServiceContext.flushMaps();
            mapServiceContext.destroyMapStores();
            mapServiceContext.clearPartitions();
            mapServiceContext.getNearCacheProvider().clear();
            mapServiceContext.getMapContainers().clear();
        }
    }
}

