/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.AbstractEvictableRecordStore;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.RecordStoreLoader;
import com.hazelcast.map.mapstore.MapDataStore;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultRecordStore
extends AbstractEvictableRecordStore
implements RecordStore {
    private final LockStore lockStore = this.createLockStore();
    private final MapDataStore<Data, Object> mapDataStore;
    private final RecordStoreLoader recordStoreLoader;

    public DefaultRecordStore(MapContainer mapContainer, int partitionId) {
        super(mapContainer, partitionId);
        this.mapDataStore = mapContainer.getMapStoreManager().getMapDataStore(partitionId);
        this.recordStoreLoader = this.createRecordStoreLoader();
        this.recordStoreLoader.loadAllKeys();
    }

    @Override
    public boolean isLoaded() {
        return this.recordStoreLoader.isLoaded();
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.recordStoreLoader.setLoaded(loaded);
    }

    @Override
    public void checkIfLoaded() {
        Throwable throwable = null;
        RecordStoreLoader recordStoreLoader = this.recordStoreLoader;
        Throwable exception = recordStoreLoader.getExceptionOrNull();
        if (exception == null && !recordStoreLoader.isLoaded()) {
            throwable = new RetryableHazelcastException("Map is not ready!!!");
        } else if (exception != null) {
            throwable = exception;
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void flush() {
        Collection processedKeys = this.mapDataStore.flush();
        for (Data key : processedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            record.onStore();
        }
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.records.get(key);
    }

    @Override
    public void putRecord(Data key, Record record) {
        Record existingRecord = this.records.put(key, record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(existingRecord));
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
    }

    @Override
    public Record putBackup(Data key, Object value) {
        return this.putBackup(key, value, -1L);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        this.mapDataStore.addBackup(key, value, now);
        return record;
    }

    @Override
    public void deleteRecord(Data key) {
        Record record = (Record)this.records.remove(key);
        if (record != null) {
            record.invalidate();
        }
    }

    @Override
    public Iterator<Record> iterator() {
        return new AbstractEvictableRecordStore.ReadOnlyRecordIterator(this.records.values());
    }

    @Override
    public Iterator<Record> loadAwareIterator() {
        this.checkIfLoaded();
        return this.iterator();
    }

    @Override
    public Map<Data, Record> getRecordMap() {
        return this.records;
    }

    @Override
    public void clearPartition() {
        IndexService indexService;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.mapDataStore.reset();
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.records.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        for (Record record : this.records.values()) {
            if (this.nullIfExpired(record) == null || !this.mapServiceContext.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        this.postReadCleanUp(now);
        return false;
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        this.checkIfLoaded();
        HashMap<Data, Data> temp = new HashMap<Data, Data>(this.records.size());
        for (Record record : this.records.values()) {
            if ((record = this.nullIfExpired(record)) == null) continue;
            Data key = record.getKey();
            Data value = this.toData(record.getValue());
            temp.put(key, value);
        }
        return temp.entrySet();
    }

    @Override
    public Map.Entry<Data, Object> getMapEntry(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        record = this.nullIfExpired(record);
        if (record == null) {
            record = this.getRecordInternal(dataKey, true);
        } else {
            this.accessRecord(record);
        }
        Object value = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, value);
    }

    @Override
    public Map.Entry<Data, Object> getMapEntryForBackup(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        record = this.nullIfExpired(record);
        if (record == null) {
            record = this.getRecordInternal(dataKey, false);
        } else {
            this.accessRecord(record);
        }
        Object data = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, data);
    }

    private Record getRecordInternal(Data key, boolean enableIndex) {
        Record record = null;
        Object value = this.mapDataStore.load(key);
        if (value != null) {
            record = this.createRecord(key, value, this.getNow());
            this.records.put(key, record);
            if (enableIndex) {
                this.saveIndex(record);
            }
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        return record;
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        HashSet<Data> keySet = new HashSet<Data>(this.records.size());
        for (Record record : this.records.values()) {
            if ((record = this.nullIfExpired(record)) == null) continue;
            keySet.add(record.getKey());
        }
        return keySet;
    }

    @Override
    public Collection<Data> valuesData() {
        this.checkIfLoaded();
        ArrayList<Data> values = new ArrayList<Data>(this.records.size());
        for (Record record : this.records.values()) {
            if ((record = this.nullIfExpired(record)) == null) continue;
            values.add(this.toData(record.getValue()));
        }
        return values;
    }

    @Override
    public int clear() {
        this.checkIfLoaded();
        this.resetSizeEstimator();
        Set<Data> lockedKeys = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        Set<Data> keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockedRecords.keySet());
        this.mapDataStore.removeAll(keysToDelete);
        int numOfClearedEntries = keysToDelete.size();
        this.removeIndex(keysToDelete);
        this.clearRecordsMap(lockedRecords);
        this.resetAccessSequenceNumber();
        this.mapDataStore.reset();
        return numOfClearedEntries;
    }

    @Override
    public void reset() {
        this.checkIfLoaded();
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.mapDataStore.reset();
    }

    @Override
    public Object evict(Data key) {
        this.checkIfLoaded();
        return this.evictInternal(key);
    }

    @Override
    Object evictInternal(Data key) {
        Record record = (Record)this.records.get(key);
        Object value = null;
        if (record != null) {
            value = record.getValue();
            long lastUpdateTime = record.getLastUpdateTime();
            this.mapDataStore.flush(key, value, lastUpdateTime);
            this.mapServiceContext.interceptRemove(this.name, value);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.deleteRecord(key);
            this.removeIndex(key);
        }
        return value;
    }

    @Override
    public int evictAll() {
        this.checkIfLoaded();
        int size = this.size();
        Set<Data> keysToPreserve = this.evictAllInternal();
        this.removeIndexByPreservingKeys(keysToPreserve);
        return size - keysToPreserve.size();
    }

    @Override
    public void evictAllBackup() {
        this.evictAllInternal();
    }

    private Set<Data> evictAllInternal() {
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        Set<Data> keysToPreserve = Collections.emptySet();
        Map<Data, Record> recordsToPreserve = this.getLockedRecords();
        if (!recordsToPreserve.isEmpty()) {
            keysToPreserve = recordsToPreserve.keySet();
            this.updateSizeEstimator(this.calculateRecordHeapCost(recordsToPreserve.values()));
        }
        this.flush(recordsToPreserve);
        this.clearRecordsMap(recordsToPreserve);
        return keysToPreserve;
    }

    private void flush(Map<Data, Record> excludeRecords) {
        for (Record record : this.records.values()) {
            if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
            Data key = record.getKey();
            long lastUpdateTime = record.getLastUpdateTime();
            this.mapDataStore.flush(key, record.getValue(), lastUpdateTime);
        }
    }

    private void removeIndexByPreservingKeys(Set<Data> keysToPreserve) {
        Set<Data> currentKeySet = this.records.keySet();
        currentKeySet.removeAll(keysToPreserve);
        this.removeIndex(currentKeySet);
    }

    private Map<Data, Record> getLockedRecords() {
        if (this.lockStore == null) {
            return Collections.emptyMap();
        }
        Set<Data> lockedKeys = this.lockStore.getLockedKeys();
        if (lockedKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
        }
        return lockedRecords;
    }

    @Override
    public void removeBackup(Data key) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            return;
        }
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.deleteRecord(key);
        this.mapDataStore.removeBackup(key, now);
    }

    @Override
    public boolean remove(Data key, Object testValue) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        boolean removed = false;
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapServiceContext.compare(this.name, testValue, oldValue)) {
            this.mapServiceContext.interceptRemove(this.name, oldValue);
            this.removeIndex(key);
            this.mapDataStore.remove(key, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.deleteRecord(key);
            removed = true;
        }
        return removed;
    }

    @Override
    public Object remove(Data key) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                this.removeIndex(key);
                this.mapDataStore.remove(key, now);
            }
        } else {
            oldValue = record.getValue();
            if ((oldValue = this.mapServiceContext.interceptRemove(this.name, oldValue)) != null) {
                this.removeIndex(key);
                this.mapDataStore.remove(key, now);
                this.onStore(record);
            }
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.deleteRecord(key);
        }
        return oldValue;
    }

    @Override
    public Object get(Data key) {
        this.checkIfLoaded();
        long now = this.getNow();
        Object value = this.get0(key, now);
        this.postReadCleanUp(now);
        return value;
    }

    private Object get0(Data key, long now) {
        Object value;
        Record record = (Record)this.records.get(key);
        if ((record = this.nullIfExpired(record)) == null) {
            value = this.mapDataStore.load(key);
            if (value != null) {
                record = this.createRecord(key, value, now);
                this.records.put(key, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            }
        } else {
            this.accessRecord(record, now);
            value = record.getValue();
        }
        value = this.mapServiceContext.interceptGet(this.name, value);
        return value;
    }

    @Override
    public MapEntrySet getAll(Set<Data> keys) {
        this.checkIfLoaded();
        long now = this.getNow();
        MapEntrySet mapEntrySet = new MapEntrySet();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Record record = (Record)this.records.get(key);
            if ((record = this.nullIfExpired(record)) == null) continue;
            this.addMapEntrySet(record.getKey(), record.getValue(), mapEntrySet);
            iterator.remove();
        }
        this.addMapEntrySet(this.mapDataStore.loadAll(keys), mapEntrySet);
        this.postReadCleanUp(now);
        return mapEntrySet;
    }

    private void addMapEntrySet(Object key, Object value, MapEntrySet mapEntrySet) {
        if (key == null || value == null) {
            return;
        }
        Data dataKey = this.mapServiceContext.toData(key);
        Data dataValue = this.mapServiceContext.toData(value);
        mapEntrySet.add(dataKey, dataValue);
    }

    private void addMapEntrySet(Map<Object, Object> entries, MapEntrySet mapEntrySet) {
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            this.addMapEntrySet(entry.getKey(), entry.getValue(), mapEntrySet);
        }
    }

    @Override
    public boolean containsKey(Data key) {
        boolean contains;
        Object value;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = (Record)this.records.get(key);
        record = this.nullIfExpired(record);
        if (record == null && (value = this.mapDataStore.load(key)) != null) {
            record = this.createRecord(key, value, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record, now);
        }
        this.postReadCleanUp(now);
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Data key = entry.getKey();
        Object value = entry.getValue();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        } else {
            Object oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        }
    }

    @Override
    public Object put(Data key, Object value, long ttl) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.saveIndex(record);
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
            this.saveIndex(record);
        }
        return oldValue;
    }

    @Override
    public boolean set(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            newRecord = true;
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return newRecord;
    }

    @Override
    public boolean merge(Data key, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Object newValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            Object notExistingKey = this.mapServiceContext.toObject(key);
            EntryView nullEntryView = EntryViews.createNullEntryView(notExistingKey);
            newValue = mergePolicy.merge(this.name, mergingEntry, nullEntryView);
            if (newValue == null) {
                return false;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            record = this.createRecord(key, newValue, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            Object oldValue = record.getValue();
            EntryView existingEntry = EntryViews.createLazyEntryView(record.getKey(), record.getValue(), record, this.serializationService, mergePolicy);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.removeIndex(key);
                this.mapDataStore.remove(key, now);
                this.onStore(record);
                this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
                this.deleteRecord(key);
                return true;
            }
            if (this.mapServiceContext.compare(this.name, newValue, oldValue)) {
                return true;
            }
            newValue = this.mapDataStore.add(key, newValue, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.recordFactory.setValue(record, newValue);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data key, Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null || record.getValue() == null) {
            return null;
        }
        Object oldValue = record.getValue();
        value = this.mapServiceContext.interceptPut(this.name, oldValue, value);
        value = this.mapDataStore.add(key, value, now);
        this.onStore(record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.setRecordValue(record, value, now);
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data key, Object testValue, Object newValue) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            return false;
        }
        if (!this.mapServiceContext.compare(this.name, record.getValue(), testValue)) {
            return false;
        }
        newValue = this.mapServiceContext.interceptPut(this.name, record.getValue(), newValue);
        newValue = this.mapDataStore.add(key, newValue, now);
        this.onStore(record);
        this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
        this.setRecordValue(record, newValue, now);
        this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.mapDataStore.addTransient(key, now);
    }

    @Override
    public Object putFromLoad(Data key, Object value) {
        return this.putFromLoad(key, value, -1L);
    }

    @Override
    public Object putFromLoad(Data key, Object value, long ttl) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean tryPut(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
        } else {
            value = this.mapServiceContext.interceptPut(this.name, record.getValue(), value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            this.updateSizeEstimator(-this.calculateRecordHeapCost(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return true;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl) {
        Object oldValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            oldValue = this.mapDataStore.load(key);
            if (oldValue != null) {
                record = this.createRecord(key, oldValue, now);
                this.records.put(key, record);
                this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            }
        } else {
            this.accessRecord(record, now);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapServiceContext.interceptPut(this.name, null, value);
            value = this.mapDataStore.add(key, value, now);
            this.onStore(record);
            record = this.createRecord(key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordHeapCost(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public void loadAllFromStore(List<Data> keys, boolean replaceExistingValues) {
        if (keys.isEmpty()) {
            return;
        }
        this.recordStoreLoader.loadKeys(keys, replaceExistingValues);
    }

    @Override
    public MapDataStore<Data, Object> getMapDataStore() {
        return this.mapDataStore;
    }
}

